/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.core.gui;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class GuiScrollPanel
extends GuiButton {
    List<GuiButton> buttonList = new ArrayList<GuiButton>();
    public GuiButton selectedButton;
    protected float sliderValue = 0.0f;
    protected float sliderSize = 1.0f;
    protected float distToMouse = 0.0f;
    protected boolean dragged = false;
    protected int padding;
    protected int[] buttonHeight;
    protected int right;
    protected int bottom;

    public GuiScrollPanel(int id, int xPosition, int yPosition, int width, int height, int padding) {
        super(id, xPosition, yPosition, width, height, "");
        this.padding = padding;
        this.right = xPosition + width;
        this.bottom = yPosition + height;
    }

    protected int func_73738_a(boolean par1) {
        return 0;
    }

    protected int getButtonHeight(GuiButton guiButton) {
        try {
            return (Integer)ReflectionHelper.getPrivateValue(GuiButton.class, (Object)guiButton, (int)2);
        }
        catch (Exception e) {
            return 20;
        }
    }

    public void updateSliderSize() {
        int contentHeight = this.field_73745_b;
        int totalPadding = this.padding * 2;
        this.buttonHeight = new int[this.buttonList.size()];
        for (int n = 0; n < this.buttonList.size(); ++n) {
            GuiButton guiButton = this.buttonList.get(n);
            this.buttonHeight[n] = this.getButtonHeight(guiButton);
            if (guiButton.field_73743_d + this.buttonHeight[n] + totalPadding <= contentHeight) continue;
            contentHeight = guiButton.field_73743_d + this.buttonHeight[n] + totalPadding;
        }
        this.sliderSize = (float)this.field_73745_b / (float)contentHeight;
        if (this.sliderSize > 1.0f) {
            this.sliderSize = 1.0f;
        }
    }

    public void func_73737_a(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.field_73748_h) {
            this.func_73733_a(this.field_73746_c, this.field_73743_d, this.right, this.bottom, -1072689136, -804253680);
            float xScale = (float)minecraft.field_71443_c / (float)minecraft.field_71462_r.field_73880_f;
            float yScale = (float)minecraft.field_71440_d / (float)minecraft.field_71462_r.field_73881_g;
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((int)((float)this.field_73746_c * xScale)), (int)((int)((float)(minecraft.field_71462_r.field_73881_g - this.bottom) * yScale)), (int)((int)((float)this.field_73747_a * xScale)), (int)((int)((float)this.field_73745_b * yScale)));
            int xOffset = this.field_73746_c;
            int yOffset = this.field_73743_d + this.padding - (int)(this.sliderValue * (float)this.field_73745_b / this.sliderSize + 0.5f);
            for (int n = 0; n < this.buttonList.size(); ++n) {
                GuiButton guiButton = this.buttonList.get(n);
                if (guiButton.field_73743_d + yOffset + this.buttonHeight[n] < this.field_73743_d || guiButton.field_73743_d + yOffset > this.bottom) continue;
                int xBuffer = guiButton.field_73746_c;
                int yBuffer = guiButton.field_73743_d;
                guiButton.field_73746_c += xOffset;
                guiButton.field_73743_d += yOffset;
                guiButton.func_73737_a(minecraft, mouseX, mouseY);
                guiButton.field_73746_c = xBuffer;
                guiButton.field_73743_d = yBuffer;
            }
            GL11.glDisable((int)3089);
            this.func_73739_b(minecraft, mouseX, mouseY);
            this.func_73733_a(this.field_73746_c, this.field_73743_d, this.right, this.field_73743_d + 4, -16777216, 0);
            this.func_73733_a(this.field_73746_c, this.bottom - 4, this.right, this.bottom, 0, -16777216);
            GuiScrollPanel.func_73734_a((int)(this.right - 6), (int)this.field_73743_d, (int)this.right, (int)this.bottom, (int)-16777216);
            int sliderTop = this.field_73743_d + (int)(this.sliderValue * (float)this.field_73745_b);
            int sliderBottom = this.field_73743_d + (int)((this.sliderValue + this.sliderSize) * (float)this.field_73745_b);
            if (this.dragged) {
                GuiScrollPanel.func_73734_a((int)(this.right - 6), (int)sliderTop, (int)this.right, (int)sliderBottom, (int)-8487298);
                GuiScrollPanel.func_73734_a((int)(this.right - 6), (int)sliderTop, (int)(this.right - 1), (int)(sliderBottom - 1), (int)-11250604);
            } else {
                GuiScrollPanel.func_73734_a((int)(this.right - 6), (int)sliderTop, (int)this.right, (int)sliderBottom, (int)-11250604);
                GuiScrollPanel.func_73734_a((int)(this.right - 6), (int)sliderTop, (int)(this.right - 1), (int)(sliderBottom - 1), (int)-8487298);
            }
        }
    }

    public boolean func_73736_c(Minecraft minecraft, int mouseX, int mouseY) {
        if (super.func_73736_c(minecraft, mouseX, mouseY)) {
            if (mouseX >= this.right - 6) {
                float mouseValue = (float)(mouseY - this.field_73743_d) / (float)this.field_73745_b;
                if (mouseValue < this.sliderValue) {
                    this.sliderValue = mouseValue;
                    this.distToMouse = 0.0f;
                } else if (mouseValue > this.sliderValue + this.sliderSize) {
                    this.sliderValue = mouseValue + this.sliderSize;
                    this.distToMouse = this.sliderSize;
                } else {
                    this.distToMouse = mouseValue - this.sliderValue;
                }
                this.dragged = true;
                return true;
            }
            int xOffset = this.field_73746_c;
            int yOffset = this.field_73743_d + this.padding - (int)(this.sliderValue * (float)this.field_73745_b / this.sliderSize + 0.5f);
            for (int n = 0; n < this.buttonList.size(); ++n) {
                GuiButton guiButton = this.buttonList.get(n);
                if (guiButton.field_73743_d + yOffset + 20 < this.field_73743_d || guiButton.field_73743_d + yOffset > this.bottom) continue;
                int xBuffer = guiButton.field_73746_c;
                int yBuffer = guiButton.field_73743_d;
                guiButton.field_73746_c += xOffset;
                guiButton.field_73743_d += yOffset;
                if (guiButton.func_73736_c(minecraft, mouseX, mouseY)) {
                    this.selectedButton = guiButton;
                    guiButton.field_73746_c = xBuffer;
                    guiButton.field_73743_d = yBuffer;
                    return true;
                }
                guiButton.field_73746_c = xBuffer;
                guiButton.field_73743_d = yBuffer;
            }
        }
        return false;
    }

    protected void func_73739_b(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.dragged) {
            this.sliderValue = (float)(mouseY - this.field_73743_d) / (float)this.field_73745_b - this.distToMouse;
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            } else if (this.sliderValue > 1.0f - this.sliderSize) {
                this.sliderValue = 1.0f - this.sliderSize;
            }
        }
    }

    public void func_73740_a(int mouseX, int mouseY) {
        if (this.selectedButton != null) {
            this.selectedButton.func_73740_a(mouseX, mouseY);
            this.selectedButton = null;
        }
        this.dragged = false;
    }

    public int getWidth() {
        return this.field_73747_a;
    }

    public int getHeight() {
        return this.field_73745_b;
    }
}

