/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSmallButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.Configuration;
import poersch.minecraft.core.gui.GuiScrollPanel;
import poersch.minecraft.core.gui.GuiSlider;
import poersch.minecraft.core.gui.ISettingsUpdatedCallback;
import poersch.minecraft.core.options.Option;
import poersch.minecraft.core.options.OptionInterval;

@SideOnly(value=Side.CLIENT)
public class GuiModSettings
extends GuiScreen {
    private final String screenTitle;
    private final Option[] modOptions;
    private final Configuration modConfig;
    private final ISettingsUpdatedCallback callback;
    private GuiScrollPanel optionPanel;

    public GuiModSettings(String modName, Option[] modOptions, Configuration modConfig) {
        this(modName, modOptions, modConfig, null);
    }

    public GuiModSettings(String modName, Option[] modOptions, Configuration modConfig, ISettingsUpdatedCallback callback) {
        this.screenTitle = EnumChatFormatting.BLUE + modName + EnumChatFormatting.WHITE + " Settings";
        this.modOptions = modOptions;
        this.modConfig = modConfig;
        this.callback = callback;
    }

    public void func_73866_w_() {
        this.field_73887_h.clear();
        this.optionPanel = new GuiScrollPanel(100, 0, 34, this.field_73880_f, this.field_73881_g - 84, 5);
        this.field_73887_h.add(this.optionPanel);
        this.field_73887_h.add(new GuiButton(200, this.field_73880_f / 2 - 100, this.field_73881_g - 44, I18n.func_135053_a((String)"gui.done")));
        for (int n = 0; n < this.modOptions.length; ++n) {
            if (this.modOptions[n] == null) continue;
            if (this.modOptions[n] instanceof OptionInterval) {
                this.optionPanel.buttonList.add(new GuiSlider(n, this.optionPanel.getWidth() / 2 - 155 + n % 2 * 160, 24 * (n >> 1), this.modOptions[n].name, ((Float)this.modOptions[n].value).floatValue(), ((OptionInterval)this.modOptions[n]).minValue, ((OptionInterval)this.modOptions[n]).maxValue));
                continue;
            }
            this.optionPanel.buttonList.add((GuiButton)new GuiSmallButton(n, this.optionPanel.getWidth() / 2 - 155 + n % 2 * 160, 24 * (n >> 1), this.modOptions[n].name + ": " + this.modOptions[n].getValueAsString()));
        }
        this.optionPanel.updateSliderSize();
    }

    protected void func_73875_a(GuiButton guiButton) {
        GuiButton optionButton;
        if (!guiButton.field_73742_g) {
            return;
        }
        if (guiButton == this.optionPanel && (optionButton = this.optionPanel.selectedButton) != null && optionButton instanceof GuiSmallButton) {
            this.modOptions[optionButton.field_73741_f].setToNextValue();
            optionButton.field_73744_e = this.modOptions[optionButton.field_73741_f].name + ": " + this.modOptions[optionButton.field_73741_f].getValueAsString();
        }
        if (guiButton.field_73741_f == 200) {
            this.field_73882_e.func_71373_a(null);
        }
    }

    public void func_73874_b() {
        this.field_73882_e.field_71438_f.func_72712_a();
        for (GuiButton guiButton : this.optionPanel.buttonList) {
            if (!(guiButton instanceof GuiSlider)) continue;
            this.modOptions[((GuiSlider)guiButton).field_73741_f].value = Float.valueOf(((GuiSlider)guiButton).value);
        }
        for (int n = 0; n < this.modOptions.length; ++n) {
            if (this.modOptions[n] == null) continue;
            this.modOptions[n].write();
        }
        this.modConfig.save();
        if (this.callback != null) {
            this.callback.onSettingsUpdated();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_73873_v_();
        this.func_73732_a(this.field_73886_k, this.screenTitle, this.field_73880_f / 2, 20, 0xFFFFFF);
        super.func_73863_a(par1, par2, par3);
    }
}

