/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;

public class VersionChecker
implements Runnable,
ITickHandler {
    private URL versionList;
    private String name;
    private String currentVersion;
    private String latestVersion;
    private String description;
    private boolean checked = false;
    private boolean messagePrompted = false;

    public static void check(String modName, String modVersion, String modVersionList) {
        VersionChecker versionChecker = new VersionChecker(modName, modVersion, modVersionList);
        new Thread((Runnable)versionChecker, "[PoerschCore][VersionChecker] " + modName).start();
        TickRegistry.registerTickHandler((ITickHandler)versionChecker, (Side)Side.CLIENT);
    }

    private VersionChecker(String modName, String modVersion, String modVersionList) {
        this.name = modName;
        this.currentVersion = modVersion;
        this.latestVersion = modVersion;
        try {
            this.versionList = new URL(modVersionList);
        }
        catch (MalformedURLException e) {
            Logger.getLogger(VersionChecker.class.getName()).log(Level.SEVERE, "Malformed mod version list URL: " + modVersionList, e);
        }
    }

    @Override
    public void run() {
        Scanner scanner = null;
        try {
            scanner = new Scanner(this.versionList.openStream());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (scanner != null) {
            String minecraftVersion = Loader.instance().getMinecraftModContainer().getVersion();
            while (scanner.hasNext()) {
                String[] tokens;
                String nextLine = scanner.nextLine();
                if (!nextLine.startsWith(minecraftVersion) || (tokens = nextLine.split(";")).length <= 1 || !tokens[0].equals(minecraftVersion) || tokens[1].compareTo(this.latestVersion) <= 0) continue;
                this.latestVersion = tokens[1];
                if (tokens.length > 2 && tokens[2].length() > 0) {
                    this.description = tokens[2];
                    continue;
                }
                this.description = null;
            }
        }
        this.checked = true;
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (this.messagePrompted) {
            return;
        }
        if (this.checked) {
            if (!this.latestVersion.equals(this.currentVersion)) {
                ((EntityPlayer)tickData[0]).func_71035_c(EnumChatFormatting.BLUE + this.name + EnumChatFormatting.RESET + " version " + EnumChatFormatting.BLUE + this.latestVersion + EnumChatFormatting.RESET + " is available for download" + (this.description == null ? "!" : ": " + this.description));
            }
            this.messagePrompted = true;
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return null;
    }
}

