/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.core;

import cpw.mods.fml.relauncher.ReflectionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.Resource;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;

public class ResourceHelper {
    private static SimpleReloadableResourceManager resourceManager;

    public static Resource getResource(String domain, String filename) {
        if (resourceManager == null) {
            try {
                resourceManager = (SimpleReloadableResourceManager)ReflectionHelper.getPrivateValue(TextureManager.class, (Object)((TextureManager)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (int)7)), (int)4);
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            return resourceManager.func_110536_a(new ResourceLocation(domain, filename));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean resourceExists(String domain, String filename) {
        return ResourceHelper.getResource(domain, filename) != null;
    }

    public static Icon registerBlockIcon(IconRegister iconRegister, String domain, String name) {
        return ResourceHelper.resourceExists(domain, "textures/blocks/" + name + ".png") ? iconRegister.func_94245_a(domain + ":" + name) : null;
    }

    public static Icon[] registerBlockIcons(IconRegister iconRegister, String domain, String name) {
        if (ResourceHelper.resourceExists(domain, "textures/blocks/" + name + ".png")) {
            return new Icon[]{iconRegister.func_94245_a(domain + ":" + name)};
        }
        int iconCount = 0;
        while (ResourceHelper.resourceExists(domain, "textures/blocks/" + name + "_" + iconCount + ".png")) {
            ++iconCount;
        }
        if (iconCount == 0) {
            return null;
        }
        Icon[] icon = new Icon[iconCount];
        for (int n = 0; n < iconCount; ++n) {
            icon[n] = iconRegister.func_94245_a(domain + ":" + name + "_" + n);
        }
        return icon;
    }
}

