/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.core;

public class OptionHelper {
    public static final String[][] optionOffOn = new String[][]{{"false", "off"}, {"true", "on"}};
    public static final String[][] optionOffFastFancy = new String[][]{{"false", "off"}, {"true", "on", "fast"}, {"fancy"}};

    public static int getOption(int defaultValue, String value, String[][] options) {
        value = value.trim();
        value = value.toLowerCase();
        for (int i = 0; i < options.length; ++i) {
            for (int n = 0; n < options[i].length; ++n) {
                if (!value.equals(options[i][n])) continue;
                return i;
            }
        }
        return 0;
    }

    public static boolean getOffOn(boolean defaultValue, String value) {
        return OptionHelper.getOption(defaultValue ? 1 : 0, value, optionOffOn) > 0;
    }

    public static int getOffFastFancy(int defaultValue, String value) {
        return OptionHelper.getOption(defaultValue, value, optionOffFastFancy);
    }

    public static boolean[] getBooleanMap(int size, boolean defaultValue, String value) {
        boolean[] booleanMap = new boolean[size];
        for (int n = 0; n < booleanMap.length; ++n) {
            booleanMap[n] = defaultValue;
        }
        boolean negativeValue = !defaultValue;
        String[] iDlist = value.split(",");
        for (int n = 0; n < iDlist.length; ++n) {
            try {
                int blockID = Integer.parseInt(iDlist[n].trim());
                if (blockID < 0 || blockID >= size) continue;
                booleanMap[blockID] = negativeValue;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return booleanMap;
    }
}

