/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.core;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.IClassTransformer;

public class ClassPatcher
implements IClassTransformer {
    public static HashMap<String, File> toPatch = new HashMap();
    private static Logger logger = Logger.getLogger(ClassPatcher.class.getName());

    public byte[] transform(String name, String arg1, byte[] data) {
        File zipLocation = toPatch.remove(name);
        if (zipLocation != null) {
            data = this.overwriteClass(name, data, zipLocation);
        }
        return data;
    }

    private byte[] overwriteClass(String name, byte[] data, File zipLocation) {
        try {
            ZipFile zip = new ZipFile(zipLocation);
            ZipEntry entry = zip.getEntry("patches/" + name.replace('.', '/') + ".class");
            if (entry == null) {
                logger.log(Level.WARNING, "Class \"" + name + "\" not found in " + zipLocation.getName());
            } else {
                InputStream zin = zip.getInputStream(entry);
                data = new byte[(int)entry.getSize()];
                zin.read(data);
                zin.close();
                logger.log(Level.INFO, "Patched class: " + name);
            }
            zip.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error overwriting class \"" + name + "\" from " + zipLocation.getName(), e);
        }
        return data;
    }

    public static void addPatchesFrom(File zipLocation) {
        int patchCount = 0;
        try {
            ZipFile zip = new ZipFile(zipLocation);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String filename = entries.nextElement().getName();
                if (!filename.startsWith("patches/") || !filename.endsWith(".class")) continue;
                toPatch.put(filename.substring(8, filename.length() - 6), zipLocation);
                ++patchCount;
            }
            zip.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.log(Level.INFO, "Found " + patchCount + " patches in " + zipLocation.getName());
    }
}

