/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.bettergrassandleaves.renderer;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import poersch.minecraft.bettergrassandleaves.BetterGrassAndLeavesMod;
import poersch.minecraft.bettergrassandleaves.entity.EntityFallingLeaves3DFX;
import poersch.minecraft.bettergrassandleaves.entity.EntityFallingLeavesFX;
import poersch.minecraft.bettergrassandleaves.interfaces.IBetterLeaves;
import poersch.minecraft.bettergrassandleaves.renderer.BetterBlockRenderer;

public class BetterLeavesRenderer
extends BetterBlockRenderer {
    private Icon[][] leafBuffer;

    public BetterLeavesRenderer() {
        this.createQuadOffsetTable(16, 0.9);
    }

    @Override
    public void registerIcons(Block block, IconRegister iconRegister) {
        if (block != Block.field_71952_K) {
            return;
        }
        Block.field_71952_K.iconFallingLeaves = new Icon[BlockLeaves.field_72136_a.length];
        int n = 0;
        while (true) {
            if (n >= BlockLeaves.field_72136_a.length) break;
            Block.field_71952_K.iconFallingLeaves[n] = BetterGrassAndLeavesMod.registerBlockIcon(iconRegister, "falling_leaves_" + BlockLeaves.field_72136_a[n]);
            ++n;
        }
        if (((Boolean)BetterGrassAndLeavesMod.useRoundedVanillaLeaves.value).booleanValue()) {
            this.leafBuffer = new Icon[2][BlockLeaves.field_72136_a.length];
            n = 0;
            while (true) {
                if (n >= BlockLeaves.field_72136_a.length) break;
                Icon icon = BetterGrassAndLeavesMod.registerBlockIcon(iconRegister, "leaves_" + BlockLeaves.field_72136_a[n] + "_round");
                this.leafBuffer[0][n] = Block.field_71952_K.field_94395_cQ[0][n];
                this.leafBuffer[1][n] = icon != null ? icon : this.leafBuffer[0][n];
                ++n;
            }
            if (((Boolean)BetterGrassAndLeavesMod.renderBetterLeaves.value).booleanValue()) {
                n = 0;
                while (true) {
                    if (n >= BlockLeaves.field_72136_a.length) break;
                    Block.field_71952_K.field_94395_cQ[0][n] = this.leafBuffer[1][n];
                    ++n;
                }
            }
        }
        Block.field_71952_K.iconBetterLeaves = new Icon[BlockLeaves.field_72136_a.length][];
        for (n = 0; n < Block.field_71952_K.iconBetterLeaves.length; ++n) {
            Block.field_71952_K.iconBetterLeaves[n] = BetterGrassAndLeavesMod.registerBlockIcons(iconRegister, "better_leaves_" + BlockLeaves.field_72136_a[n]);
        }
    }

    @Override
    public boolean renderWorldBlock(RenderBlocks renderBlocks, IBlockAccess iBlockAccess, Block block, int x, int y, int z) {
        if (this.blockHasVisibleSide(iBlockAccess, block, x, y, z)) {
            double maxV;
            double minV;
            double maxU;
            double minU;
            IBetterLeaves leavesBlock = (IBetterLeaves)block;
            long offset = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
            offset = offset * offset * 42317861L + offset * 11L;
            if (((Boolean)BetterGrassAndLeavesMod.forceNaturalLeafTextures.value).booleanValue()) {
                renderBlocks.field_78685_i = renderBlocks.field_78679_j = MathHelper.func_76141_d((float)((float)(offset >> 4 & 0xFL) / 15.0f * 3.5f));
                renderBlocks.field_78683_h = renderBlocks.field_78679_j;
                renderBlocks.field_78662_g = renderBlocks.field_78679_j;
                renderBlocks.field_78675_l = renderBlocks.field_78679_j;
                renderBlocks.field_78681_k = renderBlocks.field_78679_j;
            }
            if (((Boolean)BetterGrassAndLeavesMod.renderLeafBlocks.value).booleanValue()) {
                this.renderStandardBlock(renderBlocks, block, x, y, z, ((Float)BetterGrassAndLeavesMod.blockLeavesBrightness.value).floatValue());
            }
            renderBlocks.field_78679_j = 0;
            renderBlocks.field_78685_i = 0;
            renderBlocks.field_78683_h = 0;
            renderBlocks.field_78662_g = 0;
            renderBlocks.field_78675_l = 0;
            renderBlocks.field_78681_k = 0;
            Icon icon = leavesBlock.getIconBetterLeaves(iBlockAccess.func_72805_g(x, y, z), (float)(offset >> 12 & 0xFL) / 15.0f);
            if (icon == null) {
                return true;
            }
            int color = block.func_71920_b(iBlockAccess, x, y, z);
            float r = (float)(color >> 16 & 0xFF) * 0.00392f * ((Float)BetterGrassAndLeavesMod.betterLeavesBrightness.value).floatValue();
            float g = (float)(color >> 8 & 0xFF) * 0.00392f * ((Float)BetterGrassAndLeavesMod.betterLeavesBrightness.value).floatValue();
            float b = (float)(color & 0xFF) * 0.00392f * ((Float)BetterGrassAndLeavesMod.betterLeavesBrightness.value).floatValue();
            double xS = (double)x + 0.5 + ((double)((float)(offset >> 16 & 0xFL) / 15.0f) - 0.5) * 0.45;
            double yS = (double)y + 0.5 + ((double)((float)(offset >> 20 & 0xFL) / 15.0f) - 0.5) * 0.3;
            double zS = (double)z + 0.5 + ((double)((float)(offset >> 24 & 0xFL) / 15.0f) - 0.5) * 0.45;
            if ((float)(offset >> 8 & 0xFL) / 15.0f < 0.5f) {
                minU = icon.func_94209_e();
                maxU = icon.func_94212_f();
            } else {
                minU = icon.func_94212_f();
                maxU = icon.func_94209_e();
            }
            if ((float)(offset >> 4 & 0xFL) / 15.0f < 0.5f) {
                minV = icon.func_94206_g();
                maxV = icon.func_94210_h();
            } else {
                minV = icon.func_94210_h();
                maxV = icon.func_94206_g();
            }
            Tessellator tessellator = Tessellator.field_78398_a;
            if (!block.func_71926_d()) {
                tessellator.func_78380_c(block.func_71874_e(iBlockAccess, x, y, z));
            }
            if (!((Boolean)BetterGrassAndLeavesMod.renderLeafBlocks.value).booleanValue()) {
                double radius = 0.77;
                double minX = xS - radius;
                double maxX = xS + radius;
                double minZ = zS - radius;
                double maxZ = zS + radius;
                double ySkewX = 0.0;
                double ySkewZ = 0.0;
                if ((x & 1) == 0) {
                    ySkewX = (z & 1) == 0 ? 0.1 : -0.1;
                } else {
                    ySkewZ = (z & 1) == 0 ? 0.1 : -0.1;
                }
                tessellator.func_78386_a(r, g, b);
                tessellator.func_78374_a(minX, yS, minZ, minU, minV);
                tessellator.func_78374_a(minX, yS + ySkewZ, maxZ, minU, maxV);
                tessellator.func_78374_a(maxX, yS + ySkewX + ySkewZ, maxZ, maxU, maxV);
                tessellator.func_78374_a(maxX, yS + ySkewX, minZ, maxU, minV);
                tessellator.func_78386_a(r * 0.65f, g * 0.65f, b * 0.65f);
                tessellator.func_78374_a(maxX, yS + ySkewX, minZ, maxU, minV);
                tessellator.func_78374_a(maxX, yS + ySkewX + ySkewZ, maxZ, maxU, maxV);
                tessellator.func_78374_a(minX, yS + ySkewZ, maxZ, minU, maxV);
                tessellator.func_78374_a(minX, yS, minZ, minU, minV);
            }
            this.renderCrossedQuadsShaded(tessellator, Math.abs(x & 1 + (z & 1) * 2 + (y & 1) * 4), xS, yS, zS, minU, maxU, minV, maxV, r, g, b, r * 0.58f, g * 0.58f, b * 0.58f);
        }
        return true;
    }

    @Override
    public void onRandomDisplayTick(Block block, World world, int x, int y, int z, Random random) {
        if (world.func_72799_c(x, y - 1, z)) {
            int metadata = world.func_72805_g(x, y, z);
            if (random.nextFloat() > 1.0f - ((IBetterLeaves)block).getSpawnChanceFallingLeaves(metadata) * ((Float)BetterGrassAndLeavesMod.leavesFXSpawnRate.value).floatValue()) {
                Icon icon = ((IBetterLeaves)block).getIconFallingLeaves(metadata);
                if (icon == null) {
                    return;
                }
                double xS = (double)x + 0.1 + random.nextDouble() * 0.8;
                double yS = (double)y + 0.16;
                double zS = (double)z + 0.1 + random.nextDouble() * 0.8;
                if ((Integer)BetterGrassAndLeavesMod.renderLeavesFX.value == 1) {
                    this.minecraft.field_71452_i.func_78873_a((EntityFX)new EntityFallingLeavesFX(world, xS, yS, zS, ((Float)BetterGrassAndLeavesMod.betterLeavesBrightness.value).floatValue(), block.func_71920_b((IBlockAccess)world, x, y, z), icon));
                } else {
                    this.minecraft.field_71452_i.func_78873_a((EntityFX)new EntityFallingLeaves3DFX(world, xS, yS, zS, ((Float)BetterGrassAndLeavesMod.betterLeavesBrightness.value).floatValue(), block.func_71920_b((IBlockAccess)world, x, y, z), icon));
                }
            }
        }
    }

    @Override
    public void onSettingsUpdated() {
        if (((Boolean)BetterGrassAndLeavesMod.useRoundedVanillaLeaves.value).booleanValue()) {
            if (((Boolean)BetterGrassAndLeavesMod.renderBetterLeaves.value).booleanValue()) {
                int n = 0;
                while (true) {
                    if (n < BlockLeaves.field_72136_a.length) {
                        Block.field_71952_K.field_94395_cQ[0][n] = this.leafBuffer[1][n];
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                int n = 0;
                while (true) {
                    if (n >= BlockLeaves.field_72136_a.length) break;
                    Block.field_71952_K.field_94395_cQ[0][n] = this.leafBuffer[0][n];
                    ++n;
                }
            }
        }
    }

    @Override
    public void onModToggled(boolean modActive, int renderIndex) {
        if (((Boolean)BetterGrassAndLeavesMod.useRoundedVanillaLeaves.value).booleanValue()) {
            int n = 0;
            while (true) {
                if (n >= BlockLeaves.field_72136_a.length) break;
                Block.field_71952_K.field_94395_cQ[0][n] = this.leafBuffer[renderIndex][n];
                ++n;
            }
        }
    }

    public boolean blockHasVisibleSide(IBlockAccess iBlockAccess, Block block, int x, int y, int z) {
        if (!iBlockAccess.func_72804_r(x, y + 1, z) && iBlockAccess.func_72798_a(x, y + 1, z) != block.field_71990_ca) {
            return true;
        }
        if (!iBlockAccess.func_72804_r(x, y - 1, z) && iBlockAccess.func_72798_a(x, y - 1, z) != block.field_71990_ca) {
            return true;
        }
        if (!iBlockAccess.func_72804_r(x - 1, y, z) && iBlockAccess.func_72798_a(x - 1, y, z) != block.field_71990_ca) {
            return true;
        }
        if (!iBlockAccess.func_72804_r(x + 1, y, z) && iBlockAccess.func_72798_a(x + 1, y, z) != block.field_71990_ca) {
            return true;
        }
        if (!iBlockAccess.func_72804_r(x, y, z - 1) && iBlockAccess.func_72798_a(x, y, z - 1) != block.field_71990_ca) {
            return true;
        }
        return !iBlockAccess.func_72804_r(x, y, z + 1) && iBlockAccess.func_72798_a(x, y, z + 1) != block.field_71990_ca;
    }
}

