/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.bettergrassandleaves.renderer;

import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import poersch.minecraft.bettergrassandleaves.BetterGrassAndLeavesMod;
import poersch.minecraft.bettergrassandleaves.entity.EntityMovingGrassFX;
import poersch.minecraft.bettergrassandleaves.interfaces.IBetterGrass;
import poersch.minecraft.bettergrassandleaves.renderer.BetterBlockRenderer;
import poersch.minecraft.core.ResourceHelper;

public class BetterGrassRenderer
extends BetterBlockRenderer {
    public BetterGrassRenderer() {
        this.createQuadOffsetTable(4, 0.707);
    }

    @Override
    public void registerIcons(Block block, IconRegister iconRegister) {
        if (block == Block.field_71980_u) {
            Block.field_71980_u.iconBetterGrass = new Icon[][]{ResourceHelper.registerBlockIcons(iconRegister, "minecraft", "better_grass"), null};
            if (Block.field_71980_u.iconBetterGrass[0] != null) {
                Block.field_71980_u.iconBetterGrass[1] = Block.field_71980_u.iconBetterGrass[0];
            } else {
                Block.field_71980_u.iconBetterGrass = new Icon[][]{BetterGrassAndLeavesMod.registerBlockIcons(iconRegister, "better_grass_short"), BetterGrassAndLeavesMod.registerBlockIcons(iconRegister, "better_grass_long")};
            }
            Block.field_71980_u.iconBetterGrassSide = BetterGrassAndLeavesMod.registerBlockIcons(iconRegister, "better_grass_side");
        } else if (block == Block.field_71994_by) {
            Block.field_71994_by.iconBetterMycelium = BetterGrassAndLeavesMod.registerBlockIcons(iconRegister, "better_mycel");
            Block.field_71994_by.iconBetterMyceliumSide = BetterGrassAndLeavesMod.registerBlockIcons(iconRegister, "better_mycel_side");
        }
    }

    @Override
    public boolean renderWorldBlock(RenderBlocks renderBlocks, IBlockAccess iBlockAccess, Block block, int x, int y, int z) {
        long offset = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
        offset = offset * offset * 42317861L + offset * 11L;
        if (((Boolean)BetterGrassAndLeavesMod.forceNaturalGrassTextures.value).booleanValue()) {
            renderBlocks.field_78681_k = MathHelper.func_76141_d((float)((float)(offset >> 4 & 0xFL) / 15.0f * 3.5f));
        }
        this.renderStandardBlock(renderBlocks, block, x, y, z, ((Float)BetterGrassAndLeavesMod.blockGrassBrightness.value).floatValue());
        renderBlocks.field_78681_k = 0;
        if (iBlockAccess.func_72798_a(x, y + 1, z) != Block.field_72037_aS.field_71990_ca) {
            Icon icon;
            IBetterGrass grassBlock = (IBetterGrass)block;
            int color = block.func_71920_b(iBlockAccess, x, y, z);
            float r = (float)(color >> 16 & 0xFF) * 0.00392f * ((Float)BetterGrassAndLeavesMod.betterGrassBrightness.value).floatValue();
            float g = (float)(color >> 8 & 0xFF) * 0.00392f * ((Float)BetterGrassAndLeavesMod.betterGrassBrightness.value).floatValue();
            float b = (float)(color & 0xFF) * 0.00392f * ((Float)BetterGrassAndLeavesMod.betterGrassBrightness.value).floatValue();
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78380_c(block.func_71874_e(iBlockAccess, x, y + 1, z));
            tessellator.func_78386_a(r, g, b);
            if (((Boolean)BetterGrassAndLeavesMod.renderGrassSides.value).booleanValue() && !iBlockAccess.func_72804_r(x, y + 1, z) && (icon = grassBlock.getIconBetterGrassSide(iBlockAccess.func_72805_g(x, y, z), (float)(offset >> 4 & 0xFL) / 15.0f)) != null) {
                if (Block.field_71971_o[iBlockAccess.func_72798_a(x, y, z - 1)] == 0 && iBlockAccess.func_72798_a(x, y - 1, z - 1) == block.field_71990_ca) {
                    renderBlocks.func_78611_c(block, (double)x, (double)y, (double)z, icon);
                }
                if (Block.field_71971_o[iBlockAccess.func_72798_a(x, y, z + 1)] == 0 && iBlockAccess.func_72798_a(x, y - 1, z + 1) == block.field_71990_ca) {
                    renderBlocks.func_78622_d(block, (double)x, (double)y, (double)z, icon);
                }
                if (Block.field_71971_o[iBlockAccess.func_72798_a(x - 1, y, z)] == 0 && iBlockAccess.func_72798_a(x - 1, y - 1, z) == block.field_71990_ca) {
                    renderBlocks.func_78573_e(block, (double)x, (double)y, (double)z, icon);
                }
                if (Block.field_71971_o[iBlockAccess.func_72798_a(x + 1, y, z)] == 0 && iBlockAccess.func_72798_a(x + 1, y - 1, z) == block.field_71990_ca) {
                    renderBlocks.func_78605_f(block, (double)x, (double)y, (double)z, icon);
                }
            }
            if (iBlockAccess.func_72799_c(x, y + 1, z)) {
                double maxU;
                double minU;
                icon = grassBlock.getIconBetterGrass((float)(offset >> 4 & 0xFL) / 15.0f > iBlockAccess.func_72807_a(x, z).getHeightBetterGrass() ? 0 : 1, (float)(offset >> 12 & 0xFL) / 15.0f);
                if (icon == null) {
                    return true;
                }
                double xS = (double)x + 0.5 + ((double)((float)(offset >> 16 & 0xFL) / 15.0f) - 0.5) * 0.3;
                double yS = (double)y + 1.707 - (double)((float)(offset >> 20 & 0xFL) / 15.0f) * 0.16;
                double zS = (double)z + 0.5 + ((double)((float)(offset >> 24 & 0xFL) / 15.0f) - 0.5) * 0.3;
                if ((float)(offset >> 8 & 0xFL) / 15.0f < 0.5f) {
                    minU = icon.func_94209_e();
                    maxU = icon.func_94212_f();
                } else {
                    minU = icon.func_94212_f();
                    maxU = icon.func_94209_e();
                }
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                this.renderCrossedQuads(tessellator, Math.abs(x & 1 + (z & 1) * 2), xS, yS, zS, minU, maxU, minV, maxV);
            }
        }
        return true;
    }

    @Override
    public void onEntityWalking(Block block, World world, int x, int y, int z, Entity entity) {
        if (world.func_72799_c(x, y + 1, z)) {
            IBetterGrass grassBlock = (IBetterGrass)block;
            long offset = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
            Icon icon = grassBlock.getIconBetterGrass((float)((offset = offset * offset * 42317861L + offset * 11L) >> 4 & 0xFL) / 15.0f > world.func_72807_a(x, z).getHeightBetterGrass() ? 0 : 1, (float)(offset >> 12 & 0xFL) / 15.0f);
            if (icon == null) {
                return;
            }
            double xS = (double)x + 0.5 + ((double)((float)(offset >> 16 & 0xFL) / 15.0f) - 0.5) * 0.3;
            double yS = (double)y + 1.707 - (double)((float)(offset >> 20 & 0xFL) / 15.0f) * 0.16;
            double zS = (double)z + 0.5 + ((double)((float)(offset >> 24 & 0xFL) / 15.0f) - 0.5) * 0.3;
            boolean flipU = (float)(offset >> 8 & 0xFL) / 15.0f < 0.5f;
            this.minecraft.field_71452_i.func_78873_a((EntityFX)new EntityMovingGrassFX(world, xS, yS, zS, 0.46f, this, Math.abs(x & 1 + (z & 1) * 2), block.func_71874_e((IBlockAccess)world, x, y + 1, z), ((Float)BetterGrassAndLeavesMod.betterGrassBrightness.value).floatValue(), block.func_71920_b((IBlockAccess)world, x, y, z), (Icon)new IconFlipped(icon, !flipU, false)));
        } else if (world.func_72798_a(x, y + 1, z) == Block.field_71962_X.field_71990_ca) {
            long offset = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)(y + 1);
            offset = offset * offset * 42317861L + offset * 11L;
            Icon icon = Block.field_71962_X.func_71858_a(0, world.func_72805_g(x, y + 1, z));
            double xS = (double)x + 0.5 + ((double)((float)(offset >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            double yS = (double)y + 1.5 + ((double)((float)(offset >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            double zS = (double)z + 0.5 + ((double)((float)(offset >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
            this.minecraft.field_71452_i.func_78873_a((EntityFX)new EntityMovingGrassFX(world, xS, yS, zS, 0.1f, this, 0, Block.field_71962_X.func_71874_e((IBlockAccess)world, x, y + 1, z), 1.0f, Block.field_71962_X.func_71920_b((IBlockAccess)world, x, y + 1, z), icon));
        }
    }
}

