/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.bettergrassandleaves.renderer;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BetterBlockRenderer {
    protected Minecraft minecraft = Minecraft.func_71410_x();
    public double[][] quadOffset;

    public void createQuadOffsetTable(int size, double radius) {
        this.quadOffset = new double[size + 1][4];
        this.quadOffset[0][0] = radius;
        double angle = 0.7853981633974483 - 0.01884955592153876 * (double)size;
        for (int n = 1; n < size + 1; ++n) {
            this.quadOffset[n][0] = Math.sin(angle += 0.03769911184307752) * radius;
            this.quadOffset[n][1] = Math.cos(angle) * radius;
            this.quadOffset[n][2] = Math.sin(angle + 1.5707963267948966) * radius;
            this.quadOffset[n][3] = Math.cos(angle + 1.5707963267948966) * radius;
        }
    }

    public abstract void registerIcons(Block var1, IconRegister var2);

    public abstract boolean renderWorldBlock(RenderBlocks var1, IBlockAccess var2, Block var3, int var4, int var5, int var6);

    public void onEntityWalking(Block block, World world, int x, int y, int z, Entity entity) {
    }

    public void onRandomDisplayTick(Block block, World world, int x, int y, int z, Random random) {
    }

    public void onSettingsUpdated() {
    }

    public void onModToggled(boolean modActive, int renderIndex) {
    }

    protected void renderStandardBlock(RenderBlocks renderBlocks, Block block, int x, int y, int z, float brightnessFactor) {
        int color = block.func_71920_b(renderBlocks.field_78669_a, x, y, z);
        float red = (float)(color >> 16 & 0xFF) * 0.00392f * brightnessFactor;
        float green = (float)(color >> 8 & 0xFF) * 0.00392f * brightnessFactor;
        float blue = (float)(color & 0xFF) * 0.00392f * brightnessFactor;
        BetterBlockRenderer betterBlockRenderer = this;
        if (betterBlockRenderer.minecraft.func_71379_u() && Block.field_71984_q[block.field_71990_ca] == 0) {
            renderBlocks.func_78578_a(block, x, y, z, red, green, blue);
        } else {
            renderBlocks.func_78609_c(block, x, y, z, red, green, blue);
        }
    }

    protected void renderCrossedQuads(Tessellator tessellator, int offsetIndex, double x, double y, double z, double minU, double maxU, double minV, double maxV) {
        double minY = y - this.quadOffset[0][0];
        double maxY = y + this.quadOffset[0][0];
        double minX = x - this.quadOffset[++offsetIndex][0];
        double maxX = x + this.quadOffset[offsetIndex][0];
        double minZ = z - this.quadOffset[offsetIndex][1];
        double maxZ = z + this.quadOffset[offsetIndex][1];
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        minX = x - this.quadOffset[offsetIndex][2];
        maxX = x + this.quadOffset[offsetIndex][2];
        minZ = z - this.quadOffset[offsetIndex][3];
        maxZ = z + this.quadOffset[offsetIndex][3];
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
    }

    protected void renderCrossedQuadsShaded(Tessellator tessellator, int offsetIndex, double x, double y, double z, double minU, double maxU, double minV, double maxV, float r, float g, float b, float rS, float gS, float bS) {
        double minY = y - this.quadOffset[0][0];
        double maxY = y + this.quadOffset[0][0];
        double minX = x - this.quadOffset[++offsetIndex][0];
        double maxX = x + this.quadOffset[offsetIndex][0];
        double minZ = z - this.quadOffset[offsetIndex][1];
        double maxZ = z + this.quadOffset[offsetIndex][1];
        tessellator.func_78386_a(r, g, b);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        tessellator.func_78386_a(rS, gS, bS);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78386_a(r, g, b);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78386_a(rS, gS, bS);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
        minX = x - this.quadOffset[offsetIndex][2];
        maxX = x + this.quadOffset[offsetIndex][2];
        minZ = z - this.quadOffset[offsetIndex][3];
        maxZ = z + this.quadOffset[offsetIndex][3];
        tessellator.func_78386_a(r, g, b);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        tessellator.func_78386_a(rS, gS, bS);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78386_a(r, g, b);
        tessellator.func_78374_a(maxX, maxY, maxZ, minU, minV);
        tessellator.func_78374_a(minX, maxY, minZ, maxU, minV);
        tessellator.func_78386_a(rS, gS, bS);
        tessellator.func_78374_a(minX, minY, minZ, maxU, maxV);
        tessellator.func_78374_a(maxX, minY, maxZ, minU, maxV);
    }
}

