/*
 * Decompiled with CFR 0.152.
 */
package poersch.minecraft.bettergrassandleaves;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import poersch.minecraft.bettergrassandleaves.interfaces.IBetterGrass;
import poersch.minecraft.bettergrassandleaves.interfaces.IBetterLeaves;
import poersch.minecraft.bettergrassandleaves.renderer.BetterBlockRenderer;
import poersch.minecraft.bettergrassandleaves.renderer.BetterGrassExperimentalRenderer;
import poersch.minecraft.bettergrassandleaves.renderer.BetterGrassRenderer;
import poersch.minecraft.bettergrassandleaves.renderer.BetterLeavesRenderer;
import poersch.minecraft.core.ResourceHelper;
import poersch.minecraft.core.VersionChecker;
import poersch.minecraft.core.gui.GuiModSettings;
import poersch.minecraft.core.gui.ISettingsUpdatedCallback;
import poersch.minecraft.core.keyhandler.IKeyReleasedCallback;
import poersch.minecraft.core.keyhandler.KeyReleasedHandler;
import poersch.minecraft.core.options.Option;
import poersch.minecraft.core.options.OptionBitList;
import poersch.minecraft.core.options.OptionChoice;
import poersch.minecraft.core.options.OptionInterval;
import poersch.minecraft.core.options.OptionOffFastFancy;
import poersch.minecraft.core.options.OptionOffOn;

@Mod(modid="BetterGrassAndLeavesMod", name="Better Grass & Leaves Mod", version="1.6.2.F")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class BetterGrassAndLeavesMod
implements ISimpleBlockRenderingHandler,
IKeyReleasedCallback,
ISettingsUpdatedCallback {
    public static final String modID = "BetterGrassAndLeavesMod";
    public static final String modName = "Better Grass & Leaves Mod";
    public static final String modDomain = "bettergrassandleaves";
    public static final String modVersion = "1.6.2.F";
    public static final String modDescription = EnumChatFormatting.BLUE + "Better Grass & Leaves" + EnumChatFormatting.WHITE + " is a small mod which extends grass and leaves by a few juicy pixels.";
    public static final String modAuthor = "Poersch";
    public static final String modURL = "http://bit.ly/better-grass-and-leaves";
    public static final String modVersionURL = "https://dl.dropboxusercontent.com/u/6971729/Minecraft%20Mods/BetterGrassAndLeaves/releases/versions.txt";
    public static final String modLogo = "assets/bettergrassandleaves/textures/logo.png";
    @Mod.Instance(value="BetterGrassAndLeavesMod")
    public static BetterGrassAndLeavesMod modInstance;
    public static Logger logger;
    private BetterBlockRenderer[] grassRenderer = new BetterBlockRenderer[]{new BetterGrassRenderer(), new BetterGrassExperimentalRenderer()};
    private BetterBlockRenderer[] leavesRenderer = new BetterBlockRenderer[]{new BetterLeavesRenderer()};
    private Minecraft minecraft = Minecraft.func_71410_x();
    private int[] renderID = new int[]{0, 0};
    private int renderIndex = 1;
    private boolean modActive = true;
    public static OptionOffOn renderBetterGrass;
    public static OptionChoice currentGrassRenderer;
    public static OptionOffOn renderGrassSides;
    public static OptionOffOn renderGrassFX;
    public static OptionOffOn renderBetterLeaves;
    public static OptionChoice currentLeavesRenderer;
    public static OptionOffOn renderLeafBlocks;
    public static OptionOffFastFancy renderLeavesFX;
    public static OptionInterval leavesFXSpawnRate;
    public static OptionOffOn useRoundedVanillaLeaves;
    public static OptionOffOn forceVanillaGrass;
    public static OptionOffOn forceVanillaLeaves;
    public static OptionOffOn forceNaturalGrassTextures;
    public static OptionOffOn forceNaturalLeafTextures;
    public static OptionInterval betterGrassBrightness;
    public static OptionInterval betterLeavesBrightness;
    public static OptionInterval blockGrassBrightness;
    public static OptionInterval blockLeavesBrightness;
    public static OptionBitList blackList;
    public static Option[] modIngameOptions;
    public static Configuration modConfig;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata modMetadata = event.getModMetadata();
        modMetadata.autogenerated = false;
        modMetadata.description = modDescription;
        modMetadata.authorList.add(modAuthor);
        modMetadata.url = modURL;
        modMetadata.logoFile = modLogo;
        modConfig = new Configuration(event.getSuggestedConfigurationFile());
        modConfig.load();
        renderBetterGrass.read(modConfig, "general");
        currentGrassRenderer.read(modConfig, "general");
        renderGrassSides.read(modConfig, "general");
        renderGrassFX.read(modConfig, "general");
        renderBetterLeaves.read(modConfig, "general");
        currentLeavesRenderer.read(modConfig, "general");
        renderLeafBlocks.read(modConfig, "general");
        renderLeavesFX.read(modConfig, "general");
        leavesFXSpawnRate.read(modConfig, "general");
        useRoundedVanillaLeaves.read(modConfig, "general");
        forceVanillaGrass.read(modConfig, "general");
        forceVanillaLeaves.read(modConfig, "general");
        forceNaturalGrassTextures.read(modConfig, "general");
        forceNaturalLeafTextures.read(modConfig, "general");
        betterGrassBrightness.read(modConfig, "general");
        betterLeavesBrightness.read(modConfig, "general");
        blockGrassBrightness.read(modConfig, "general");
        blockLeavesBrightness.read(modConfig, "general");
        blackList.read(modConfig, "general");
        modConfig.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        VersionChecker.check(modName, modVersion, modVersionURL);
        this.renderID[1] = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this);
        KeyReleasedHandler.create(0, "Toggle Better Grass & Leaves Mod", 67, this);
        KeyReleasedHandler.create(1, "Better Grass & Leaves Mod Settings", 68, this);
    }

    public static Icon registerBlockIcon(IconRegister iconRegister, String name) {
        Icon icon = ResourceHelper.registerBlockIcon(iconRegister, "minecraft", name);
        if (icon != null) {
            return icon;
        }
        return ResourceHelper.registerBlockIcon(iconRegister, modDomain, name);
    }

    public static Icon[] registerBlockIcons(IconRegister iconRegister, String name) {
        Icon[] icon = ResourceHelper.registerBlockIcons(iconRegister, "minecraft", name);
        if (icon != null) {
            return icon;
        }
        return ResourceHelper.registerBlockIcons(iconRegister, modDomain, name);
    }

    public static void info(String message) {
        logger.log(Level.INFO, message);
    }

    public static void error(String message, Throwable throwable) {
        logger.log(Level.SEVERE, message, throwable);
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return this.renderID[this.renderIndex];
    }

    public void registerIcons(Block block, IconRegister iconRegister) {
        if (block instanceof IBetterGrass && !((Boolean)BetterGrassAndLeavesMod.forceVanillaGrass.value).booleanValue()) {
            for (BetterBlockRenderer renderer : this.grassRenderer) {
                renderer.registerIcons(block, iconRegister);
            }
        }
        if (block instanceof IBetterLeaves && !((Boolean)BetterGrassAndLeavesMod.forceVanillaLeaves.value).booleanValue()) {
            for (BetterBlockRenderer renderer : this.leavesRenderer) {
                renderer.registerIcons(block, iconRegister);
            }
        }
    }

    public void renderInventoryBlock(Block block, int meta, int modelID, RenderBlocks renderBlocks) {
        this.renderIndex = 0;
        renderBlocks.func_78600_a(block, meta, 1.0f);
        this.renderIndex = 1;
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int x, int y, int z, Block block, int modelId, RenderBlocks renderBlocks) {
        if (!((Boolean[])BetterGrassAndLeavesMod.blackList.value)[block.field_71990_ca].booleanValue()) {
            if (block instanceof IBetterGrass) {
                if (((Boolean)BetterGrassAndLeavesMod.renderBetterGrass.value).booleanValue()) {
                    return this.grassRenderer[(Integer)BetterGrassAndLeavesMod.currentGrassRenderer.value].renderWorldBlock(renderBlocks, iBlockAccess, block, x, y, z);
                }
            } else if (((Boolean)BetterGrassAndLeavesMod.renderBetterLeaves.value).booleanValue()) {
                return this.leavesRenderer[(Integer)BetterGrassAndLeavesMod.currentLeavesRenderer.value].renderWorldBlock(renderBlocks, iBlockAccess, block, x, y, z);
            }
        }
        return renderBlocks.func_78570_q(block, x, y, z);
    }

    public void onEntityWalking(Block block, World world, int x, int y, int z, Entity entity) {
        if (this.modActive && ((Boolean)BetterGrassAndLeavesMod.renderGrassFX.value).booleanValue() && block instanceof IBetterGrass && !((Boolean[])BetterGrassAndLeavesMod.blackList.value)[block.field_71990_ca].booleanValue()) {
            this.grassRenderer[(Integer)BetterGrassAndLeavesMod.currentGrassRenderer.value].onEntityWalking(block, world, x, y, z, entity);
        }
    }

    public void onRandomDisplayTick(Block block, World world, int x, int y, int z, Random random) {
        if (this.modActive && (Integer)BetterGrassAndLeavesMod.renderLeavesFX.value > 0 && block instanceof IBetterLeaves && !((Boolean[])BetterGrassAndLeavesMod.blackList.value)[block.field_71990_ca].booleanValue()) {
            this.leavesRenderer[(Integer)BetterGrassAndLeavesMod.currentLeavesRenderer.value].onRandomDisplayTick(block, world, x, y, z, random);
        }
    }

    @Override
    public void onKeyReleased(KeyReleasedHandler keyHandler) {
        if (!this.minecraft.field_71415_G) {
            return;
        }
        if (keyHandler.id == 0) {
            boolean bl = this.modActive = !this.modActive;
            if (this.modActive) {
                this.renderIndex = 1;
                BetterGrassAndLeavesMod.info("Activated mod.");
            } else {
                this.renderIndex = 0;
                BetterGrassAndLeavesMod.info("Deactivated mod.");
            }
            this.grassRenderer[(Integer)BetterGrassAndLeavesMod.currentGrassRenderer.value].onModToggled(this.modActive, this.renderIndex);
            this.leavesRenderer[(Integer)BetterGrassAndLeavesMod.currentLeavesRenderer.value].onModToggled(this.modActive, this.renderIndex);
            this.minecraft.field_71438_f.func_72712_a();
        } else if (keyHandler.id == 1) {
            this.minecraft.func_71373_a((GuiScreen)new GuiModSettings(modName, modIngameOptions, modConfig, this));
        }
    }

    @Override
    public void onSettingsUpdated() {
        this.grassRenderer[(Integer)BetterGrassAndLeavesMod.currentGrassRenderer.value].onSettingsUpdated();
        this.leavesRenderer[(Integer)BetterGrassAndLeavesMod.currentLeavesRenderer.value].onSettingsUpdated();
    }

    static {
        logger = Logger.getLogger(modID);
        renderBetterGrass = new OptionOffOn("renderBetterGrass", "Better Grass", "Render better grass?", "On");
        currentGrassRenderer = new OptionChoice("currentGrassRenderer", "Grass Renderer", "Which grass renderer should be used?", "Standard", new String[][]{{"Standard"}, {"Experimental"}});
        renderGrassSides = new OptionOffOn("renderGrassSides", "Grass Sides", "Render grass sides?", "On");
        renderGrassFX = new OptionOffOn("renderGrassFX", "Grass FX", "Render walking through grass effect?", "On");
        renderBetterLeaves = new OptionOffOn("renderBetterLeaves", "Better Leaves", "Render better leaves?", "On");
        currentLeavesRenderer = new OptionChoice("currentLeavesRenderer", "Leaves Renderer", "Which leaves renderer should be used?", "Standard", new String[][]{{"Standard"}});
        renderLeafBlocks = new OptionOffOn("renderLeafBlocks", "Leaf Blocks", "Render the old cube like leaves?", "On");
        renderLeavesFX = new OptionOffFastFancy("renderLeavesFX", "Leaves FX", "Render falling leaves effect?", "Fast");
        leavesFXSpawnRate = new OptionInterval("leavesFXSpawnRate", "Leaves FX Spawn Rate", "Falling Leaves spawn rate multiplier.", "1.0", 1.0f, 20.0f);
        useRoundedVanillaLeaves = new OptionOffOn("useRoundedVanillaLeaves", "Rounded Vanilla Leaves", "Use rounded versions of the vanilla leaf textures?", "On");
        forceVanillaGrass = new OptionOffOn("forceVanillaGrass", "Force Vanilla Grass", "Use vanilla textures for better grass?", "Off");
        forceVanillaLeaves = new OptionOffOn("forceVanillaLeaves", "Force Vanilla Leaves", "Use vanilla textures for better leaves?", "Off");
        forceNaturalGrassTextures = new OptionOffOn("forceNaturalGrassTextures", "Force Natural Grass", "Force rotate grass top textures for a more natural look (can break texturepack patterns)? Overwrites given Optifine settings.", "Off");
        forceNaturalLeafTextures = new OptionOffOn("forceNaturalLeafTextures", "Force Natural Leaves", "Force rotate leaf textures for a more natural look (can break texturepack patterns)? Overwrites given Optifine settings.", "Off");
        betterGrassBrightness = new OptionInterval("betterGrassBrightness", "Better Grass Bright.", "Brightness multiplier of better grass.", "1.0");
        betterLeavesBrightness = new OptionInterval("betterLeavesBrightness", "Better Leaves Bright.", "Brightness multiplier of better leaves.", "1.0");
        blockGrassBrightness = new OptionInterval("blockGrassBrightness", "Block Grass Bright.", "Brightness multiplier of vanilla grass cubes.", "1.0");
        blockLeavesBrightness = new OptionInterval("blockLeavesBrightness", "Block Leaves Bright.", "Brightness multiplier of vanilla leaf cubes.", "1.0");
        blackList = new OptionBitList("blackList", "Blacklist", "The listed block IDs won't render better grass, better leaves or their effects. (e.g. blackList=10,20,30)", "", false, 4096);
        modIngameOptions = new Option[]{renderBetterGrass, renderBetterLeaves, currentGrassRenderer, currentLeavesRenderer, renderGrassSides, renderLeafBlocks, renderGrassFX, renderLeavesFX, null, leavesFXSpawnRate, forceNaturalGrassTextures, forceNaturalLeafTextures, betterGrassBrightness, betterLeavesBrightness, blockGrassBrightness, blockLeavesBrightness};
    }
}

