/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import extrabiomes.module.summa.worldgen.WorldGenNewTreeBase;
import java.util.LinkedList;
import java.util.Random;

public class WorldGenJapaneseMapleTree
extends WorldGenNewTreeBase {
    private static long lastSeed = 1234L;
    private static final int BASE_HEIGHT = 8;
    private static final int BASE_HEIGHT_VARIANCE = 4;
    private static final double TRUNK_HEIGHT_PERCENT = 0.3;
    private static final int BRANCHES_BASE_NUMBER = 2;
    private static final int BRANCHES_EXTRA = 4;
    private static final int CANOPY_WIDTH = 8;
    private static final int CANOPY_WIDTH_VARIANCE = 6;
    static int last = 0;

    public WorldGenJapaneseMapleTree(boolean par1) {
        super(par1);
    }

    public boolean a(abv world, Random rand, int x, int y, int z2) {
        lastSeed = rand.nextLong();
        if (!this.checkTree(world, new Random(lastSeed), x, y, z2)) {
            return false;
        }
        return this.generateTree(world, new Random(lastSeed), x, y, z2);
    }

    public boolean generate(abv world, long seed, int x, int y, int z2) {
        lastSeed = seed;
        if (!this.checkTree(world, new Random(lastSeed), x, y, z2)) {
            return false;
        }
        return this.generateTree(world, new Random(seed), x, y, z2);
    }

    private boolean checkTree(abv world, Random rand, int x, int y, int z2) {
        int below = world.a(x, y - 1, z2);
        int height = rand.nextInt(4) + 8;
        double radius = (double)(8 + rand.nextInt(6)) / 2.0;
        int chunkCheck = (int)Math.ceil(radius) + 1;
        if (!TreeSoilRegistry.isValidSoil(world.a(x, y - 1, z2))) {
            return false;
        }
        if (y >= 256 - height - 4) {
            return false;
        }
        if (y < 1 || y + height + 4 > 256) {
            return false;
        }
        if (!world.e(x - chunkCheck, y - chunkCheck, z2 - chunkCheck, x + chunkCheck, y + chunkCheck, z2 + chunkCheck)) {
            return false;
        }
        if (!this.check1x1Trunk(x, y, z2, (int)((double)height * 0.3), TreeBlock.TRUNK.get(), world)) {
            return false;
        }
        return this.checkBranches(world, rand, x, y + (int)((double)height * 0.3), z2, height - (int)((double)height * 0.3) - 2, radius);
    }

    private boolean generateTree(abv world, Random rand, int x, int y, int z2) {
        int below = world.a(x, y - 1, z2);
        int height = rand.nextInt(4) + 8;
        double radius = (double)(8 + rand.nextInt(6)) / 2.0;
        int chunkCheck = (int)Math.ceil(radius) + 1;
        if (!TreeSoilRegistry.isValidSoil(world.a(x, y - 1, z2))) {
            return false;
        }
        if (y >= 256 - height - 4) {
            return false;
        }
        if (y < 1 || y + height + 4 > 256) {
            return false;
        }
        if (!world.e(x - chunkCheck, y - chunkCheck, z2 - chunkCheck, x + chunkCheck, y + chunkCheck, z2 + chunkCheck)) {
            return false;
        }
        if (this.place1x1Trunk(x, y, z2, (int)((double)height * 0.3), TreeBlock.TRUNK.get(), world)) {
            this.generateBranches(world, rand, x, y + (int)((double)height * 0.3), z2, height - (int)((double)height * 0.3) - 2, radius);
            return true;
        }
        return false;
    }

    public boolean checkBranches(abv world, Random rand, int x, int y, int z2, int height, double radius) {
        int branchCount = 2 + rand.nextInt(4);
        double curAngle = 0.0;
        double[] average = new double[]{0.0, 0.0, 0.0};
        int[] start = new int[]{x, y, z2};
        LinkedList<int[]> branches = new LinkedList<int[]>();
        for (int i = 0; i < branchCount; ++i) {
            double angle = (double)(rand.nextInt(50) + 35) / 90.0;
            double thisHeight = (double)(height + 1) * Math.sin(angle) / 1.3;
            double thisRadius = radius * Math.cos(angle);
            int x1 = (int)(thisRadius * Math.cos(curAngle += (double)(rand.nextInt(360 / branchCount) + 360 / branchCount) / 90.0));
            int z1 = (int)(thisRadius * Math.sin(curAngle));
            average[0] = average[0] + (double)x1;
            average[1] = average[1] + thisHeight;
            average[2] = average[2] + (double)z1;
            int[] node = new int[]{x1 + x, (int)thisHeight + y, z1 + z2};
            branches.add(node);
            if (this.checkBlockLine(start, node, TreeBlock.TRUNK.get(), world)) continue;
            return false;
        }
        for (int[] cluster : branches) {
            if (this.checkLeafCluster(world, cluster[0], cluster[1], cluster[2], 2, 1)) continue;
            return false;
        }
        average[0] = average[0] / (double)branchCount;
        average[1] = (double)branchCount / average[1] + 2.3;
        average[2] = average[2] / (double)branchCount;
        return this.checkCanopy(world, average[0] + (double)x, y, average[2] + (double)z2, radius, height);
    }

    public void generateBranches(abv world, Random rand, int x, int y, int z2, int height, double radius) {
        int branchCount = 2 + rand.nextInt(4);
        double curAngle = 0.0;
        double[] average = new double[]{0.0, 0.0, 0.0};
        int[] start = new int[]{x, y, z2};
        LinkedList<int[]> branches = new LinkedList<int[]>();
        for (int i = 0; i < branchCount; ++i) {
            double angle = (double)(rand.nextInt(50) + 35) / 90.0;
            double thisHeight = (double)(height + 1) * Math.sin(angle) / 1.3;
            double thisRadius = radius * Math.cos(angle);
            int x1 = (int)(thisRadius * Math.cos(curAngle += (double)(rand.nextInt(360 / branchCount) + 360 / branchCount) / 90.0));
            int z1 = (int)(thisRadius * Math.sin(curAngle));
            average[0] = average[0] + (double)x1;
            average[1] = average[1] + thisHeight;
            average[2] = average[2] + (double)z1;
            int[] node = new int[]{x1 + x, (int)thisHeight + y, z1 + z2};
            branches.add(node);
            this.placeBlockLine(start, node, TreeBlock.TRUNK.get(), world);
        }
        for (int[] cluster : branches) {
            this.generateLeafCluster(world, cluster[0], cluster[1], cluster[2], 2, 1, TreeBlock.LEAVES.get());
        }
        average[0] = average[0] / (double)branchCount;
        average[1] = (double)branchCount / average[1] + 2.3;
        average[2] = average[2] / (double)branchCount;
        this.generateCanopy(world, rand, average[0] + (double)x, y, average[2] + (double)z2, radius, height, TreeBlock.LEAVES.get());
        this.generateVerticalCone(world, x, y, z2, height - 1, 0.75, 2.0, TreeBlock.LEAVES.get());
    }

    public boolean checkCanopy(abv world, double x, double y, double z2, double radius, int height) {
        int layers = height + 2;
        int y1 = (int)y;
        int layer = 0;
        while (layer < layers) {
            if (!this.checkCanopyLayer(world, x, y1, z2, radius * Math.cos((double)layer / ((double)height / 1.3)))) {
                return false;
            }
            ++layer;
            ++y1;
        }
        return true;
    }

    public void generateCanopy(abv world, Random rand, double x, double y, double z2, double radius, int height, yd leaves) {
        int layers = height + 2;
        int y1 = (int)y;
        int layer = 0;
        while (layer < layers) {
            if (layer < 2) {
                this.generateCanopyLayer(world, rand, x, y1, z2, radius * Math.cos((double)layer / ((double)height / 1.3)), 2 + layer * 5, leaves);
            } else {
                this.generateCanopyLayer(world, rand, x, y1, z2, radius * Math.cos((double)layer / ((double)height / 1.3)), 1000, leaves);
            }
            ++layer;
            ++y1;
        }
    }

    public void generateVerticalCone(abv world, int x, int y, int z2, int height, double r1, double r2, yd leaves) {
        double ratio = (r2 - r1) / (double)(height - 1);
        for (int offset = 0; offset < height; ++offset) {
            this.placeLeavesCircle(x, y + offset, z2, ratio * (double)offset + r1, leaves, world);
        }
    }

    public boolean checkCanopyLayer(abv world, double x, double y, double z2, double radius) {
        double minDist = radius - 2.0 > 0.0 ? (radius - 2.0) * (radius - 2.0) : -1.0;
        double maxDist = radius * radius;
        int z1 = (int)(-radius);
        while ((double)z1 < radius + 1.0) {
            int x1 = (int)(-radius);
            while ((double)x1 < radius + 1.0) {
                aqw block = aqw.s[world.a((int)((double)x1 + x), (int)y, (int)((double)z1 + z2))];
                if ((double)(x1 * x1 + z1 * z1) <= maxDist && (double)(x1 * x1 + z1 * z1) >= minDist && block != null) {
                    return false;
                }
                ++x1;
            }
            ++z1;
        }
        return true;
    }

    public void generateCanopyLayer(abv world, Random rand, double x, double y, double z2, double radius, int skipChance, yd leaves) {
        double minDist = radius - 2.0 > 0.0 ? (radius - 2.0) * (radius - 2.0) : -1.0;
        double maxDist = radius * radius;
        int z1 = (int)(-radius);
        while ((double)z1 < radius + 1.0) {
            int x1 = (int)(-radius);
            while ((double)x1 < radius + 1.0) {
                aqw block = aqw.s[world.a((int)((double)x1 + x), (int)y, (int)((double)z1 + z2))];
                if ((double)(x1 * x1 + z1 * z1) <= maxDist && (double)(x1 * x1 + z1 * z1) >= minDist && (block == null || block.canBeReplacedByLeaves(world, (int)((double)x1 + x), (int)y, (int)((double)z1 + z2))) && rand.nextInt(skipChance) != 0) {
                    this.setLeafBlock(world, (int)((double)x1 + x), (int)y, (int)((double)z1 + z2), leaves);
                }
                ++x1;
            }
            ++z1;
        }
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    private static enum TreeBlock {
        LEAVES(new yd((aqw)aqw.P, 1, 1)),
        TRUNK(new yd(aqw.O, 1, 1));

        private yd stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_JAPANESE_MAPLE.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_JAPANESE_MAPLE.get();
            }
            if (Element.LOG_JAPANESE_MAPLE.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_JAPANESE_MAPLE.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(yd stack) {
            this.stack = stack;
        }

        public yd get() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack;
        }

        public int getID() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.d;
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.k();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

