/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.forestry;

import com.google.common.base.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import extrabiomes.Extrabiomes;
import extrabiomes.api.PluginEvent;
import extrabiomes.api.Stuff;
import extrabiomes.blocks.BlockCustomSapling;
import extrabiomes.blocks.BlockNewSapling;
import extrabiomes.helpers.ForestryModHelper;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ForestryPlugin {
    private Object fermenterManager;
    private Object carpenterManager;
    private static boolean enabled = true;
    private ArrayList plainFlowers;
    private ArrayList leafBlockIds;
    private ArrayList[] backpackItems;
    private Optional<Method> carpenterAddRecipe = Optional.absent();
    private Optional<Method> fermenterAddRecipe = Optional.absent();
    private Optional<Method> getForestryItem = Optional.absent();
    private static Optional<Method> getForestryBlock = Optional.absent();
    private static final int DIGGER = 1;
    private static final int FORESTER = 2;
    private static final int BIOMASS_SAPLINGS = 250;

    static yd getBlock(String name) {
        try {
            return (yd)((Method)getForestryBlock.get()).invoke(null, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addBackPackItems() {
        Collection<yd> items = ForestryModHelper.getForesterBackPackItems();
        for (yd item : items) {
            this.backpackItems[2].add(item);
        }
        items = ForestryModHelper.getDiggerBackPackItems();
        for (yd item : items) {
            this.backpackItems[1].add(item);
        }
        if (Stuff.quickSand.isPresent()) {
            this.backpackItems[1].add(new yd((aqw)Stuff.quickSand.get()));
        }
    }

    private void addBasicFlowers() {
        for (yd flower : ForestryModHelper.getBasicFlowers()) {
            this.plainFlowers.add(flower);
        }
    }

    private void addFermenterRecipeSapling(yd resource) throws Exception {
        for (String type : new String[]{"water", "biomass", "honey", "juice"}) {
            if (FluidRegistry.isFluidRegistered((String)type)) continue;
            LogHelper.warning("Unable to find fluid named '%s' when adding Forestry fermenter recipes.", type);
            return;
        }
        try {
            ((Method)this.fermenterAddRecipe.get()).invoke(this.fermenterManager, resource, 250, Float.valueOf(1.0f), this.getFluidStack("biomass"), this.getFluidStack("water"));
            ((Method)this.fermenterAddRecipe.get()).invoke(this.fermenterManager, resource, 250, Float.valueOf(1.5f), this.getFluidStack("biomass"), this.getFluidStack("juice"));
            ((Method)this.fermenterAddRecipe.get()).invoke(this.fermenterManager, resource, 250, Float.valueOf(1.5f), this.getFluidStack("biomass"), this.getFluidStack("honey"));
        }
        catch (Exception e) {
            LogHelper.severe("The forestry API changed in reguards to fluids/liquids.", new Object[0]);
        }
    }

    private void addGlobals() {
        Collection<yd> items = ForestryModHelper.getLeaves();
        for (yd item : items) {
            this.leafBlockIds.add(item.d);
        }
    }

    private void addRecipes() throws Exception {
        if (this.fermenterAddRecipe.isPresent() && this.getForestryItem.isPresent()) {
            for (yd sapling : ForestryModHelper.getSaplings()) {
                this.addFermenterRecipeSapling(sapling);
            }
        }
        if (this.carpenterAddRecipe.isPresent() && Element.RED_COBBLE.isPresent()) {
            ((Method)this.carpenterAddRecipe.get()).invoke(this.carpenterManager, 10, new FluidStack(aqw.G.cF, 3000), null, new yd(yb.aK, 4), new Object[]{"#", Character.valueOf('#'), Element.RED_COBBLE.get()});
        }
    }

    private void addSaplings() {
        Optional soil = Optional.fromNullable((Object)ForestryPlugin.getBlock("soil"));
        if (soil.isPresent()) {
            TreeSoilRegistry.addValidSoil(aqw.s[((yd)soil.get()).d]);
            BlockCustomSapling.setForestrySoilID(((yd)soil.get()).d);
            BlockNewSapling.setForestrySoilID(((yd)soil.get()).d);
        }
        for (yd sapling : ForestryModHelper.getSaplings()) {
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.%s", sapling.d, sapling.k()));
        }
    }

    private FluidStack getFluidStack(String name) throws Exception {
        return FluidRegistry.getFluidStack((String)name, (int)1);
    }

    @ForgeSubscribe
    public void init(PluginEvent.Init event) throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        this.addSaplings();
        this.addBasicFlowers();
        this.addGlobals();
        this.addBackPackItems();
        this.addRecipes();
    }

    private boolean isEnabled() {
        return enabled && Extrabiomes.proxy.isModLoaded("Forestry");
    }

    @ForgeSubscribe
    public void preInit(PluginEvent.Pre event) {
        if (!this.isEnabled()) {
            return;
        }
        LogHelper.fine("Initializing %s plugin.", "Forestry");
        try {
            Class<?> cls = Class.forName("forestry.api.core.ItemInterface");
            this.getForestryItem = Optional.fromNullable((Object)cls.getMethod("getItem", String.class));
            cls = Class.forName("forestry.api.core.BlockInterface");
            getForestryBlock = Optional.fromNullable((Object)cls.getMethod("getBlock", String.class));
            cls = Class.forName("forestry.api.recipes.RecipeManagers");
            Field fld = cls.getField("fermenterManager");
            this.fermenterManager = fld.get(null);
            fld = cls.getField("carpenterManager");
            this.carpenterManager = fld.get(null);
            cls = Class.forName("forestry.api.apiculture.FlowerManager");
            fld = cls.getField("plainFlowers");
            this.plainFlowers = (ArrayList)fld.get(null);
            cls = Class.forName("forestry.api.core.GlobalManager");
            fld = cls.getField("leafBlockIds");
            this.leafBlockIds = (ArrayList)fld.get(null);
            cls = Class.forName("forestry.api.storage.BackpackManager");
            fld = cls.getField("backpackItems");
            this.backpackItems = (ArrayList[])fld.get(null);
            cls = Class.forName("forestry.api.recipes.IFermenterManager");
            this.fermenterAddRecipe = Optional.fromNullable((Object)cls.getMethod("addRecipe", yd.class, Integer.TYPE, Float.TYPE, FluidStack.class, FluidStack.class));
            cls = Class.forName("forestry.api.recipes.ICarpenterManager");
            this.carpenterAddRecipe = Optional.fromNullable((Object)cls.getMethod("addRecipe", Integer.TYPE, FluidStack.class, yd.class, yd.class, Object[].class));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogHelper.fine("Could not communicate with %s. Disabling plugin.", "Forestry");
            enabled = false;
        }
    }
}

