/*
 * Decompiled with CFR 0.152.
 */
package com.voidzm.novamenu.gui;

import com.voidzm.novamenu.gui.GuiButtonTransparent;
import com.voidzm.novamenu.gui.GuiNovamenuCreateFlatWorld;
import com.voidzm.novamenu.gui.GuiNovamenuScreen;
import java.util.Random;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import org.lwjgl.input.Keyboard;

public class GuiNovamenuCreateWorld
extends GuiNovamenuScreen {
    private GuiNovamenuScreen parent;
    private GuiTextField textWorldName;
    private GuiTextField textWorldSeed;
    private String folderName;
    private String gamemode = "survival";
    private boolean generateStructures = true;
    private boolean allowCheats = false;
    private boolean cheatsToggled = false;
    private boolean bonusChest = false;
    private boolean isHardcore = false;
    private boolean createClicked;
    private boolean moreOptions;
    private GuiButtonTransparent buttonGamemode;
    private GuiButtonTransparent buttonMoreOptions;
    private GuiButtonTransparent buttonGenStructures;
    private GuiButtonTransparent buttonBonusChest;
    private GuiButtonTransparent buttonWorldType;
    private GuiButtonTransparent buttonAllowCheats;
    private GuiButtonTransparent buttonCustomize;
    private String gamemodeLine1;
    private String gamemodeLine2;
    private String seed;
    private String localizedNewWorldText;
    private int worldTypeID = 0;
    public String genOptions = "";
    private static final String[] ILLEGAL_WORLD_NAMES = new String[]{"CON", "COM", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    public GuiNovamenuCreateWorld(GuiNovamenuScreen parentScreen) {
        this.parent = parentScreen;
        this.imageTick = parentScreen.imageTick;
        this.seed = "";
        this.localizedNewWorldText = StatCollector.func_74838_a((String)"selectWorld.newWorld");
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.textWorldName.func_73780_a();
        this.textWorldSeed.func_73780_a();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttons.clear();
        this.buttons.add(new GuiButtonTransparent(this, this.field_73880_f / 2 - 155, this.field_73881_g - 28, 150, 16, 0, I18n.func_135053_a((String)"selectWorld.create")));
        this.buttons.add(new GuiButtonTransparent(this, this.field_73880_f / 2 + 5, this.field_73881_g - 28, 150, 16, 1, I18n.func_135053_a((String)"gui.cancel")));
        this.buttonGamemode = new GuiButtonTransparent(this, this.field_73880_f / 2 - 75, 115, 150, 16, 2, I18n.func_135053_a((String)"selectWorld.gameMode"));
        this.buttons.add(this.buttonGamemode);
        this.buttonMoreOptions = new GuiButtonTransparent(this, this.field_73880_f / 2 - 75, 187, 150, 16, 3, I18n.func_135053_a((String)"selectWorld.moreWorldOptions"));
        this.buttons.add(this.buttonMoreOptions);
        this.buttonGenStructures = new GuiButtonTransparent(this, this.field_73880_f / 2 - 155, 100, 150, 16, 4, I18n.func_135053_a((String)"selectWorld.mapFeatures"));
        this.buttons.add(this.buttonGenStructures);
        this.buttonGenStructures.drawButton = false;
        this.buttonBonusChest = new GuiButtonTransparent(this, this.field_73880_f / 2 + 5, 151, 150, 16, 7, I18n.func_135053_a((String)"selectWorld.bonusItems"));
        this.buttons.add(this.buttonBonusChest);
        this.buttonBonusChest.drawButton = false;
        this.buttonWorldType = new GuiButtonTransparent(this, this.field_73880_f / 2 + 5, 100, 150, 16, 5, I18n.func_135053_a((String)"selectWorld.mapType"));
        this.buttons.add(this.buttonWorldType);
        this.buttonWorldType.drawButton = false;
        this.buttonAllowCheats = new GuiButtonTransparent(this, this.field_73880_f / 2 - 155, 151, 150, 16, 6, I18n.func_135053_a((String)"selectWorld.allowCommands"));
        this.buttons.add(this.buttonAllowCheats);
        this.buttonAllowCheats.drawButton = false;
        this.buttonCustomize = new GuiButtonTransparent(this, this.field_73880_f / 2 + 5, 120, 150, 16, 8, I18n.func_135053_a((String)"selectWorld.customizeType"));
        this.buttons.add(this.buttonCustomize);
        this.buttonCustomize.drawButton = false;
        this.textWorldName = new GuiTextField(this.field_73886_k, this.field_73880_f / 2 - 100, 60, 200, 20);
        this.textWorldName.func_73796_b(true);
        this.textWorldName.func_73782_a(this.localizedNewWorldText);
        this.textWorldSeed = new GuiTextField(this.field_73886_k, this.field_73880_f / 2 - 100, 60, 200, 20);
        this.textWorldSeed.func_73782_a(this.seed);
        this.func_82288_a(this.moreOptions);
        this.makeUseableName();
        this.updateButtonText();
    }

    private void makeUseableName() {
        this.folderName = this.textWorldName.func_73781_b().trim();
        for (char c0 : ChatAllowedCharacters.field_71567_b) {
            this.folderName = this.folderName.replace(c0, '_');
        }
        if (MathHelper.func_76139_a((String)this.folderName)) {
            this.folderName = "World";
        }
        this.folderName = GuiNovamenuCreateWorld.removeIllegalNames(this.field_73882_e.func_71359_d(), this.folderName);
    }

    private void updateButtonText() {
        this.buttonGamemode.text = I18n.func_135053_a((String)"selectWorld.gameMode") + " " + I18n.func_135053_a((String)("selectWorld.gameMode." + this.gamemode));
        this.gamemodeLine1 = I18n.func_135053_a((String)("selectWorld.gameMode." + this.gamemode + ".line1"));
        this.gamemodeLine2 = I18n.func_135053_a((String)("selectWorld.gameMode." + this.gamemode + ".line2"));
        this.buttonGenStructures.text = I18n.func_135053_a((String)"selectWorld.mapFeatures") + " ";
        this.buttonGenStructures.text = this.generateStructures ? this.buttonGenStructures.text + I18n.func_135053_a((String)"options.on") : this.buttonGenStructures.text + I18n.func_135053_a((String)"options.off");
        this.buttonBonusChest.text = I18n.func_135053_a((String)"selectWorld.bonusItems") + " ";
        this.buttonBonusChest.text = this.bonusChest && !this.isHardcore ? this.buttonBonusChest.text + I18n.func_135053_a((String)"options.on") : this.buttonBonusChest.text + I18n.func_135053_a((String)"options.off");
        this.buttonWorldType.text = I18n.func_135053_a((String)"selectWorld.mapType") + " " + I18n.func_135053_a((String)WorldType.field_77139_a[this.worldTypeID].func_77128_b());
        this.buttonAllowCheats.text = I18n.func_135053_a((String)"selectWorld.allowCommands") + " ";
        this.buttonAllowCheats.text = this.allowCheats && !this.isHardcore ? this.buttonAllowCheats.text + I18n.func_135053_a((String)"options.on") : this.buttonAllowCheats.text + I18n.func_135053_a((String)"options.off");
    }

    public static String removeIllegalNames(ISaveFormat par0ISaveFormat, String par1Str) {
        par1Str = par1Str.replaceAll("[\\./\"]", "_");
        for (String s1 : ILLEGAL_WORLD_NAMES) {
            if (!par1Str.equalsIgnoreCase(s1)) continue;
            par1Str = "_" + par1Str + "_";
        }
        while (par0ISaveFormat.func_75803_c(par1Str) != null) {
            par1Str = par1Str + "-";
        }
        return par1Str;
    }

    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public void buttonEvent(int id) {
        switch (id) {
            case 0: {
                this.field_73882_e.func_71373_a((GuiScreen)null);
                if (this.createClicked) {
                    return;
                }
                this.createClicked = true;
                long i = new Random().nextLong();
                String s = this.textWorldSeed.func_73781_b();
                if (!MathHelper.func_76139_a((String)s)) {
                    try {
                        long j = Long.parseLong(s);
                        if (j != 0L) {
                            i = j;
                        }
                    }
                    catch (NumberFormatException numberformatexception) {
                        i = s.hashCode();
                    }
                }
                WorldType.field_77139_a[this.worldTypeID].onGUICreateWorldPress();
                EnumGameType enumgametype = EnumGameType.func_77142_a((String)this.gamemode);
                WorldSettings worldsettings = new WorldSettings(i, enumgametype, this.generateStructures, this.isHardcore, WorldType.field_77139_a[this.worldTypeID]);
                worldsettings.func_82750_a(this.genOptions);
                if (this.bonusChest && !this.isHardcore) {
                    worldsettings.func_77159_a();
                }
                if (this.allowCheats && !this.isHardcore) {
                    worldsettings.func_77166_b();
                }
                this.field_73882_e.func_71371_a(this.folderName, this.textWorldName.func_73781_b().trim(), worldsettings);
                break;
            }
            case 1: {
                this.parent.imageTick = this.imageTick;
                this.field_73882_e.func_71373_a((GuiScreen)this.parent);
                break;
            }
            case 2: {
                if (this.gamemode.equals("survival")) {
                    if (!this.cheatsToggled) {
                        this.cheatsToggled = false;
                    }
                    this.isHardcore = false;
                    this.gamemode = "hardcore";
                    this.isHardcore = true;
                    this.buttonAllowCheats.enabled = false;
                    this.buttonBonusChest.enabled = false;
                    this.updateButtonText();
                } else if (this.gamemode.equals("hardcore")) {
                    if (!this.cheatsToggled) {
                        this.allowCheats = true;
                    }
                    this.isHardcore = false;
                    this.gamemode = "creative";
                    this.updateButtonText();
                    this.isHardcore = false;
                    this.buttonAllowCheats.enabled = true;
                    this.buttonBonusChest.enabled = true;
                } else {
                    if (!this.cheatsToggled) {
                        this.allowCheats = false;
                    }
                    this.gamemode = "survival";
                    this.updateButtonText();
                    this.buttonAllowCheats.enabled = true;
                    this.buttonBonusChest.enabled = true;
                    this.isHardcore = false;
                }
                this.updateButtonText();
                break;
            }
            case 3: {
                this.func_82287_i();
                break;
            }
            case 4: {
                this.generateStructures = !this.generateStructures;
                this.updateButtonText();
                break;
            }
            case 5: {
                ++this.worldTypeID;
                if (this.worldTypeID >= WorldType.field_77139_a.length) {
                    this.worldTypeID = 0;
                }
                while (WorldType.field_77139_a[this.worldTypeID] == null || !WorldType.field_77139_a[this.worldTypeID].func_77126_d()) {
                    ++this.worldTypeID;
                    if (this.worldTypeID < WorldType.field_77139_a.length) continue;
                    this.worldTypeID = 0;
                }
                this.genOptions = "";
                this.updateButtonText();
                this.func_82288_a(this.moreOptions);
                break;
            }
            case 6: {
                this.cheatsToggled = true;
                this.allowCheats = !this.allowCheats;
                this.updateButtonText();
                break;
            }
            case 7: {
                this.bonusChest = !this.bonusChest;
                this.updateButtonText();
                break;
            }
            case 8: {
                if (WorldType.field_77139_a[this.worldTypeID] != WorldType.field_77138_c) break;
                this.field_73882_e.func_71373_a((GuiScreen)new GuiNovamenuCreateFlatWorld(this, this.genOptions));
            }
        }
    }

    private void func_82287_i() {
        this.func_82288_a(!this.moreOptions);
    }

    private void func_82288_a(boolean par1) {
        this.moreOptions = par1;
        this.buttonGamemode.drawButton = !this.moreOptions;
        this.buttonGenStructures.drawButton = this.moreOptions;
        this.buttonBonusChest.drawButton = this.moreOptions;
        this.buttonWorldType.drawButton = this.moreOptions;
        this.buttonAllowCheats.drawButton = this.moreOptions;
        this.buttonCustomize.drawButton = this.moreOptions && WorldType.field_77139_a[this.worldTypeID].isCustomizable();
        this.buttonMoreOptions.text = this.moreOptions ? I18n.func_135053_a((String)"gui.done") : I18n.func_135053_a((String)"selectWorld.moreWorldOptions");
    }

    protected void func_73869_a(char par1, int par2) {
        if (this.textWorldName.func_73806_l() && !this.moreOptions) {
            this.textWorldName.func_73802_a(par1, par2);
            this.localizedNewWorldText = this.textWorldName.func_73781_b();
        } else if (this.textWorldSeed.func_73806_l() && this.moreOptions) {
            this.textWorldSeed.func_73802_a(par1, par2);
            this.seed = this.textWorldSeed.func_73781_b();
        }
        if (par1 == '\r') {
            this.func_73875_a((GuiButton)this.field_73887_h.get(0));
        }
        ((GuiButtonTransparent)((Object)this.buttons.get((int)0))).enabled = this.textWorldName.func_73781_b().length() > 0;
        this.makeUseableName();
    }

    @Override
    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        if (this.moreOptions) {
            this.textWorldSeed.func_73793_a(par1, par2, par3);
        } else {
            this.textWorldName.func_73793_a(par1, par2, par3);
        }
    }

    @Override
    public void drawScreenForeground(int par1, int par2, float par3) {
        GuiNovamenuCreateWorld.func_73734_a((int)0, (int)0, (int)this.field_73880_f, (int)this.field_73881_g, (int)-1157627904);
        super.drawScreenForeground(par1, par2, par3);
        this.func_73732_a(this.field_73886_k, I18n.func_135053_a((String)"selectWorld.create"), this.field_73880_f / 2, 20, 0xFFFFFF);
        if (this.moreOptions) {
            this.func_73731_b(this.field_73886_k, I18n.func_135053_a((String)"selectWorld.enterSeed"), this.field_73880_f / 2 - 100, 47, 0xA0A0A0);
            this.func_73731_b(this.field_73886_k, I18n.func_135053_a((String)"selectWorld.seedInfo"), this.field_73880_f / 2 - 100, 85, 0xA0A0A0);
            this.func_73731_b(this.field_73886_k, I18n.func_135053_a((String)"selectWorld.mapFeatures.info"), this.field_73880_f / 2 - 150, 122, 0xA0A0A0);
            this.func_73731_b(this.field_73886_k, I18n.func_135053_a((String)"selectWorld.allowCommands.info"), this.field_73880_f / 2 - 150, 172, 0xA0A0A0);
            this.textWorldSeed.func_73795_f();
        } else {
            this.func_73731_b(this.field_73886_k, I18n.func_135053_a((String)"selectWorld.enterName"), this.field_73880_f / 2 - 100, 47, 0xA0A0A0);
            this.func_73731_b(this.field_73886_k, I18n.func_135053_a((String)"selectWorld.resultFolder") + " " + this.folderName, this.field_73880_f / 2 - 100, 85, 0xA0A0A0);
            this.textWorldName.func_73795_f();
            this.func_73731_b(this.field_73886_k, this.gamemodeLine1, this.field_73880_f / 2 - 100, 137, 0xA0A0A0);
            this.func_73731_b(this.field_73886_k, this.gamemodeLine2, this.field_73880_f / 2 - 100, 149, 0xA0A0A0);
        }
    }

    public void func_82286_a(WorldInfo par1WorldInfo) {
        this.localizedNewWorldText = StatCollector.func_74837_a((String)"selectWorld.newWorld.copyOf", (Object[])new Object[]{par1WorldInfo.func_76065_j()});
        this.seed = par1WorldInfo.func_76063_b() + "";
        this.worldTypeID = par1WorldInfo.func_76067_t().func_82747_f();
        this.genOptions = par1WorldInfo.func_82571_y();
        this.generateStructures = par1WorldInfo.func_76089_r();
        this.allowCheats = par1WorldInfo.func_76086_u();
        if (par1WorldInfo.func_76093_s()) {
            this.gamemode = "hardcore";
        } else if (par1WorldInfo.func_76077_q().func_77144_e()) {
            this.gamemode = "survival";
        } else if (par1WorldInfo.func_76077_q().func_77145_d()) {
            this.gamemode = "creative";
        }
    }
}

