/*
 * Decompiled with CFR 0.152.
 */
package worldChangers.TuxCraft.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import worldChangers.TuxCraft.WorldChangersCore;
import worldChangers.TuxCraft.WorldGenUtils;
import worldChangers.TuxCraft.world.WCChestGenHooks;

public class WorldGenVolcano
extends WorldGenerator {
    public static final WeightedRandomChestContent[] volcanoDungeonLoot = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Item.field_77765_aA.field_77779_bT, 0, 1, 2, 8), new WeightedRandomChestContent(Item.field_77767_aC.field_77779_bT, 0, 1, 8, 6), new WeightedRandomChestContent(Item.field_77702_n.field_77779_bT, 0, 1, 2, 3), new WeightedRandomChestContent(Item.field_77703_o.field_77779_bT, 0, 1, 4, 8), new WeightedRandomChestContent(Item.field_77730_bn.field_77779_bT, 0, 1, 1, 5), new WeightedRandomChestContent(Item.field_82791_bT.field_77779_bT, 0, 1, 4, 8), new WeightedRandomChestContent(Item.field_111213_cg.field_77779_bT, 0, 1, 1, 4), new WeightedRandomChestContent(Item.field_111216_cf.field_77779_bT, 0, 1, 1, 6), new WeightedRandomChestContent(Item.field_111215_ce.field_77779_bT, 0, 1, 1, 8), new WeightedRandomChestContent(Item.field_111212_ci.field_77779_bT, 0, 1, 1, 8)};

    public WorldGenVolcano(boolean b) {
        super(b);
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int baseRadius = (random.nextInt(4) + 5) * 5;
        int mouthRadius = random.nextInt(5) + 2;
        int heightScale = random.nextInt(3) + 2;
        y = WorldGenUtils.getMinimumBlockHeight(x - baseRadius, z - baseRadius, baseRadius * 2, baseRadius * 2, world);
        int curRaidus = baseRadius;
        int curY = y;
        int curChanceOfNarrowing = heightScale;
        while (curRaidus > mouthRadius) {
            WorldGenVolcano.drawVolcanoCircle(x, curY, z, curRaidus, world, WorldChangersCore.volcanicRock.field_71990_ca, Block.field_71944_C.field_71990_ca, random);
            WorldGenUtils.drawCircle(x, curY, z, curRaidus - 3, world, Block.field_71944_C.field_71990_ca);
            curChanceOfNarrowing = heightScale;
            --curRaidus;
            --curChanceOfNarrowing;
            ++curY;
        }
        for (int i = --curY; i > y; --i) {
            WorldGenVolcano.drawVolcanoCircle(x, i, z, mouthRadius - 2, world, Block.field_71944_C.field_71990_ca, WorldChangersCore.volcanicRock.field_71990_ca, random);
        }
        int volcanoDungeonOffset = (curY - y) / 2;
        WorldGenUtils.drawCube(x - 2, y - 5 + volcanoDungeonOffset, z - 2, 5, 5, 5, Block.field_72033_bA.field_71990_ca, world);
        WorldGenUtils.drawCube(x - 2, y - 4 + volcanoDungeonOffset, z - 2, 5, 3, 5, Block.field_72002_bp.field_71990_ca, world);
        WorldGenUtils.drawCube(x - 1, y - 4 + volcanoDungeonOffset, z - 1, 3, 4, 3, Block.field_72007_bm.field_71990_ca, world);
        WorldGenUtils.clearCube(x - 1, y - 4 + volcanoDungeonOffset, z - 1, 3, 3, 3, world);
        world.func_94575_c(x, y - 4 + volcanoDungeonOffset, z, Block.field_72077_au.field_71990_ca);
        TileEntityChest tileentitychest = (TileEntityChest)world.func_72796_p(x, y - 4 + volcanoDungeonOffset, z);
        if (tileentitychest != null) {
            WCChestGenHooks info = WCChestGenHooks.getInfo("volcano");
            WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])info.getItems(random), (IInventory)tileentitychest, (int)info.getCount(random));
        }
        return true;
    }

    public static void drawVolcanoCircle(int x, int y, int z, double r, World world, int bid, int b2id, Random random) {
        for (double i = -r; i < r; i += 1.0) {
            for (double j = -r; j < r; j += 1.0) {
                if (!(Math.sqrt(Math.pow(i, 2.0) + Math.pow(j, 2.0)) <= r)) continue;
                int randomInt = random.nextInt(150);
                if (randomInt == 1) {
                    world.func_94575_c((int)i + x, y, (int)j + z, b2id);
                    continue;
                }
                if (randomInt < 30) {
                    world.func_94571_i((int)i + x, y, (int)j + z);
                    continue;
                }
                world.func_94575_c((int)i + x, y, (int)j + z, bid);
            }
        }
    }
}

