/*
 * Decompiled with CFR 0.152.
 */
package worldChangers.TuxCraft.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import worldChangers.TuxCraft.WorldChangersCore;
import worldChangers.TuxCraft.WorldGenUtils;
import worldChangers.TuxCraft.world.WCChestGenHooks;

public class WorldGenGhastHive
extends WorldGenerator {
    public static final WeightedRandomChestContent[] ghastHiveSmallChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Item.field_77722_bw.field_77779_bT, 2, 0, 1, 6), new WeightedRandomChestContent(Item.field_77731_bo.field_77779_bT, 1, 0, 1, 4), new WeightedRandomChestContent(Item.field_94583_ca.field_77779_bT, 3, 0, 1, 10), new WeightedRandomChestContent(new ItemStack(Item.field_82799_bQ, 1, 1), 1, 5, 6), new WeightedRandomChestContent(Item.field_77677_M.field_77779_bT, 2, 0, 1, 8), new WeightedRandomChestContent(Item.field_77732_bp.field_77779_bT, 2, 1, 5, 10)};
    public static final int MAX_SIZE = 30;
    public static final int MIN_SIZE = 15;

    public WorldGenGhastHive(boolean b) {
        super(b);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int i;
        int ground = 0;
        int top = 0;
        int raidus = 0;
        for (i = 126; i > 10; --i) {
            if (world.func_72798_a(x, i, z) != 0) continue;
            top = i;
            break;
        }
        for (i = top; i > 0; --i) {
            if (world.func_72798_a(x, i, z) == 0) continue;
            ground = i;
            break;
        }
        if ((raidus = (top - ground) / 2) > 30) {
            raidus = 30;
        }
        if (raidus < 15) {
            raidus = 15;
        }
        WorldGenGhastHive.drawSphereWithLava(x, top - raidus, z, raidus, WorldChangersCore.ghastHive.field_71990_ca, rand, world);
        WorldGenGhastHive.makeHoles(x, top - raidus, z, raidus, world);
        WorldGenUtils.clearSphere(x, top - raidus, z, raidus - 2, world);
        this.drawRandomSphere(x, top - raidus, z, raidus - 1, rand, world);
        for (i = 0; i < raidus; ++i) {
        }
        WorldGenUtils.drawCube(x, ground + i - 1, z, 5, 1, 5, WorldChangersCore.ghastHive.field_71990_ca, world);
        world.func_94575_c(x, ground + i, z, Block.field_72077_au.field_71990_ca);
        TileEntityChest tileentitychest = (TileEntityChest)world.func_72796_p(x, ground + i, z);
        if (tileentitychest != null) {
            WCChestGenHooks info = WCChestGenHooks.getInfo("volcano");
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)tileentitychest, (int)info.getCount(rand));
        }
        return true;
    }

    public void drawRandomSphere(int x, int y, int z, double r, Random rand, World world) {
        for (double i = -r; i < r; i += 1.0) {
            for (double j = -r; j < r; j += 1.0) {
                for (double k = -r; k < r; k += 1.0) {
                    if (!(Math.sqrt(Math.pow(i, 2.0) + Math.pow(j, 2.0) + Math.pow(k, 2.0)) <= r)) continue;
                    int random = rand.nextInt(2500);
                    if (random <= 1) {
                        world.func_72832_d((int)i + x, (int)j + y, (int)k + z, Block.field_72065_as.field_71990_ca, 0, 2);
                        TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_72796_p((int)i + x, (int)j + y, (int)k + z);
                        if (tileentitymobspawner != null) {
                            tileentitymobspawner.func_98049_a().func_98272_a("Ghast");
                            continue;
                        }
                        System.err.println("Failed to fetch mob spawner entity at (" + (i + (double)x) + ", " + (j + (double)y) + ", " + (k + (double)z) + ")");
                        continue;
                    }
                    if (random > 19) continue;
                    WorldGenUtils.drawCube((int)i + x - 2, (int)j + y, (int)k + z - 2, 4, 1, 4, WorldChangersCore.ghastHive.field_71990_ca, world);
                    int random2 = rand.nextInt(12);
                    if (random2 != 1) continue;
                    world.func_94575_c((int)i + x, (int)j + y + 1, (int)k + z, Block.field_72077_au.field_71990_ca);
                    TileEntityChest tileentitychest = (TileEntityChest)world.func_72796_p((int)i + x, (int)j + y + 1, (int)k + z);
                    if (tileentitychest == null) continue;
                    WCChestGenHooks info = WCChestGenHooks.getInfo("hiveSmall");
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)tileentitychest, (int)info.getCount(rand));
                }
            }
        }
    }

    public static void drawSphereWithLava(int x, int y, int z, double r, int block, Random rand, World world) {
        for (double i = -r; i < r; i += 1.0) {
            for (double j = -r; j < r; j += 1.0) {
                for (double k = -r; k < r; k += 1.0) {
                    if (!(Math.sqrt(Math.pow(i, 2.0) + Math.pow(j, 2.0) + Math.pow(k, 2.0)) <= r)) continue;
                    int random = rand.nextInt(200);
                    if (random <= 3) {
                        world.func_94575_c((int)i + x, (int)j + y, (int)k + z, Block.field_71945_L.field_71990_ca);
                        continue;
                    }
                    if (random <= 4) {
                        int a = 1;
                        while ((double)a <= (double)(128 - y) - j) {
                            if (world.func_72799_c((int)i + x, (int)j + y + a, (int)k + z)) {
                                world.func_94575_c((int)i + x, (int)j + y + a, (int)k + z, Block.field_71955_W.field_71990_ca);
                            }
                            ++a;
                        }
                        continue;
                    }
                    if (random <= 6) {
                        world.func_72832_d((int)i + x, (int)j + y, (int)k + z, Block.field_72065_as.field_71990_ca, 0, 2);
                        TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_72796_p((int)i + x, (int)j + y, (int)k + z);
                        if (tileentitymobspawner != null) {
                            tileentitymobspawner.func_98049_a().func_98272_a("Ghast");
                            continue;
                        }
                        System.err.println("Failed to fetch mob spawner entity at (" + (i + (double)x) + ", " + (j + (double)y) + ", " + (k + (double)z) + ")");
                        continue;
                    }
                    world.func_94575_c((int)i + x, (int)j + y, (int)k + z, block);
                }
            }
        }
    }

    public static void makeHoles(int x, int y, int z, double r, World world) {
        for (double i = -r; i < r; i += 1.0) {
            for (double j = -r; j < r; j += 1.0) {
                for (double k = -r; k < r; k += 1.0) {
                    if (world.func_72798_a((int)i + x, (int)j + y, (int)k + z) != Block.field_71945_L.field_71990_ca) continue;
                    WorldGenUtils.clearCircle((int)i + x, (int)j + y, (int)k + z, 5.0, world);
                }
            }
        }
    }
}

