/*
 * Decompiled with CFR 0.152.
 */
package worldChangers.TuxCraft.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import worldChangers.TuxCraft.WorldChangersCore;
import worldChangers.TuxCraft.WorldGenUtils;

public class WorldGenCrater
extends WorldGenerator {
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int l;
        int length = rand.nextInt(5) + 10;
        int yr = rand.nextInt(360);
        int depth = rand.nextInt(8) + 5;
        int chainLength = rand.nextInt(10) + 10;
        int startWidth = rand.nextInt(8) + 5;
        int endWidth = rand.nextInt(2) + 1;
        int astroidSize = endWidth + rand.nextInt(5) + 4;
        y = WorldGenUtils.getMaximumBlockHeight(x - startWidth, z - startWidth, startWidth * 2, startWidth * 2, world);
        double nx = (double)length * Math.sin(Math.toRadians(yr)) + (double)x;
        double nz = (double)length * Math.cos(Math.toRadians(yr)) + (double)z;
        double ny = y - depth;
        double distance = Math.sqrt(Math.abs(nx - (double)x) + Math.abs(ny - (double)y) + Math.abs(nz - (double)z)) * 4.0;
        double xi = ((double)x - nx) / distance;
        double yi = ((double)y - ny) / distance;
        double zi = ((double)z - nz) / distance;
        double i = x;
        double j = y;
        double k = z;
        boolean genning = true;
        int numberOfBlocks = 0;
        double deltaWidth = (startWidth - endWidth) / chainLength;
        double curWidth = startWidth;
        while (genning) {
            WorldGenCrater.drawRandomCircle((int)i, (int)j, (int)k, (int)curWidth + 1, world, rand);
            WorldGenUtils.clearCircle((int)i, (int)j, (int)k, curWidth, world);
            i += xi;
            j -= yi;
            k += zi;
            curWidth -= deltaWidth;
            if (++numberOfBlocks <= 100) continue;
            genning = false;
            break;
        }
        j += (double)astroidSize;
        for (l = 0; l < astroidSize; ++l) {
            WorldGenCrater.drawAstroidCircle((int)i, (int)j, (int)k, l, world, Block.field_72082_bJ.field_71990_ca, Block.field_72082_bJ.field_71990_ca, rand);
            WorldGenCrater.drawAstroidCircle((int)i, (int)j, (int)k, l - 1, world, WorldChangersCore.astralCore.field_71990_ca, Block.field_72082_bJ.field_71990_ca, rand);
            j -= 1.0;
        }
        for (l = astroidSize; l > 0; --l) {
            WorldGenCrater.drawAstroidCircle((int)i, (int)j, (int)k, l, world, Block.field_72082_bJ.field_71990_ca, Block.field_72082_bJ.field_71990_ca, rand);
            WorldGenCrater.drawAstroidCircle((int)i, (int)j, (int)k, l - 1, world, WorldChangersCore.astralCore.field_71990_ca, Block.field_72082_bJ.field_71990_ca, rand);
            j -= 1.0;
        }
        return false;
    }

    public static void drawRandomCircle(int x, int y, int z, double r, World world, Random random) {
        for (double i = -r; i < r; i += 1.0) {
            for (double j = -r; j < r; j += 1.0) {
                if (!(Math.sqrt(Math.pow(i, 2.0) + Math.pow(j, 2.0)) <= r)) continue;
                int randomInt = random.nextInt(50);
                if (randomInt == 1) {
                    world.func_94575_c((int)i + x, y, (int)j + z, WorldChangersCore.infiniteFire.field_71990_ca);
                    continue;
                }
                if (randomInt >= 4) continue;
                world.func_94571_i((int)i + x, y, (int)j + z);
            }
        }
    }

    public static void drawAstroidCircle(int x, int y, int z, double r, World world, int bid, int b2id, Random random) {
        for (double i = -r; i < r; i += 1.0) {
            for (double j = -r; j < r; j += 1.0) {
                if (!(Math.sqrt(Math.pow(i, 2.0) + Math.pow(j, 2.0)) <= r)) continue;
                int randomInt = random.nextInt(150);
                if (randomInt == 1) {
                    world.func_94575_c((int)i + x, y, (int)j + z, b2id);
                    continue;
                }
                if (randomInt < 10) {
                    world.func_94571_i((int)i + x, y, (int)j + z);
                    continue;
                }
                world.func_94575_c((int)i + x, y, (int)j + z, bid);
            }
        }
    }
}

