/*
 * Decompiled with CFR 0.152.
 */
package worldChangers.TuxCraft.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import worldChangers.TuxCraft.WorldGenUtils;
import worldChangers.TuxCraft.world.WorldGenCrater;
import worldChangers.TuxCraft.world.WorldGenGhastHive;
import worldChangers.TuxCraft.world.WorldGenVolcano;

public class WorldChangersGenerator
implements IWorldGenerator {
    public static final int spawnRate = 142;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (chunkGenerator != null && chunkProvider != null) {
            switch (world.field_73011_w.field_76574_g) {
                case 0: {
                    this.generateOverworld(world, random, chunkX, chunkZ);
                    break;
                }
                case 1: {
                    this.generateEnd(world, random, chunkX, chunkZ);
                    break;
                }
                case -1: {
                    this.generateNether(world, random, chunkX, chunkZ);
                }
            }
        }
    }

    public void generateOverworld(World world, Random random, int chunkX, int chunkZ) {
        this.generateVolcano(world, random, chunkX, chunkZ);
    }

    private boolean generateVolcano(World world, Random random, int chunkX, int chunkZ) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = WorldGenUtils.getHighestBlock(world, x, z);
        if (world.func_72807_a((int)x, (int)z).field_76748_D > 0.0f && world.func_72807_a((int)x, (int)z).field_76749_E < 0.4f) {
            long start;
            if (random.nextInt(142) == 1) {
                start = System.currentTimeMillis();
                new WorldGenVolcano(true).func_76484_a(world, random, x, y, z);
                System.out.println("Volcono spawned at " + x + " " + y + " " + z + " In biome " + String.valueOf(world.func_72807_a((int)x, (int)z).field_76791_y) + ": Took " + (System.currentTimeMillis() - start) + " milliseconds");
            }
            if (random.nextInt(142) == 1) {
                start = System.currentTimeMillis();
                new WorldGenCrater().func_76484_a(world, random, x, y, z);
                System.out.println("Crater spawned at " + x + " " + y + " " + z + " In biome " + String.valueOf(world.func_72807_a((int)x, (int)z).field_76791_y) + ": Took " + (System.currentTimeMillis() - start) + " milliseconds");
            }
        }
        return true;
    }

    public void generateEnd(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateNether(World world, Random random, int chunkX, int chunkZ) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = WorldGenUtils.getHighestBlock(world, x, z);
        if (random.nextInt(142) == 1) {
            long start = System.currentTimeMillis();
            new WorldGenGhastHive(true).func_76484_a(world, random, x, y, z);
            System.out.println("Ghast Hive spawned at " + x + " " + y + " " + z + ": Took " + (System.currentTimeMillis() - start) + " milliseconds");
        }
    }
}

