/*
 * Decompiled with CFR 0.152.
 */
package worldChangers.TuxCraft.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.util.WeightedRandomItem;
import net.minecraftforge.common.ChestGenHooks;
import worldChangers.TuxCraft.world.WorldGenGhastHive;
import worldChangers.TuxCraft.world.WorldGenVolcano;

public class WCChestGenHooks {
    public static final String VOLCANO = "volcano";
    public static final String HIVE_SMALL = "hiveSmall";
    private static final HashMap<String, WCChestGenHooks> WCchestInfo = new HashMap();
    private static boolean hasInit = false;
    private String category;
    private int countMin = 0;
    private int countMax = 0;
    ArrayList<WeightedRandomChestContent> contents = new ArrayList();

    private static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        WCChestGenHooks.addInfo(VOLCANO, WorldGenVolcano.volcanoDungeonLoot, 10, 10);
        WCChestGenHooks.addInfo(HIVE_SMALL, WorldGenGhastHive.ghastHiveSmallChestContents, 3, 5);
        ItemStack book = new ItemStack((Item)Item.field_92105_bW, 1, 0);
        WeightedRandomChestContent tmp = new WeightedRandomChestContent(book, 1, 1, 1);
        WCChestGenHooks.getInfo(VOLCANO).addItem(tmp);
    }

    static void addDungeonLoot(ChestGenHooks dungeon, ItemStack item, int weight, int min, int max) {
        dungeon.addItem(new WeightedRandomChestContent(item, min, max, weight));
    }

    private static void addInfo(String category, WeightedRandomChestContent[] items, int min, int max) {
        WCchestInfo.put(category, new WCChestGenHooks(category, items, min, max));
    }

    public static WCChestGenHooks getInfo(String category) {
        if (!WCchestInfo.containsKey(category)) {
            WCchestInfo.put(category, new WCChestGenHooks(category));
        }
        return WCchestInfo.get(category);
    }

    public static ItemStack[] generateStacks(Random rand, ItemStack source, int min, int max) {
        ItemStack[] ret;
        int count = min + rand.nextInt(max - min + 1);
        if (source.func_77973_b() == null) {
            ret = new ItemStack[]{};
        } else if (count > source.func_77973_b().func_77639_j()) {
            ret = new ItemStack[count];
            for (int x = 0; x < count; ++x) {
                ret[x] = source.func_77946_l();
                ret[x].field_77994_a = 1;
            }
        } else {
            ret = new ItemStack[]{source.func_77946_l()};
            ret[0].field_77994_a = count;
        }
        return ret;
    }

    public static WeightedRandomChestContent[] getItems(String category, Random rnd) {
        return WCChestGenHooks.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return WCChestGenHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, WeightedRandomChestContent item) {
        WCChestGenHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, ItemStack item) {
        WCChestGenHooks.getInfo(category).removeItem(item);
    }

    public static ItemStack getOneItem(String category, Random rand) {
        return WCChestGenHooks.getInfo(category).getOneItem(rand);
    }

    public WCChestGenHooks(String category) {
        this.category = category;
    }

    public WCChestGenHooks(String category, WeightedRandomChestContent[] items, int min, int max) {
        this(category);
        for (WeightedRandomChestContent item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }

    public void addItem(WeightedRandomChestContent item) {
        this.contents.add(item);
    }

    public void removeItem(ItemStack item) {
        Iterator<WeightedRandomChestContent> itr = this.contents.iterator();
        while (itr.hasNext()) {
            WeightedRandomChestContent cont = itr.next();
            if (!item.func_77969_a(cont.field_76297_b) && (item.func_77960_j() != Short.MAX_VALUE || item.field_77993_c != cont.field_76297_b.field_77993_c)) continue;
            itr.remove();
        }
    }

    public WeightedRandomChestContent[] getItems(Random rnd) {
        ArrayList<WeightedRandomChestContent> ret = new ArrayList<WeightedRandomChestContent>();
        for (WeightedRandomChestContent orig : this.contents) {
            WeightedRandomChestContent n;
            Item item = orig.field_76297_b.func_77973_b();
            if (item == null || (n = this.getChestGenBase(this, rnd, orig, item)) == null) continue;
            ret.add(n);
        }
        return ret.toArray(new WeightedRandomChestContent[ret.size()]);
    }

    public WeightedRandomChestContent getChestGenBase(WCChestGenHooks chest, Random rnd, WeightedRandomChestContent original, Item item) {
        if (item instanceof ItemEnchantedBook) {
            return ((ItemEnchantedBook)item).func_92112_a(rnd, original.field_76295_d, original.field_76296_e, original.field_76292_a);
        }
        return original;
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public ItemStack getOneItem(Random rand) {
        WeightedRandomChestContent[] items = this.getItems(rand);
        WeightedRandomChestContent item = (WeightedRandomChestContent)WeightedRandom.func_76274_a((Random)rand, (WeightedRandomItem[])items);
        ItemStack[] stacks = ChestGenHooks.generateStacks((Random)rand, (ItemStack)item.field_76297_b, (int)item.field_76295_d, (int)item.field_76296_e);
        return stacks.length > 0 ? stacks[0] : null;
    }

    public int getMin() {
        return this.countMin;
    }

    public int getMax() {
        return this.countMax;
    }

    public void setMin(int value) {
        this.countMin = value;
    }

    public void setMax(int value) {
        this.countMax = value;
    }

    static {
        WCChestGenHooks.init();
    }
}

