/*
 * Decompiled with CFR 0.152.
 */
package ic2.neiIntegration.core;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class MachineRecipeHandler
extends TemplateRecipeHandler {
    int ticks;

    public abstract String getRecipeName();

    public abstract String getRecipeId();

    public abstract String getGuiTexture();

    public abstract String getOverlayIdentifier();

    public abstract Map<ItemStack, ItemStack> getRecipeList();

    public void drawBackground(GuiContainerManager guimanager, int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guimanager.bindTexture(this.getGuiTexture());
        guimanager.drawTexturedModalRect(0, 0, 5, 11, 140, 65);
    }

    public void drawExtras(GuiContainerManager guimanager, int i) {
        float f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(guimanager, 74, 23, 176, 14, 25, 16, f, 0);
        f = this.ticks <= 20 ? (float)this.ticks / 20.0f : 1.0f;
        this.drawProgressBar(guimanager, 51, 25, 176, 0, 14, 14, f, 3);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ItemStack, ItemStack> irecipe : this.getRecipeList().entrySet()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ItemStack, ItemStack> irecipe : this.getRecipeList().entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<ItemStack, ItemStack> irecipe : this.getRecipeList().entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getKey(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack input;
        public PositionedStack output;

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedIORecipe(ItemStack itemstack, ItemStack itemstack1) {
            super((TemplateRecipeHandler)MachineRecipeHandler.this);
            this.input = new PositionedStack((Object)itemstack, 51, 6);
            this.output = new PositionedStack((Object)itemstack1, 111, 24);
        }

        public CachedIORecipe(Map.Entry<ItemStack, ItemStack> recipe) {
            this(recipe.getKey(), recipe.getValue());
        }
    }
}

