/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.util.StackUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class HandHeldInventory
implements IHasGui {
    protected ItemStack itemStack;
    protected ItemStack[] inventory;

    public HandHeldInventory(EntityPlayer entityPlayer, ItemStack itemStack, int inventorySize) {
        this.itemStack = itemStack;
        this.inventory = new ItemStack[inventorySize];
        if (IC2.platform.isSimulating()) {
            NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(itemStack);
            nbtTagCompound.func_74768_a("uid", new Random().nextInt());
            NBTTagList nbtTagList = nbtTagCompound.func_74761_m("Items");
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound nbtTagCompoundSlot = (NBTTagCompound)nbtTagList.func_74743_b(i);
                byte slot = nbtTagCompoundSlot.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompoundSlot);
            }
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack ret = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return ret;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
        if (IC2.platform.isSimulating()) {
            int i;
            NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(this.itemStack);
            boolean dropItself = false;
            for (int i2 = 0; i2 < this.func_70302_i_(); ++i2) {
                if (this.inventory[i2] == null) continue;
                NBTTagCompound nbtTagCompoundSlot = StackUtil.getOrCreateNbtData(this.inventory[i2]);
                if (nbtTagCompound.func_74762_e("uid") != nbtTagCompoundSlot.func_74762_e("uid")) continue;
                this.itemStack.field_77994_a = 1;
                this.inventory[i2] = null;
                dropItself = true;
                break;
            }
            NBTTagList nbtTagList = new NBTTagList();
            for (i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                NBTTagCompound nbtTagCompoundSlot = new NBTTagCompound();
                nbtTagCompoundSlot.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(nbtTagCompoundSlot);
                nbtTagList.func_74742_a((NBTBase)nbtTagCompoundSlot);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)nbtTagList);
            if (dropItself) {
                StackUtil.dropAsEntity(entityPlayer.field_70170_p, (int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u, (int)entityPlayer.field_70161_v, this.itemStack);
            } else {
                for (i = -1; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                    NBTTagCompound nbtTagCompoundSlot;
                    ItemStack itemStackSlot = i == -1 ? entityPlayer.field_71071_by.func_70445_o() : entityPlayer.field_71071_by.func_70301_a(i);
                    if (itemStackSlot == null || (nbtTagCompoundSlot = itemStackSlot.func_77978_p()) == null || nbtTagCompound.func_74762_e("uid") != nbtTagCompoundSlot.func_74762_e("uid")) continue;
                    this.itemStack.field_77994_a = 1;
                    if (i == -1) {
                        entityPlayer.field_71071_by.func_70437_b(this.itemStack);
                        break;
                    }
                    entityPlayer.field_71071_by.func_70299_a(i, this.itemStack);
                    break;
                }
            }
        }
    }

    public boolean matchesUid(int uid) {
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(this.itemStack);
        return nbtTagCompound.func_74762_e("uid") == uid;
    }
}

