/*
 * Decompiled with CFR 0.152.
 */
package rgcv.mods.uig;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.network.INetworkManager;
import net.minecraft.util.EnumChatFormatting;
import rgcv.mods.uig.gui.UIGIngameMenu;
import rgcv.mods.uig.handler.UIGTickHandler;
import rgcv.mods.uig.lib.Strings;

@Mod(modid="UIG", name="Useful Ingame GUI", version="build 3", certificateFingerprint="RGCV")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class UsefulIngameGui {
    public Minecraft theMinecraft = FMLClientHandler.instance().getClient();
    public static boolean legacyMenu;
    public static boolean ipOrSeedHidden;
    public static String lang;
    public static final File uigDir;
    public static final File uigLangDir;
    @Mod.Instance
    private static UsefulIngameGui instance;

    public static UsefulIngameGui instance() {
        return instance;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        TickRegistry.registerTickHandler((ITickHandler)new UIGTickHandler(), (Side)Side.CLIENT);
    }

    public UsefulIngameGui() {
        legacyMenu = false;
        ipOrSeedHidden = false;
        if (!uigDir.exists()) {
            uigDir.mkdirs();
            this.saveOptions();
        }
        if (!uigLangDir.exists()) {
            uigLangDir.mkdirs();
            this.createDefaultLanguageFile();
        }
        this.loadOptions();
    }

    public void overrideVanillaGui(Minecraft minecraft) {
        minecraft.field_71439_g.func_71053_j();
        minecraft.func_71373_a((GuiScreen)new UIGIngameMenu());
    }

    public InetSocketAddress getRemoteAddress(EntityClientPlayerMP thePlayer) {
        INetworkManager netManager = thePlayer.field_71174_a.func_72548_f();
        InetSocketAddress socketAddress = (InetSocketAddress)netManager.func_74430_c();
        return socketAddress;
    }

    public String getExternalAddress() throws MalformedURLException, IOException {
        URL myIP = new URL("http://api.externalip.net/ip/");
        BufferedReader in = new BufferedReader(new InputStreamReader(myIP.openStream()));
        return in.readLine();
    }

    public static String formatTime(Long time) {
        int hours24 = (int)(time / 1000L + 6L) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)time.longValue() / 16.666666f % 60.0f);
        String Time = String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
        return Time;
    }

    public static String formatString(String str, EnumChatFormatting clr) {
        EnumChatFormatting reset = EnumChatFormatting.RESET;
        return clr + str.replaceAll("\\.", reset + "." + clr).replaceAll(":", reset + ":" + clr);
    }

    public String translate(String key) {
        String translated = "";
        lang = this.theMinecraft.field_71474_y.field_74363_ab;
        File langFile = new File(uigLangDir, lang + ".lang");
        if (!langFile.exists() && !(langFile = new File(uigLangDir, "en_US.lang")).exists()) {
            this.createDefaultLanguageFile();
        }
        try {
            do {
                Scanner reader = new Scanner(langFile, "UTF-8");
                String buffer = "";
                while (reader.hasNextLine()) {
                    String[] settings;
                    buffer = reader.nextLine();
                    if (buffer.startsWith("#") || buffer.isEmpty() || !(settings = buffer.split("="))[0].equals(key)) continue;
                    translated = settings[1];
                }
                reader.close();
                if (translated.length() != 0) continue;
                this.createDefaultLanguageFile();
            } while (translated.length() == 0);
            return translated;
        }
        catch (Exception e) {
            e.printStackTrace();
            return key;
        }
    }

    public String translateSetting(String key1, String key2) {
        return this.translate(key1) + ": " + this.translate(key2);
    }

    private void createDefaultLanguageFile() {
        File langFile = new File(uigLangDir, "en_US.lang");
        try {
            int i;
            PrintWriter writer = new PrintWriter(new FileWriter(langFile));
            writer.println("# UIG Default Language File: " + lang);
            writer.println();
            for (i = 0; i < Strings.KEYS_MENU.length; ++i) {
                writer.println(Strings.KEYS_MENU[i] + "=" + Strings.DEFAULTS_MENU[i]);
            }
            writer.println();
            for (i = 0; i < Strings.KEYS_MENU_TINY.length; ++i) {
                writer.println(Strings.KEYS_MENU_TINY[i] + "=" + Strings.DEFAULTS_MENU_TINY[i]);
            }
            writer.println();
            for (i = 0; i < Strings.KEYS_STATE.length; ++i) {
                writer.println(Strings.KEYS_STATE[i] + "=" + Strings.DEFAULTS_STATE[i]);
            }
            writer.println();
            for (i = 0; i < Strings.KEYS_SETTING_DIFFICULTY.length; ++i) {
                writer.println(Strings.KEYS_SETTING_DIFFICULTY[i] + "=" + Strings.DEFAULTS_SETTING_DIFFICULTY[i]);
            }
            writer.println();
            for (i = 0; i < Strings.KEYS_SETTING_GRAPHICS.length; ++i) {
                writer.println(Strings.KEYS_SETTING_GRAPHICS[i] + "=" + Strings.DEFAULTS_SETTING_GRAPHICS[i]);
            }
            writer.println();
            for (i = 0; i < Strings.KEYS_SETTING_GUI_SCALE.length; ++i) {
                writer.println(Strings.KEYS_SETTING_GUI_SCALE[i] + "=" + Strings.DEFAULTS_SETTING_GUI_SCALE[i]);
            }
            writer.println();
            for (i = 0; i < Strings.KEYS_SETTING_FOG.length; ++i) {
                writer.println(Strings.KEYS_SETTING_FOG[i] + "=" + Strings.DEFAULTS_SETTING_FOG[i]);
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveOptions() {
        File config = new File(uigDir, "options.txt");
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(config));
            writer.println("# UIG Options File");
            writer.println("# Last Modified: " + Calendar.getInstance().getTime());
            writer.println();
            writer.println("option.legacyMenu=" + legacyMenu);
            writer.print("option.ipOrSeedHidden=" + ipOrSeedHidden);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadOptions() {
        File config = new File(uigDir, "options.txt");
        if (!config.exists()) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(config));
            String buffer = "";
            while ((buffer = reader.readLine()) != null) {
                if (buffer.startsWith("#") || buffer.startsWith(" ")) continue;
                String[] settings = buffer.split("=");
                if (settings[0].equals("option.legacyMenu")) {
                    legacyMenu = settings[1].equals("true");
                }
                if (!settings[0].equals("option.ipOrSeedHidden")) continue;
                ipOrSeedHidden = settings[1].equals("true");
            }
            reader.close();
        }
        catch (Exception e) {
            this.saveOptions();
            e.printStackTrace();
        }
    }

    static {
        uigDir = new File(FMLClientHandler.instance().getClient().field_71412_D, "mods" + File.separatorChar + "uig");
        uigLangDir = new File(uigDir, "lang");
        instance = new UsefulIngameGui();
    }
}

