/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFWorld;

public class TFGenCaveStalactite
extends TFGenerator {
    public static TFGenCaveStalactite diamond = new TFGenCaveStalactite(aqw.aB.cF, 0.5f, 4, 16);
    public static TFGenCaveStalactite lapis = new TFGenCaveStalactite(aqw.S.cF, 0.8f, 8, 1);
    public static TFGenCaveStalactite emerald = new TFGenCaveStalactite(aqw.bW.cF, 0.5f, 3, 12);
    public static TFGenCaveStalactite gold = new TFGenCaveStalactite(aqw.L.cF, 0.6f, 6, 1);
    public static TFGenCaveStalactite redstone = new TFGenCaveStalactite(aqw.aS.cF, 0.8f, 8, 1);
    public static TFGenCaveStalactite iron = new TFGenCaveStalactite(aqw.M.cF, 0.7f, 8, 1);
    public static TFGenCaveStalactite coal = new TFGenCaveStalactite(aqw.N.cF, 0.8f, 12, 1);
    public static TFGenCaveStalactite glowstone = new TFGenCaveStalactite(aqw.bi.cF, 0.5f, 8, 1);
    public int blockID;
    public boolean hang;
    public float sizeFactor;
    public int maxLength;
    public int minHeight;

    public TFGenCaveStalactite(int blockType, float size, boolean down) {
        this.blockID = blockType;
        this.sizeFactor = size;
        this.maxLength = -1;
        this.minHeight = -1;
        this.hang = down;
    }

    public TFGenCaveStalactite(int blockType, float size, int maxLength, int minHeight) {
        this.blockID = blockType;
        this.sizeFactor = size;
        this.maxLength = maxLength;
        this.minHeight = minHeight;
        this.hang = true;
    }

    public static TFGenCaveStalactite makeRandomOreStalactite(Random rand, int hillSize) {
        int s1;
        if (hillSize >= 3 || hillSize >= 2 && rand.nextInt(5) == 0) {
            int s3 = rand.nextInt(13);
            if (s3 == 0 || s3 == 1) {
                return diamond;
            }
            if (s3 == 2 || s3 == 3) {
                return lapis;
            }
            if (s3 == 4) {
                return emerald;
            }
        }
        if (hillSize >= 2 || hillSize >= 1 && rand.nextInt(5) == 0) {
            int s2 = rand.nextInt(6);
            if (s2 == 0) {
                return gold;
            }
            if (s2 == 1 || s2 == 2) {
                return redstone;
            }
        }
        if ((s1 = rand.nextInt(5)) == 0 || s1 == 1) {
            return iron;
        }
        if (s1 == 2 || s1 == 3) {
            return coal;
        }
        return glowstone;
    }

    @Override
    public boolean a(abv world, Random random, int x, int y, int z2) {
        ajz m;
        int ty;
        int ceiling = Integer.MAX_VALUE;
        int floor = -1;
        for (ty = y; ty < TFWorld.WORLDHEIGHT; ++ty) {
            m = world.g(x, ty, z2);
            if (m == ajz.a) continue;
            if (m != ajz.c && m != ajz.e) {
                return false;
            }
            ceiling = ty;
            break;
        }
        if (ceiling == Integer.MAX_VALUE) {
            return false;
        }
        for (ty = y; ty > 4; --ty) {
            m = world.g(x, ty, z2);
            if (m == ajz.a) continue;
            if (m != ajz.c && m != ajz.e && !this.hang && m != ajz.h && !this.hang && m != ajz.i) {
                return false;
            }
            floor = ty;
            break;
        }
        int length = (int)((float)(ceiling - floor) * this.sizeFactor * random.nextFloat());
        if (this.maxLength > -1 && length > this.maxLength) {
            length = this.maxLength;
        }
        if (this.minHeight > -1 && ceiling - floor - length < this.minHeight) {
            return false;
        }
        return this.makeSpike(world, random, x, this.hang ? ceiling : floor, z2, length);
    }

    public boolean makeSpike(abv world, Random random, int x, int y, int z2, int maxLength) {
        int diameter = (int)((double)maxLength / 4.5);
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz2 = -diameter; dz2 <= diameter; ++dz2) {
                int dir;
                int absx = Math.abs(dx);
                int absz = Math.abs(dz2);
                int dist = (int)((double)Math.max(absx, absz) + (double)Math.min(absx, absz) * 0.5);
                int spikeLength = 0;
                if (dist == 0) {
                    spikeLength = maxLength;
                }
                if (dist > 0) {
                    spikeLength = random.nextInt((int)((double)maxLength / ((double)dist + 0.25)));
                }
                int n = dir = this.hang ? -1 : 1;
                if (!world.g(x + dx, y - dir, z2 + dz2).a()) {
                    spikeLength = 0;
                }
                for (int dy = 0; dy != spikeLength * dir; dy += dir) {
                    this.putBlock(world, x + dx, y + dy, z2 + dz2, this.blockID, false);
                }
            }
        }
        return true;
    }
}

