/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IPlayerTracker;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import twilightforest.TFAchievementPage;
import twilightforest.TFEnchantment;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFCharmEffect;
import twilightforest.item.TFItems;

public class TFEventListener
implements ICraftingHandler,
IPlayerTracker {
    protected ArrayList<yd> suppressDrops = new ArrayList();
    protected HashMap<String, uc> playerKeepsMap = new HashMap();

    @ForgeSubscribe
    public void pickupItem(EntityItemPickupEvent event) {
        if (event.item.d().d == TFItems.scepterTwilight.cv || event.item.d().d == TFItems.scepterLifeDrain.cv || event.item.d().d == TFItems.scepterZombie.cv) {
            this.checkPlayerForScepterMastery(event.entityPlayer);
        }
    }

    private void checkPlayerForScepterMastery(ue player) {
        boolean scepterTwilight = false;
        boolean scepterLifeDrain = false;
        boolean scepterZombie = false;
        uc inv = player.bn;
        for (int i = 0; i < inv.j_(); ++i) {
            yd stack = inv.a(i);
            if (stack != null && stack.d == TFItems.scepterTwilight.cv) {
                scepterTwilight = true;
            }
            if (stack != null && stack.d == TFItems.scepterLifeDrain.cv) {
                scepterLifeDrain = true;
            }
            if (stack == null || stack.d != TFItems.scepterZombie.cv) continue;
            scepterZombie = true;
        }
        if (scepterTwilight && scepterLifeDrain && scepterZombie) {
            player.a((kt)TFAchievementPage.twilightLichScepters);
        }
    }

    public void onCrafting(ue player, yd itemStack, mn craftMatrix) {
        if (itemStack.d == TFItems.plateNaga.cv || itemStack.d == TFItems.legsNaga.cv) {
            this.checkPlayerForNagaArmorer(player);
        }
        if (itemStack.d == TFItems.magicMapFocus.cv) {
            player.a((kt)TFAchievementPage.twilightMagicMapFocus);
        }
        if (itemStack.d == TFItems.emptyMagicMap.cv) {
            player.a((kt)TFAchievementPage.twilightMagicMap);
        }
        if (itemStack.d == TFItems.emptyMazeMap.cv) {
            player.a((kt)TFAchievementPage.twilightMazeMap);
        }
        if (itemStack.d == TFItems.emptyOreMap.cv) {
            player.a((kt)TFAchievementPage.twilightOreMap);
        }
    }

    public void onSmelting(ue player, yd item) {
    }

    private void checkPlayerForNagaArmorer(ue player) {
        boolean nagaScale = false;
        boolean legsNaga = false;
        uc inv = player.bn;
        for (int i = 0; i < inv.j_(); ++i) {
            yd stack = inv.a(i);
            if (stack != null && stack.d == TFItems.nagaScale.cv) {
                nagaScale = true;
            }
            if (stack == null || stack.d != TFItems.legsNaga.cv) continue;
            legsNaga = true;
        }
        if (nagaScale && legsNaga) {
            player.a((kt)TFAchievementPage.twilightNagaArmors);
        }
    }

    @ForgeSubscribe
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof sr && !this.suppressDrops.isEmpty()) {
            sr entityItem = (sr)event.entity;
            yd suppressed = null;
            for (yd suppressItem : this.suppressDrops) {
                if (!suppressItem.a(entityItem.d())) continue;
                event.setCanceled(true);
                suppressed = suppressItem;
            }
            if (suppressed != null) {
                this.suppressDrops.remove(suppressed);
            }
        }
    }

    public void supressDrop(yd istack) {
        this.suppressDrops.add(istack);
        if (this.suppressDrops.size() > 1) {
            System.out.println("Supress list is growing..." + this.suppressDrops);
        }
    }

    @ForgeSubscribe
    public void entityHurts(LivingHurtEvent event) {
        ue player;
        if (event.entityLiving instanceof ue && event.source.o.equals("mob")) {
            player = (ue)event.entityLiving;
            int fireLevel = TFEnchantment.getReactFireLevel(player.bn, event.source);
            if (fireLevel > 0 && player.aC().nextInt(25) < fireLevel) {
                event.source.i().d(fireLevel / 2);
            }
        }
        if (event.entityLiving instanceof ue && this.willEntityDie(event)) {
            player = (ue)event.entityLiving;
            boolean charm1 = false;
            boolean charm2 = player.bn.d(TFItems.charmOfLife2.cv);
            if (!charm2) {
                charm1 = player.bn.d(TFItems.charmOfLife1.cv);
            }
            if (charm2 || charm1) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                event.ammount = 0.0f;
                if (charm1) {
                    player.g(8.0f);
                    player.c(new ni(nh.l.H, 100, 0));
                }
                if (charm2) {
                    player.g((float)player.a(to.a).e());
                    player.c(new ni(nh.l.H, 600, 3));
                    player.c(new ni(nh.m.H, 600, 0));
                    player.c(new ni(nh.n.H, 600, 0));
                }
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.q, (oe)player, charm1 ? TFItems.charmOfLife1.cv : TFItems.charmOfLife2.cv);
                player.q.d((nm)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.q, (oe)player, charm1 ? TFItems.charmOfLife1.cv : TFItems.charmOfLife2.cv);
                effect2.offset = (float)Math.PI;
                player.q.d((nm)effect2);
                player.q.a(player.u + 0.5, player.v + 0.5, player.w + 0.5, "mob.zombie.unfect", 1.5f, 1.0f);
            }
        }
    }

    public boolean willEntityDie(LivingHurtEvent event) {
        float amount = event.ammount;
        na source = event.source;
        oe living = event.entityLiving;
        if (!source.e()) {
            int armor = 25 - living.aP();
            amount = amount * (float)armor / 25.0f;
        }
        if (living.a(nh.m)) {
            int resistance = 25 - (living.b(nh.m).c() + 1) * 5;
            amount = amount * (float)resistance / 25.0f;
        }
        return Math.ceil(amount) >= (double)living.aM();
    }

    @ForgeSubscribe
    public void bonemealUsed(BonemealEvent event) {
        if (event.ID == TFBlocks.sapling.cF && !event.world.I) {
            ((aqf)TFBlocks.sapling).d(event.world, event.X, event.Y, event.Z, event.world.s);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @ForgeSubscribe
    public void livingDies(LivingDeathEvent event) {
        if (event.entityLiving instanceof ue && !event.entityLiving.q.O().b("keepInventory")) {
            int i;
            uc keepInventory;
            ue player = (ue)event.entityLiving;
            if (player.bn.d(TFItems.charmOfKeeping3.cv)) {
                FMLLog.info((String)"[TwilightForest] Player died with charm of keeping III!  Keep it all!", (Object[])new Object[0]);
                keepInventory = new uc(null);
                this.keepAllArmor(player, keepInventory);
                for (i = 0; i < player.bn.a.length; ++i) {
                    keepInventory.a[i] = player.bn.a[i];
                    player.bn.a[i] = null;
                }
                keepInventory.b(new yd(TFItems.charmOfKeeping3));
                this.playerKeepsMap.put(player.bu, keepInventory);
            } else if (player.bn.d(TFItems.charmOfKeeping2.cv)) {
                FMLLog.info((String)"[TwilightForest] Player died with charm of keeping II!  Keep armor and hotbar!", (Object[])new Object[0]);
                keepInventory = new uc(null);
                this.keepAllArmor(player, keepInventory);
                for (i = 0; i < 9; ++i) {
                    keepInventory.a[i] = player.bn.a[i];
                    player.bn.a[i] = null;
                }
                keepInventory.b(new yd(TFItems.charmOfKeeping2));
                this.playerKeepsMap.put(player.bu, keepInventory);
            } else if (player.bn.d(TFItems.charmOfKeeping1.cv)) {
                FMLLog.info((String)"[TwilightForest] Player died with charm of keeping I!  Keep armor and current item!", (Object[])new Object[0]);
                keepInventory = new uc(null);
                this.keepAllArmor(player, keepInventory);
                if (player.bn.h() != null) {
                    keepInventory.a[player.bn.c] = player.bn.a[player.bn.c];
                    player.bn.a[player.bn.c] = null;
                }
                keepInventory.b(new yd(TFItems.charmOfKeeping1));
                this.playerKeepsMap.put(player.bu, keepInventory);
            }
            if (player.bn.e(TFItems.towerKey.cv)) {
                keepInventory = this.retrieveOrMakeKeepInventory(player);
                for (i = 0; i < player.bn.a.length; ++i) {
                    if (player.bn.a[i] == null || player.bn.a[i].d != TFItems.towerKey.cv) continue;
                    keepInventory.a[i] = player.bn.a[i];
                    player.bn.a[i] = null;
                }
                this.playerKeepsMap.put(player.bu, keepInventory);
            }
        }
        if (this.playerKeepsMap.size() > 1) {
            FMLLog.warning((String)"[TwilightForest] Twilight Forest mod is keeping track of a lot of dead player inventories.  Has there been an apocalypse?", (Object[])new Object[0]);
        }
    }

    private uc retrieveOrMakeKeepInventory(ue player) {
        if (this.playerKeepsMap.containsKey(player.bu)) {
            return this.playerKeepsMap.get(player.bu);
        }
        return new uc(null);
    }

    private void keepAllArmor(ue player, uc keepInventory) {
        for (int i = 0; i < player.bn.b.length; ++i) {
            keepInventory.b[i] = player.bn.b[i];
            player.bn.b[i] = null;
        }
    }

    public void onPlayerRespawn(ue player) {
        if (this.playerKeepsMap.containsKey(player.bu)) {
            int i;
            FMLLog.info((String)"[TwilightForest] Player %s respawned and recieved items held in storage", (Object[])new Object[]{player.bu});
            uc keepInventory = this.playerKeepsMap.get(player.bu);
            for (i = 0; i < player.bn.b.length; ++i) {
                player.bn.b[i] = keepInventory.b[i];
            }
            for (i = 0; i < player.bn.a.length; ++i) {
                player.bn.a[i] = keepInventory.a[i];
            }
            if (keepInventory.o() != null) {
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.q, (oe)player, keepInventory.o().d);
                player.q.d((nm)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.q, (oe)player, keepInventory.o().d);
                effect2.offset = (float)Math.PI;
                player.q.d((nm)effect2);
                player.q.a(player.u + 0.5, player.v + 0.5, player.w + 0.5, "mob.zombie.unfect", 1.5f, 1.0f);
            }
            this.playerKeepsMap.remove(player.bu);
        }
    }

    public void onPlayerLogin(ue player) {
    }

    public void onPlayerLogout(ue player) {
        if (this.playerKeepsMap.containsKey(player.bu)) {
            FMLLog.warning((String)"[TwilightForest] Mod was keeping inventory items in reserve for player %s but they logged out!  Items are being dropped.", (Object[])new Object[]{player.bu});
            uc keepInventory = this.playerKeepsMap.get(player.bu);
            keepInventory.d = player;
            keepInventory.m();
            this.playerKeepsMap.remove(player.bu);
        }
    }

    public void onPlayerChangedDimension(ue player) {
    }
}

