/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.ASMDev;
import codechicken.core.asm.CodeChickenAccessTransformer;
import codechicken.core.asm.DelegatedTransformer;
import codechicken.core.asm.MCPDeobfuscationTransformer;
import codechicken.core.asm.ObfuscationMappings;
import codechicken.core.asm.TweakTransformer;
import codechicken.core.config.ConfigFile;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.RelaunchClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkListener;

@IFMLLoadingPlugin.TransformerExclusions(value={"codechicken.core.asm"})
public class CodeChickenCorePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static final String mcVersion = "[1.5.2]";
    public static RelaunchClassLoader cl;
    public static File minecraftDir;
    public static ConfigFile config;

    public String[] getLibraryRequestClass() {
        return null;
    }

    public static void versionCheck(String reqVersion, String mod) {
        String mcVersion = (String)FMLInjectionData.data()[4];
        if (!VersionParser.parseRange((String)reqVersion).containsVersion((ArtifactVersion)new DefaultArtifactVersion(mcVersion))) {
            String err = "This version of " + mod + " does not support minecraft version " + mcVersion;
            System.err.println(err);
            JEditorPane ep = new JEditorPane("text/html", "<html>" + err + "<br>Remove it from your coremods folder and check <a href=\"http://www.minecraftforum.net/topic/909223-\">here</a> for updates" + "</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener((HyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
            JOptionPane.showMessageDialog(null, ep, "Fatal error", 0);
            System.exit(1);
        }
    }

    public String[] getASMTransformerClass() {
        CodeChickenCorePlugin.versionCheck(mcVersion, "CodeChickenCore");
        return new String[]{"codechicken.core.asm.ClassHeirachyManager", "codechicken.core.asm.CodeChickenAccessTransformer", "codechicken.core.asm.InterfaceDependancyTransformer", "codechicken.core.asm.TweakTransformer", "codechicken.core.asm.FeatureHackTransformer", "codechicken.core.asm.DelegatedTransformer"};
    }

    public String getModContainerClass() {
        return "codechicken.core.asm.CodeChickenCoreModContainer";
    }

    public String getSetupClass() {
        return "codechicken.core.asm.CodeChickenCorePlugin";
    }

    public void injectData(Map data) {
        cl = (RelaunchClassLoader)data.get("classLoader");
        if (data.containsKey("mcLocation")) {
            minecraftDir = (File)data.get("mcLocation");
        }
    }

    public Void call() {
        File cfgDir = new File(minecraftDir + "/config");
        if (!cfgDir.exists()) {
            cfgDir.mkdirs();
        }
        config = new ConfigFile(new File(cfgDir, "CodeChickenCore.cfg")).setComment("CodeChickenCore configuration file.");
        MCPDeobfuscationTransformer.load((File)minecraftDir, (ConfigFile)config, (RelaunchClassLoader)cl);
        CodeChickenAccessTransformer.addTransformerMap((String)"codechickencore_at.cfg");
        TweakTransformer.load((ConfigFile)config);
        this.scanCodeChickenMods();
        if (!ObfuscationMappings.obfuscated) {
            ASMDev.print();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanCodeChickenMods() {
        File modsDir = new File(minecraftDir, "mods");
        if (!modsDir.exists()) {
            return;
        }
        for (File file : modsDir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */)) {
            try {
                JarFile jar = new JarFile(file);
                try {
                    String transformer;
                    Attributes attr;
                    Manifest manifest = jar.getManifest();
                    if (manifest == null || (attr = manifest.getMainAttributes()) == null) continue;
                    String mapFile = attr.getValue("AccessTransformer");
                    if (mapFile != null && ObfuscationMappings.obfuscated) {
                        File temp = this.extractTemp(jar, mapFile);
                        System.out.println("Adding AccessTransformer: " + mapFile);
                        CodeChickenAccessTransformer.addTransformerMap((String)temp.getPath());
                        temp.delete();
                    }
                    if ((transformer = attr.getValue("CCTransformer")) == null) continue;
                    System.out.println("Adding CCTransformer: " + transformer);
                    DelegatedTransformer.addTransformer((String)transformer, (JarFile)jar, (File)file);
                }
                finally {
                    jar.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("CodeChickenCore: Failed to read jar file: " + file.getName());
            }
        }
    }

    private File extractTemp(JarFile jar, String mapFile) throws IOException {
        File temp = new File("temp.dat");
        if (!temp.exists()) {
            temp.createNewFile();
        }
        FileOutputStream fout = new FileOutputStream(temp);
        byte[] data = new byte[4096];
        int read = 0;
        InputStream fin = jar.getInputStream(jar.getEntry(mapFile));
        while ((read = fin.read(data)) > 0) {
            fout.write(data, 0, read);
        }
        fin.close();
        fout.close();
        return temp;
    }
}

