/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.cui.CUIRegion;
import com.sk89q.worldedit.cui.SelectionMinMaxEvent;
import com.sk89q.worldedit.cui.SelectionPoint2DEvent;
import com.sk89q.worldedit.cui.SelectionShapeEvent;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.CylinderRegionSelector;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Polygonal2DRegionSelector
implements RegionSelector,
CUIRegion {
    private int maxPoints;
    private BlockVector pos1;
    private Polygonal2DRegion region;

    @Deprecated
    public Polygonal2DRegionSelector(LocalWorld world) {
        this(world, 50);
    }

    public Polygonal2DRegionSelector(LocalWorld world, int maxPoints) {
        this.maxPoints = maxPoints;
        this.region = new Polygonal2DRegion(world);
    }

    @Deprecated
    public Polygonal2DRegionSelector(RegionSelector oldSelector) {
        this(oldSelector, 50);
    }

    public Polygonal2DRegionSelector(RegionSelector oldSelector, int maxPoints) {
        this(oldSelector.getIncompleteRegion().getWorld(), maxPoints);
        if (oldSelector instanceof Polygonal2DRegionSelector) {
            Polygonal2DRegionSelector polygonal2DRegionSelector = (Polygonal2DRegionSelector)oldSelector;
            this.pos1 = polygonal2DRegionSelector.pos1;
            this.region = new Polygonal2DRegion(polygonal2DRegionSelector.region);
        } else if (oldSelector instanceof CylinderRegionSelector) {
            CylinderRegionSelector cylinderRegionSelector = (CylinderRegionSelector)oldSelector;
            CylinderRegion oldRegion = cylinderRegionSelector.region;
            Vector2D radius = oldRegion.getRadius();
            Vector2D center = oldRegion.getCenter().toVector2D();
            int nPoints = (int)Math.ceil(Math.PI * radius.length());
            if (maxPoints > -1 && nPoints >= maxPoints) {
                nPoints = maxPoints - 1;
            }
            ArrayList<BlockVector2D> points = new ArrayList<BlockVector2D>(nPoints);
            for (int i = 0; i < nPoints; ++i) {
                double angle = (double)i * (Math.PI * 2) / (double)nPoints;
                Vector2D pos = new Vector2D(Math.cos(angle), Math.sin(angle));
                BlockVector2D blockVector2D = pos.multiply(radius).add(center).toBlockVector2D();
                points.add(blockVector2D);
            }
            int minY = oldRegion.getMinimumY();
            this.pos1 = ((BlockVector2D)points.get(0)).toVector(minY).toBlockVector();
            this.region = new Polygonal2DRegion(oldRegion.getWorld(), points, minY, oldRegion.getMaximumY());
        } else {
            Region oldRegion;
            try {
                oldRegion = oldSelector.getRegion();
            }
            catch (IncompleteRegionException e) {
                return;
            }
            BlockVector min = oldRegion.getMinimumPoint().toBlockVector();
            BlockVector max = oldRegion.getMaximumPoint().toBlockVector();
            int minY = min.getBlockY();
            int maxY = max.getBlockY();
            ArrayList<BlockVector2D> points = new ArrayList<BlockVector2D>(4);
            points.add(new BlockVector2D(min.getX(), min.getZ()));
            points.add(new BlockVector2D(min.getX(), max.getZ()));
            points.add(new BlockVector2D(max.getX(), max.getZ()));
            points.add(new BlockVector2D(max.getX(), min.getZ()));
            this.pos1 = min;
            this.region = new Polygonal2DRegion(oldRegion.getWorld(), points, minY, maxY);
        }
    }

    public Polygonal2DRegionSelector(LocalWorld world, List<BlockVector2D> points, int minY, int maxY) {
        BlockVector2D pos2D = points.get(0);
        this.pos1 = new BlockVector(pos2D.getX(), (double)minY, pos2D.getZ());
        this.region = new Polygonal2DRegion(world, points, minY, maxY);
    }

    @Override
    public boolean selectPrimary(Vector pos) {
        if (pos.equals(this.pos1)) {
            return false;
        }
        this.pos1 = pos.toBlockVector();
        this.region = new Polygonal2DRegion(this.region.getWorld());
        this.region.addPoint(pos);
        this.region.expandY(pos.getBlockY());
        return true;
    }

    @Override
    public boolean selectSecondary(Vector pos) {
        if (this.region.size() > 0) {
            List<BlockVector2D> points = this.region.getPoints();
            BlockVector2D lastPoint = points.get(this.region.size() - 1);
            if (lastPoint.getBlockX() == pos.getBlockX() && lastPoint.getBlockZ() == pos.getBlockZ()) {
                return false;
            }
            if (this.maxPoints > -1 && points.size() >= this.maxPoints) {
                return false;
            }
        }
        this.region.addPoint(pos);
        this.region.expandY(pos.getBlockY());
        return true;
    }

    @Override
    public void explainPrimarySelection(LocalPlayer player, LocalSession session, Vector pos) {
        player.print("Starting a new polygon at " + pos + ".");
        session.dispatchCUIEvent(player, new SelectionShapeEvent(this.getTypeID()));
        session.dispatchCUIEvent(player, new SelectionPoint2DEvent(0, pos, this.getArea()));
        session.dispatchCUIEvent(player, new SelectionMinMaxEvent(this.region.getMinimumY(), this.region.getMaximumY()));
    }

    @Override
    public void explainSecondarySelection(LocalPlayer player, LocalSession session, Vector pos) {
        player.print("Added point #" + this.region.size() + " at " + pos + ".");
        session.dispatchCUIEvent(player, new SelectionPoint2DEvent(this.region.size() - 1, pos, this.getArea()));
        session.dispatchCUIEvent(player, new SelectionMinMaxEvent(this.region.getMinimumY(), this.region.getMaximumY()));
    }

    @Override
    public void explainRegionAdjust(LocalPlayer player, LocalSession session) {
        session.dispatchCUIEvent(player, new SelectionShapeEvent(this.getTypeID()));
        this.describeCUI(session, player);
    }

    @Override
    public BlockVector getPrimaryPosition() throws IncompleteRegionException {
        if (this.pos1 == null) {
            throw new IncompleteRegionException();
        }
        return this.pos1;
    }

    @Override
    public Polygonal2DRegion getRegion() throws IncompleteRegionException {
        if (!this.isDefined()) {
            throw new IncompleteRegionException();
        }
        return this.region;
    }

    @Override
    public Polygonal2DRegion getIncompleteRegion() {
        return this.region;
    }

    @Override
    public boolean isDefined() {
        return this.region.size() > 2;
    }

    @Override
    public void learnChanges() {
        BlockVector2D pt = this.region.getPoints().get(0);
        this.pos1 = new BlockVector(pt.getBlockX(), this.region.getMinimumPoint().getBlockY(), pt.getBlockZ());
    }

    @Override
    public void clear() {
        this.pos1 = null;
        this.region = new Polygonal2DRegion(this.region.getWorld());
    }

    @Override
    public String getTypeName() {
        return "2Dx1D polygon";
    }

    @Override
    public List<String> getInformationLines() {
        return Collections.singletonList("# points: " + this.region.size());
    }

    @Override
    public int getArea() {
        return this.region.getArea();
    }

    public int getPointCount() {
        return this.region.getPoints().size();
    }

    @Override
    public void describeCUI(LocalSession session, LocalPlayer player) {
        List<BlockVector2D> points = this.region.getPoints();
        for (int id = 0; id < points.size(); ++id) {
            session.dispatchCUIEvent(player, new SelectionPoint2DEvent(id, points.get(id), this.getArea()));
        }
        session.dispatchCUIEvent(player, new SelectionMinMaxEvent(this.region.getMinimumY(), this.region.getMaximumY()));
    }

    @Override
    public void describeLegacyCUI(LocalSession session, LocalPlayer player) {
        this.describeCUI(session, player);
    }

    @Override
    public int getProtocolVersion() {
        return 0;
    }

    @Override
    public String getTypeID() {
        return "polygon2d";
    }

    @Override
    public String getLegacyTypeID() {
        return "polygon2d";
    }
}

