package Kabo.ShowMonsters.common;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;

public class ShowMonstersPacketHandler implements IPacketHandler {

	@Override
	public void onPacketData(INetworkManager manager,
			Packet250CustomPayload packet, Player player) 
	{
		if(packet.channel.equals("KaboShowMonTN"))
		{
//			FMLLog.info("Packet Event on Channel KaboShowMonTN");
			if(!ShowMonsters.proxy.isClient())
			{
				handleShowMonstersToggle(packet, (EntityPlayerMP)player);
			}
		}
		else if(packet.channel.equals("KaboShowMonTC"))
		{
//			FMLLog.info("Packet Event on Channel KaboShowMonTC");
			if(!ShowMonsters.proxy.isClient())
			{
				handleShowMonstersToggleType(packet, (EntityPlayerMP)player);
			}
		}
		else if(packet.channel.equals("KaboShowMonMD"))
		{
//			FMLLog.info("Packet Event on Channel KaboShowMonMD");
			if(ShowMonsters.proxy.isClient())
			{
				handleShowMonstersData(packet);
			}
		}

	}

	private void handleShowMonstersToggle(Packet250CustomPayload packet, EntityPlayerMP player)
	{
		DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.data));
		try
		{
			Boolean active = inputStream.readBoolean();
			ShowMonsters.proxy.updatePlayerActive(player, active);
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}
	
	private void handleShowMonstersToggleType(Packet250CustomPayload packet, EntityPlayerMP player)
	{
		DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.data));
		try
		{
			int animals = inputStream.readInt();
			ShowMonsters.proxy.updatePlayerCreatures(player, animals);
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}
	
	private void handleShowMonstersData(Packet250CustomPayload packet)
	{
		DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.data));
		try
		{
			String MonsterData = "";
			for(int i = 0; i < (packet.length)/2; i++)
			{
				MonsterData += inputStream.readChar();
			}
//			FMLLog.info("Result: " + MonsterData);
			ShowMonsters.proxy.updateMonsterData(MonsterData);
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}

}
