package Kabo.ShowMonsters.common;

import java.util.EnumSet;

import net.minecraft.client.settings.KeyBinding;

import org.lwjgl.input.Keyboard;

import cpw.mods.fml.client.registry.KeyBindingRegistry.KeyHandler;
import cpw.mods.fml.common.TickType;

public class ShowMonstersKeyHandler extends KeyHandler 
{
	public static KeyBinding toggleShowMonsters = new KeyBinding("toggleShowMonsters", Keyboard.KEY_F4);
	public static KeyBinding toggleMobType = new KeyBinding("toggleMobType", Keyboard.KEY_RBRACKET);
	private ShowMonstersClientProxy client;

	public ShowMonstersKeyHandler(ShowMonstersClientProxy client) 
	{
		super(new KeyBinding[]{toggleShowMonsters,toggleMobType}, new boolean[]{false,false});
		this.client = client;
	}

	@Override
	public String getLabel() 
	{
		return "ShowMonstersKeybindings";
	}

	@Override
	public void keyDown(EnumSet<TickType> types, KeyBinding kb,
			boolean tickEnd, boolean isRepeat) 
	{
		if(kb == toggleShowMonsters)
		{
			this.client.toggleActiveState();
			//FMLLog.info("Client Toggle Mod");
		}
		else if(kb == toggleMobType)
		{
			if(this.client.isActive())
			{
				this.client.toggleCreatureState();
			}
			//FMLLog.info("Client Toggle Creature Hostility");
			//SwitchDisplayToPeacefulMobs
		}
	}

	@Override
	public void keyUp(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd) 
	{
		// Nothing Here
	}

	@Override
	public EnumSet<TickType> ticks() 
	{
		return EnumSet.of(TickType.CLIENT);
	}

}
