package Kabo.ShowMonsters.common;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.SpawnListEntry;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;

public class ShowMonstersCommonProxy {
	
	private HashMap playerModActiveState = new HashMap();
	private HashMap playerModCreatureState = new HashMap();
	private HashMap playerXs = new HashMap();
	private HashMap playerYs = new HashMap();
	private HashMap playerZs = new HashMap();
	private static HashMap mobIDToCheckMapping = new HashMap();
	private static HashMap mobCheckMapping = new HashMap();
	
	private long lastSendTime = System.currentTimeMillis();

	public void clientBindHotkeys() 
	{
		// Client-side Only		
	}

	// This is not the client
	protected Boolean isClient = false;
	protected String creatureData; 	
		
	/**
	 * Update the player's mod status to the value of Boolean active
	 */
	public void updatePlayerActive(EntityPlayerMP player, Boolean active)
	{
		// Update the player list according to the packet
		playerModActiveState.put(player, active);
		
		// Check if the player has toggled the creature type and init. the value
		if(!playerModCreatureState.containsKey(player))
		{
			playerModCreatureState.put(player,0);
		}
		
		// Remove player's location if mod deactivated
		if(!active)
		{
			playerXs.remove(player);
			playerYs.remove(player);
			playerZs.remove(player);
		}
	}
	
	/**
	 * Update the the type of creature data to get and send to the player based on
	 * the value of Boolean animals
	 */
	public void updatePlayerCreatures(EntityPlayerMP player, int animals)
	{
		// Update the player mod state list according to the packet
		playerModCreatureState.put(player, animals);
		
		// Remove player's location on state change to force refresh
		playerXs.remove(player);
		playerYs.remove(player);
		playerZs.remove(player);
	}

	public void updateMonsterData(String monsterData) 
	{
		// Client-side Only		
	}
	
	public void answerAsk()
	{
		// Client-side only	
	}
	
	/**
	 * @return false for server
	 */
	public boolean isClient() 
	{
		return false;
	}
	
	/**
	 * Update the stored player positions and call sendPlayerMobData if they have changed position
	 * @param tickTime 
	 */
	public void onTickUpdatePositionsAndSendData(long tickTime)
	{
		if(tickTime - lastSendTime < ShowMonsters.configServerTickTime) return;
		lastSendTime = tickTime;
		
		HashMap ActivePlayerList = new HashMap();
		ActivePlayerList.putAll(playerModActiveState);
		
		Iterator playerIter = ActivePlayerList.keySet().iterator();
		
		// Iterate through all the players who have toggled the mod at some point
		while(playerIter.hasNext())
		{
			EntityPlayerMP player = (EntityPlayerMP)playerIter.next();
//			FMLLog.info("Ticking on Server");
			
			if(player.playerNetServerHandler.connectionClosed)
			{
				playerModActiveState.remove(player);
				playerModCreatureState.remove(player);
				playerXs.remove(player);
				playerYs.remove(player);
				playerZs.remove(player);
//				FMLLog.info("Player Signed Off");
				continue;
			}
			
			// If the player has the mod active AND passes Creative check
			if((Boolean) playerModActiveState.get(player) && (ShowMonsters.configCreativeOnly?(player.theItemInWorldManager.getGameType().getID()==EnumGameType.CREATIVE.getID()):true))
			{
				// Get the player's position
				int x = MathHelper.floor_double(player.posX);
				int y = MathHelper.floor_double(player.posY);
				int z = MathHelper.floor_double(player.posZ);
								
				int x2;
				int y2;
				int z2;
				Integer t;
				
//				FMLLog.info("Checking Player " + player.username + " Positions");
				
				// Update player's position
				t = (Integer) playerXs.put(player, x);
				if(t == null){x2 = x+1;}
				else{x2 = t.intValue();}
				
				t = (Integer) playerYs.put(player, y);
				if(t == null){y2 = y+1;}
				else{y2 = t.intValue();}
				
				t = (Integer) playerZs.put(player, z);
				if(t == null){z2 = z+1;}
				else{z2 = t.intValue();}
				
				// If the player's position has changed
				if(!(x2==x && y2==y && z2==z))
				{
//					FMLLog.info("Player " + player.username + " Position Changed");
					// Generate and Send the MobData packet
					sendMobDataPacket(player,generateMobData(player,x,y,z));
				}			
			}
//			else
//			{
//				FMLLog.info("Mod not Active for any Player");
//			}
		}
	}
	
	/**
	 * Prepares output and sends the packet to the player
	 */
	private void sendMobDataPacket(EntityPlayerMP player, String mobData) 
	{
//		FMLLog.info("PacketToPlayer " + player.username + ":" + mobData);
		
		if(mobData.isEmpty())
		{
			// If we want to send a packet from mobData but it contains no data...
			mobData = "None,0,0";
		}
		
		ByteArrayOutputStream bos = new ByteArrayOutputStream(4);
		DataOutputStream outputStream = new DataOutputStream(bos);
		try
		{
			outputStream.writeChars(mobData);
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "KaboShowMonMD";
		packet.data = bos.toByteArray();
		packet.length = bos.size();
		
		PacketDispatcher.sendPacketToPlayer(packet, (Player)player);
	}

	/**
	 * Generates mob data based on the player's foot position
	 * @return string of mob data
	 */
	private String generateMobData(EntityPlayerMP player, int x, int y, int z)
	{
		MinecraftServer theServer = MinecraftServer.getServer();
		WorldServer	theWorld;
		String dataString = "";
		
		// Make sure the server is instantiated
		if(theServer!=null)
		{
			theWorld = theServer.worldServerForDimension(player.dimension);
			List spawnList = new ArrayList();			
			
			// Get the creature lists depending on player's creature type state for the mod
			int animals = ((Integer)playerModCreatureState.get(player)).intValue();
			switch(animals)
			{
			case 0:
				spawnList.addAll(theWorld.getChunkProvider().getPossibleCreatures(EnumCreatureType.monster, x, y-1, z));break;
			case 3:
				spawnList.addAll(theWorld.getChunkProvider().getPossibleCreatures(EnumCreatureType.creature, x, y-1, z));break;
			case 6:
				spawnList.addAll(theWorld.getChunkProvider().getPossibleCreatures(EnumCreatureType.waterCreature, x, y-1, z));break;
			case 9:
				spawnList.addAll(theWorld.getChunkProvider().getPossibleCreatures(EnumCreatureType.ambient, x, y-1, z));break;
			default:
				spawnList.addAll(theWorld.getChunkProvider().getPossibleCreatures(EnumCreatureType.monster, x, y-1, z));
			}
			
			// If the list has some values, try to get the necessary information by creating a mob instance and checking against it
			if( !spawnList.equals(null) && !spawnList.isEmpty())
			{
				for(int i = 0; i < spawnList.size(); i++)
				{
					try
                    {
						SpawnListEntry entry = (SpawnListEntry)spawnList.get(i);
                        EntityLiving mob = (EntityLiving)entry.entityClass.getConstructor(new Class[] {World.class}).newInstance(new Object[] {theWorld});
                        String name = EntityList.getEntityString(mob).length()<11?EntityList.getEntityString(mob):EntityList.getEntityString(mob).substring(0, 10);
                        int weight = entry.itemWeight;
                        int mobID = EntityList.getEntityID(mob);
                        
                        int canSpawn = evaluateSpawnLocationForMob(mob, x, y, z, player, (World)theWorld);
                        
                        // Special case for Wither Skeleton; rename as "WSkeleton"
                        if(player.dimension == -1 && name.equals("Skeleton")){name = "WSkeleton";}
                        // Special case in slime chunks; rename as "Slime!"
                        if(theWorld.getChunkFromBlockCoords(x, z).getRandomWithSeed(987234911L).nextInt(10) == 0 && name == "Slime"){name = "Slime!";}
                        
                        dataString += name + "," + weight + "," + canSpawn + ";";
                    }
                    catch (Exception e)
                    {
                        e.printStackTrace();
                    }
				}
			}
				
		}
		
		return dataString;
	}
	
	/**
	 * Evaluates spawning based on a set of rules
	 */
	private int evaluateSpawnLocationForMob(EntityLiving mob, int x, int y, int z, EntityPlayerMP player, World theWorld)
	{
		int mobID = EntityList.getEntityID(mob);
		mob.setLocationAndAngles((double)x + 0.5, (double)y, (double)z + 0.5, 0, 0.0F);
		
        //Resize Slimes
        if(mob instanceof EntitySlime){mob.boundingBox.setBounds(mob.posX - (double)(0.3), mob.posY - (double)mob.yOffset + (double)mob.ySize, mob.posZ - (double)(0.3), mob.posX + (double)(0.3), mob.posY - (double)mob.yOffset + (double)mob.ySize + (double)(0.6), mob.posZ + (double)(0.3));}

		mob.setDead();
		
		// Check to see if there's a mapping for the mobID
		if(mobIDToCheckMapping.containsKey(mobID))
		{
			// If there is, check to see if there's a custom check class registered
			// This is for non-vanilla mobs that have been added and have special spawning conditions
			// or for overriding the checking methods
			// The mobID is the ID used in EntityList
			String checkType = (String)mobIDToCheckMapping.get(mobID);
			if(mobCheckMapping.containsKey(checkType))
			{
				// See if the class implements IShowMonstersCheck
				try
				{
					Class checkingClass = Class.forName((String)mobCheckMapping.get(checkType));
					Object checkingObject = checkingClass.newInstance();
					IShowMonstersCheck check;
					if(checkingObject instanceof IShowMonstersCheck)
					{
						//If it does run the check and return a value
						int result = 1;
						check = (IShowMonstersCheck)checkingObject;
						switch(check.getMethodToUse())
						{
							case 0: result = check.performCheckAtPosition(theWorld, x, y, z);
							case 1: result = check.performCheckAtPositionWithPlayer(player, theWorld, x, y, z);
						}
						
						//If the check does not fail and we need to check the bounding box in the proxy 
						if(result != 0 && check.shouldCheckBB())
						{
							if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
						}
						else
						{
							return result;
						}
					}
					else
					{
						//Otherwise, we aren't sure if the mob can spawn
						return 2;
					}
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
			}
			// If a class isn't registered; either this is a vanilla mob, or it follows one of the vanilla spawning requirements.
			// or the mobID is not registered for a check
			else
			{
				// Overworld Monsters
				if(((String)mobIDToCheckMapping.get(mobID)).equals("overworld"))
				{
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					
					int blockLight = theWorld.getBlockLightValue(x, y, z);

		            if(theWorld.isThundering())
		            {
		                int slSubtracted = theWorld.skylightSubtracted;
		                theWorld.skylightSubtracted = 10;
		                blockLight = theWorld.getBlockLightValue(x, y, z);
		                theWorld.skylightSubtracted = slSubtracted;
		            }
		            
		            return blockLight <= 7?1:0;
				}
				// Slimes
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("slime"))
				{
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					
					if(!((theWorld.getBiomeGenForCoords(x, z) == BiomeGenBase.swampland && y > 50.0D && y < 70.0D && theWorld.getBlockLightValue(x, y, z) <= 7) || (theWorld.getChunkFromBlockCoords(x, z).getRandomWithSeed(987234911L).nextInt(10) == 0 && y < 40.0D)))
	                {
	                    return 0;
	                }
					return 1;
					
				}
				// Nether Monsters
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("nether"))
				{
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					
					return 1;
				}
				// Ocelots
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("ocelot"))
				{
	                int bID = theWorld.getBlockId(x, y - 1, z);
	                
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					
					if (y < 63)
	                {
	                    return 0;
	                }

	                if(!(bID == Block.grass.blockID || bID == Block.leaves.blockID))
	                {
	                    return 0;
	                }
	                
	                return 1;				
				}
				// Animals
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("peaceful"))
				{
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					
					if(!(theWorld.getBlockId(x, y-1, z)==Block.grass.blockID))
					{
						return 0;
					}
					
					return theWorld.getFullBlockLightValue(x, y, z)>8?1:0;
				}
				// Squid
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("squid"))
				{
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;
					}
					if(!(theWorld.getBlockMaterial(x, y, z).isLiquid() && theWorld.getBlockMaterial(x, y-1, z).isLiquid() && !theWorld.isBlockNormalCube(x, y + 1, z)))
					{
						return 0;
					}
					return (y > 45.0D && y < 63.0D)?1:0;
				}
				// Bats
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("bat"))
				{
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					if(theWorld.getBlockLightValue(x, y, z) > 3){return 0;}
					
					return 1;
				}
			}
		}
		return 2;
	}
	
	/**
	 * Checks the bounding box of the entity for blocks with collision
	 */
	public List getCollidingBoundingBoxes(World theWorld, Entity theEntity, AxisAlignedBB boundingBox)
    {
		ArrayList collidingBoundingBoxes = new ArrayList();
        collidingBoundingBoxes.clear();
        int minX = MathHelper.floor_double(boundingBox.minX);
        int maxX = MathHelper.floor_double(boundingBox.maxX + 1.0D);
        int minY = MathHelper.floor_double(boundingBox.minY);
        int maxY = MathHelper.floor_double(boundingBox.maxY + 1.0D);
        int minZ = MathHelper.floor_double(boundingBox.minZ);
        int maxZ = MathHelper.floor_double(boundingBox.maxZ + 1.0D);
        for (int blockX = minX; blockX < maxX; ++blockX)
        {
            for (int blockZ = minZ; blockZ < maxZ; ++blockZ)
            {
                if (theWorld.blockExists(blockX, 64, blockZ))
                {
                    for (int blockY = minY - 1; blockY < maxY; ++blockY)
                    {
                        Block eachBlock = Block.blocksList[theWorld.getBlockId(blockX, blockY, blockZ)];
                        if (eachBlock != null)
                        {
                            eachBlock.addCollisionBoxesToList(theWorld, blockX, blockY, blockZ, boundingBox, collidingBoundingBoxes, theEntity);
                        }
                    }
                }
            }
        }
        return collidingBoundingBoxes;
    }
	
	/**
	 * Check the block below x,y,z to see if it is a normal cube that is not bedrock or a top-slab/upside-down stair
	 */
	private boolean blockBelowCheck(World theWorld, int x, int y, int z)
	{
		if(!(theWorld.getBlockId(x, y-1, z)!=Block.bedrock.blockID && (theWorld.isBlockNormalCube(x, y-1, z) || theWorld.doesBlockHaveSolidTopSurface(x, y-1, z))))
        {
        	return true;
		}
		return false;
	}
	
	/**
	 * Check if the block is is liquid
	 */
	private boolean liquidInBlockCheck(World theWorld, int x, int y, int z)
	{
		if(theWorld.getBlockMaterial(x, y, z).isLiquid())
		{
			return true;
		}
		return false;
	}
	
	/**
	 * Check the block above x,y,z to make sure it is not a normal cube
	 */
	private boolean blockAboveCheck(World theWorld, int x, int y, int z)
	{
		if(theWorld.isBlockNormalCube(x,y+1,z)){return true;}
		return false;
	}
	
	/**
	 * Add mapping For performing mob checks; use to add a mapping for one of the already defined check types
	 *<br>Make sure to call for Kabo.ShowMonsters.common.ClientProxy as well.
	 */
	public static void addMobCheckMapping(int mobID, String checkType)
	{
		mobIDToCheckMapping.put(mobID,checkType);
	}
	
	/**
	 * Add mapping for performing mob checks; 
	 * <br>Use this to add a custom check type; use the path to your class
	 * <br>The class should use the ShowMonstersCheck interface;
	 * <br>Make sure to call for Kabo.ShowMonsters.common.ClientProxy as well.
	 * @see IShowMonstersCheck ShowMonstersCheck for how to use it.
	 */
	public static void addMobCheckMapping(int mobID, String checkType, String classPath)
	{
		mobIDToCheckMapping.put(mobID,checkType);
		mobCheckMapping.put(checkType,classPath);
	}
	
	// Default registration for mobIDs
	static
	{
		//Generic Mob and Monster Entities
		addMobCheckMapping(48,"unknown");
		addMobCheckMapping(49,"unknown");
		
		//WitherBoss, EnderDragon, SilverFish, Giant
		addMobCheckMapping(64,"unknown");
		addMobCheckMapping(63,"unknown");
		addMobCheckMapping(60,"unknown");
		addMobCheckMapping(53,"unknown");
		
		//Creeper, Skeleton, Zombie, Enderman, Spider, CaveSpider, Witch
		addMobCheckMapping(50,"overworld");
		addMobCheckMapping(51,"overworld");
		addMobCheckMapping(54,"overworld");
		addMobCheckMapping(58,"overworld");
		addMobCheckMapping(52,"overworld");
		addMobCheckMapping(59,"overworld");
		addMobCheckMapping(66,"overworld");		
		
		//Slime
		addMobCheckMapping(55,"slime");
		
		//PigZombie, Blaze, Ghast, LavaSlime
		addMobCheckMapping(57,"nether");
		addMobCheckMapping(61,"nether");
		addMobCheckMapping(56,"nether");
		addMobCheckMapping(62,"nether");
		
		//Ocelot
		addMobCheckMapping(98,"ocelot");
		
		//Pig, Sheep, Cow, Chicken, Wolves, Mooshrooms, Horses
		addMobCheckMapping(90,"peaceful");
		addMobCheckMapping(91,"peaceful");
		addMobCheckMapping(92,"peaceful");
		addMobCheckMapping(93,"peaceful");
		addMobCheckMapping(95,"peaceful");
		addMobCheckMapping(96,"peaceful");
		addMobCheckMapping(100,"peaceful");
		
		//Squid
		addMobCheckMapping(94,"squid");
		
		//Bat
		addMobCheckMapping(65,"bat");
		
	}

}
