package Kabo.ShowMonsters.common;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.lwjgl.opengl.GL11;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.SpawnListEntry;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;

public class ShowMonstersClientProxy extends ShowMonstersCommonProxy 
{
	private boolean active = false;
	private int animals = 0;
	protected String creatureData = "";
	
	private static HashMap mobIDToCheckMapping = new HashMap();
	private static HashMap mobCheckMapping = new HashMap();
	private static boolean areKeysBound = false;
	
	/**
	 * Binds hotkeys to client
	 */
	public void clientBindHotkeys()
	{
		if(!areKeysBound)
		{
			ShowMonstersKeyHandler keyHandler = new ShowMonstersKeyHandler(this);
			KeyBindingRegistry.registerKeyBinding(keyHandler);
			TickRegistry.registerTickHandler(keyHandler, Side.CLIENT);
			areKeysBound = true;
		}
	}
	
	@Override
	public boolean isClient()
	{
		return true;
	}
	
	@Override
	public void updatePlayerActive(EntityPlayerMP player, Boolean active)
	{
		// Not used by Client
	}
	
	@Override
	public void updatePlayerCreatures(EntityPlayerMP player, int animals)
	{
		// Not used by Client
	}
	
	/**
	 * Updates MonsterData with the given String
	 */
	@Override
	public void updateMonsterData(String MonsterData)
	{
		this.creatureData = MonsterData;
	}
	
	@Override
	public void onTickUpdatePositionsAndSendData(long tickTime)
	{
		// Not used by Client
	}

	/**
	 * Toggles the mod display on or off and sends a packet to the server notifying it of the mod status
	 */
	public void toggleActiveState() 
	{
		active = (active?false:true);
		
		sendActiveStatusPacket();
		
		if(!active)
		{
			this.creatureData = "";
		}
	}
	
	public void sendActiveStatusPacket()
	{
		EntityClientPlayerMP player = (EntityClientPlayerMP)Minecraft.getMinecraft().thePlayer;
		ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
		DataOutputStream outputStream = new DataOutputStream(bos);
		try
		{
			outputStream.writeBoolean(active);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "KaboShowMonTN";
		packet.data = bos.toByteArray();
		packet.length = bos.size();
		player.sendQueue.addToSendQueue(packet);
		
//		FMLLog.info("Client Send Packet: Mod Status Changed");
	}
	
	/**
	 * @return if the mod is active on the client
	 */
	public boolean isActive()
	{
		return active;
	}
	
	
	/**
	 * Toggles the type of creature to look for peaceful/hostile and send a packet informing the server
	 */
	public void toggleCreatureState()
	{
		animals = animals >= 11?0:animals + 1;
		sendCreatureStatusPacket();
	}
	
	public void sendCreatureStatusPacket()
	{
		EntityClientPlayerMP player = (EntityClientPlayerMP)Minecraft.getMinecraft().thePlayer;
		ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
		DataOutputStream outputStream = new DataOutputStream(bos);
		try
		{
			outputStream.writeInt(animals);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "KaboShowMonTC";
		packet.data = bos.toByteArray();
		packet.length = bos.size();
		player.sendQueue.addToSendQueue(packet);
		
//		FMLLog.info("Client Send Packet: Creature Status Changed");
	}
	
	@ForgeSubscribe
	public void renderWorldLastEvent(RenderWorldLastEvent event)
	{
		Minecraft mc = Minecraft.getMinecraft();
		
		// If the mod is on ...
		if(this.active)
		{
			if(mc.isSingleplayer() && mc.getIntegratedServer() != null)
			{
				// Generate creature data client-side if singleplayer
				creatureData = generateMobDataSinglePlayer(mc.thePlayer, mc.getIntegratedServer().worldServerForDimension(mc.thePlayer.dimension));
				if(creatureData.isEmpty())
				{
					creatureData = "None,0,0";
				}
			}
			// Format and render the creature data
			renderCreatureData(formatMobData(creatureData));
		}
		
		//DEBUG
		
//		mc.entityRenderer.setupOverlayRendering();
//		if(this.active)
//		{
//			mc.fontRenderer.drawStringWithShadow("Active", 2, 184, 14737632);
//			int x = this.animals? mc.fontRenderer.drawStringWithShadow("Animals", 2, 200, 14737632) : mc.fontRenderer.drawStringWithShadow("Monsters", 2, 200, 14737632);
//		}
//		else
//		{
//			 mc.fontRenderer.drawStringWithShadow("Inactive", 2, 184, 14737632);
//		}
	}	
	
	/**
	 * Generates mob data on client side when single player; same as server side 
	 */
	private String generateMobDataSinglePlayer(EntityClientPlayerMP player, WorldServer theWorld)
	{
		int x = MathHelper.floor_double(player.posX);
		int y = MathHelper.floor_double(player.posY);
		int z = MathHelper.floor_double(player.posZ);
		String dataString = "";
		
		List spawnList = new ArrayList();
		
		// Get the creature lists depending on player's creature type state for the mod (the steps are three because three keypress events occur for some reason?!) 
		switch(animals)
		{
		case 0:
			spawnList.addAll(theWorld.getChunkProvider().getPossibleCreatures(EnumCreatureType.monster, x, y-1, z));break;
		case 3:
			spawnList.addAll(theWorld.getChunkProvider().getPossibleCreatures(EnumCreatureType.creature, x, y-1, z));break;
		case 6:
			spawnList.addAll(theWorld.getChunkProvider().getPossibleCreatures(EnumCreatureType.waterCreature, x, y-1, z));break;
		case 9:
			spawnList.addAll(theWorld.getChunkProvider().getPossibleCreatures(EnumCreatureType.ambient, x, y-1, z));break;
		default:
			spawnList.addAll(theWorld.getChunkProvider().getPossibleCreatures(EnumCreatureType.monster, x, y-1, z));
		}
		
		if( !spawnList.equals(null) && !spawnList.isEmpty())
		{
			for(int i = 0; i < spawnList.size(); i++)
			{
				try
                {
					SpawnListEntry entry = (SpawnListEntry)spawnList.get(i);
                    EntityLiving mob = (EntityLiving)entry.entityClass.getConstructor(new Class[] {World.class}).newInstance(new Object[] {theWorld});
                    String name = EntityList.getEntityString(mob).length()<11?EntityList.getEntityString(mob):EntityList.getEntityString(mob).substring(0, 10);
                    int weight = entry.itemWeight;
                    int mobID = EntityList.getEntityID(mob);
                                       
                    int canSpawn = evaluateSpawnLocationForMob(mob, x, y-1, z, player, (World)theWorld);
                    
                    if(player.dimension == -1 && name.equals("Skeleton")){name = "WSkeleton";}
                    if(theWorld.getChunkFromBlockCoords(x, z).getRandomWithSeed(987234911L).nextInt(10) == 0 && name == "Slime"){name = "Slime!";}
                    
                    dataString += name + "," + weight + "," + canSpawn + ";";
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
			}
		}
		
		return dataString;
	}


	/**
	 * Evaluate if the mob can spawn at the location on client; same as server
	 */
	private int evaluateSpawnLocationForMob(EntityLiving mob, int x, int y,	int z, EntityClientPlayerMP player, World theWorld) 
	{
		int mobID = EntityList.getEntityID(mob);
		mob.setLocationAndAngles((double)x + 0.5, (double)y, (double)z + 0.5, 0, 0.0F);
		
        //Resize Slimes
        if(mob instanceof EntitySlime){mob.boundingBox.setBounds(mob.posX - (double)(0.3), mob.posY - (double)mob.yOffset + (double)mob.ySize, mob.posZ - (double)(0.3), mob.posX + (double)(0.3), mob.posY - (double)mob.yOffset + (double)mob.ySize + (double)(0.6), mob.posZ + (double)(0.3));}

		mob.setDead();
		
		// Check to see if there's a mapping for the mobID
		if(mobIDToCheckMapping.containsKey(mobID))
		{
			// If there is, check to see if there's a class registered
			// This is for non-vanilla mobs that have been added and have special spawning conditions
			// 	the mobID is the ID used by EntityList
			String checkType = (String)mobIDToCheckMapping.get(mobID);
			if(mobCheckMapping.containsKey(checkType))
			{
				// See if the class implements IShowMonstersCheck
				try
				{
					Class checkingClass = Class.forName((String)mobCheckMapping.get(checkType));
					Object checkingObject = checkingClass.newInstance();					
					IShowMonstersCheck check;
					if(checkingObject instanceof IShowMonstersCheck)
					{
						//If it does run the check and return a value
						int result = 1;
						check = (IShowMonstersCheck)checkingObject;
						switch(check.getMethodToUse())
						{
							case 0: result = check.performCheckAtPosition(theWorld, x, y, z);
							case 1: result = check.performCheckAtPositionWithPlayer(player, theWorld, x, y, z);
						}
						
						//If the check does not fail and we need to check the bounding box in the proxy 
						if(result != 0 && check.shouldCheckBB())
						{
							if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
						}
						else
						{
							return result;
						}
					}
					else
					{
						//Otherwise, we aren't sure if the mob can spawn
						return 2;
					}
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
			}
			// If a class isn't registered; either this is a vanilla mob, or it follows one of the vanilla spawning requirements.
			else
			{
				if(((String)mobIDToCheckMapping.get(mobID)).equals("overworld"))
				{
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					
					int blockLight = theWorld.getBlockLightValue(x, y, z);

		            if(theWorld.isThundering())
		            {
		                int slSubtracted = theWorld.skylightSubtracted;
		                theWorld.skylightSubtracted = 10;
		                blockLight = theWorld.getBlockLightValue(x, y, z);
		                theWorld.skylightSubtracted = slSubtracted;
		            }

		            return blockLight <= 7?1:0;
				}
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("slime"))
				{
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					
					if(!((theWorld.getBiomeGenForCoords(x, z) == BiomeGenBase.swampland && y > 50.0D && y < 70.0D && theWorld.getBlockLightValue(x, y, z) <= 7) || (theWorld.getChunkFromBlockCoords(x, z).getRandomWithSeed(987234911L).nextInt(10) == 0 && y < 40.0D)))
	                {
	                    return 0;
	                }
					return 1;
					
				}
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("nether"))
				{
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					
					return 1;
				}
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("ocelot"))
				{
	                int bID = theWorld.getBlockId(x, y - 1, z);
	                
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					
					if (y < 63)
	                {
	                    return 0;
	                }

	                if(!(bID == Block.grass.blockID || bID == Block.leaves.blockID))
	                {
	                    return 0;
	                }
	                
	                return 1;				
				}
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("peaceful"))
				{
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					
					if(!(theWorld.getBlockId(x, y-1, z)==Block.grass.blockID))
					{
						return 0;
					}
					
					return theWorld.getFullBlockLightValue(x, y, z)>8?1:0;
				}
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("squid"))
				{
					if(!(theWorld.getBlockMaterial(x, y, z).isLiquid() && theWorld.getBlockMaterial(x, y-1, z).isLiquid() && !theWorld.isBlockNormalCube(x, y + 1, z)))
					{
						return 0;
					}
					return (y > 45.0D && y < 63.0D)?1:0;
				}
				else if(((String)mobIDToCheckMapping.get(mobID)).equals("bat"))
				{
					if(blockBelowCheck(theWorld,x,y,z)){return 0;}
					if(liquidInBlockCheck(theWorld,x,y,z)){return 0;}
					if(blockAboveCheck(theWorld,x,y,z)){return 0;}
					if(!getCollidingBoundingBoxes(theWorld, mob, mob.boundingBox).isEmpty()){return 0;}
					if(theWorld.getBlockLightValue(x, y, z) > 3){return 0;}
					
					return 1;
				}
			}
		}
		return 2;
	}
	
	/**
	 * Check the block below to see if it's a normal block that is not bedrock or is a top-slab/upside-down stair
	 */
	private boolean blockBelowCheck(World theWorld, int x, int y, int z)
	{
		if(!(theWorld.getBlockId(x, y-1, z)!=Block.bedrock.blockID && (theWorld.isBlockNormalCube(x, y-1, z) || theWorld.doesBlockHaveSolidTopSurface(x, y-1, z))))
        {
        	return true;
		}
		return false;
	}
	
	
	/**
	 * Check if the block is liquid
	 */
	private boolean liquidInBlockCheck(World theWorld, int x, int y, int z)
	{
		if(theWorld.getBlockMaterial(x, y, z).isLiquid())
		{
			return true;
		}
		return false;
	}
	
	/**
	 * Check the block above x,y,z to make sure it is not a normal cube
	 */
	private boolean blockAboveCheck(World theWorld, int x, int y, int z)
	{
		if(theWorld.isBlockNormalCube(x,y+1,z)){return true;}
		return false;
	}
	
	/**
	 * Checks the bounding box of the entity for blocks with collision
	 */
	@Override
	public List getCollidingBoundingBoxes(World theWorld, Entity theEntity, AxisAlignedBB boundingBox)
    {
		ArrayList collidingBoundingBoxes = new ArrayList();
        collidingBoundingBoxes.clear();
        int minX = MathHelper.floor_double(boundingBox.minX);
        int maxX = MathHelper.floor_double(boundingBox.maxX + 1.0D);
        int minY = MathHelper.floor_double(boundingBox.minY);
        int maxY = MathHelper.floor_double(boundingBox.maxY + 1.0D);
        int minZ = MathHelper.floor_double(boundingBox.minZ);
        int maxZ = MathHelper.floor_double(boundingBox.maxZ + 1.0D);
        for (int blockX = minX; blockX < maxX; ++blockX)
        {
            for (int blockZ = minZ; blockZ < maxZ; ++blockZ)
            {
                if (theWorld.blockExists(blockX, 64, blockZ))
                {
                    for (int blockY = minY - 1; blockY < maxY; ++blockY)
                    {
                        Block eachBlock = Block.blocksList[theWorld.getBlockId(blockX, blockY, blockZ)];
                        if (eachBlock != null)
                        {
                            eachBlock.addCollisionBoxesToList(theWorld, blockX, blockY, blockZ, boundingBox, collidingBoundingBoxes, theEntity);
                        }
                    }
                }
            }
        }
        return collidingBoundingBoxes;
    }
	
	/**
	 * Format the mob data string for rendering
	 */
	private HashMap[] formatMobData(String mobDataString)
	{
		HashMap nameAndWeightMap = new HashMap();
		HashMap nameAndCanSpawnMap = new HashMap();
		String slEntries[] = mobDataString.split(";");
		try
		{
			for(int i = 0; i < slEntries.length; i++)
			{
				String entrySplit[] = slEntries[i].split(",");
				if(nameAndWeightMap.containsKey(entrySplit[0]))
				{
					nameAndWeightMap.put(entrySplit[0], ((Integer)nameAndWeightMap.get(entrySplit[0])).intValue() + Integer.parseInt(entrySplit[1]));
					if((Integer)nameAndCanSpawnMap.get(entrySplit[0]) != Integer.parseInt(entrySplit[2]))
					{
						nameAndCanSpawnMap.put(entrySplit[0], 2);
					}
				}
				else
				{
					nameAndWeightMap.put(entrySplit[0], Integer.parseInt(entrySplit[1]));
					nameAndCanSpawnMap.put(entrySplit[0], Integer.parseInt(entrySplit[2]));
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
		return new HashMap[]{nameAndWeightMap, nameAndCanSpawnMap};
	}

	/**
	 * Draw the text overlay
	 */
	private void renderCreatureData(HashMap[] formattedMobData)
	{
		Iterator dataIter = formattedMobData[0].keySet().iterator();
		int nameDispLength = 0;
		String weightString = "";
		Minecraft mc = Minecraft.getMinecraft();
		
		ScaledResolution var1 = new ScaledResolution(mc.gameSettings, mc.displayWidth, mc.displayHeight);
        GL11.glClear(GL11.GL_DEPTH_BUFFER_BIT);
        GL11.glMatrixMode(GL11.GL_PROJECTION);
        GL11.glLoadIdentity();
        if(var1.getScaleFactor() > 1)
        	GL11.glOrtho(0.0D, mc.displayWidth/2., mc.displayHeight/2., 0.0D, 1000.0D, 3000.0D);
        else
        	GL11.glOrtho(0.0D, mc.displayWidth, mc.displayHeight, 0.0D, 1000.0D, 3000.0D);
        GL11.glMatrixMode(GL11.GL_MODELVIEW);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0F, 0.0F, -2000.0F);       
        
		GL11.glEnable(GL11.GL_TEXTURE_2D);
		GL11.glDisable(GL11.GL_BLEND);
		int yOffset = var1.getScaledHeight() - (65);
		String labelStr = "M:";
		
		switch(animals)
		{
		case 0:
			labelStr = "M:";
			break;
		case 3:
			labelStr = "A:";
			break;
		case 6:
			labelStr = "W:";
			break;
		case 9:
			labelStr = "E:";
			break;
		}
		
		while(dataIter.hasNext())
		{
			try
			{
				String sep = "";
				if(nameDispLength > 0)
				{
					sep = ":";
				}
				if(nameDispLength == 0)
				{
			        if(var1.getScaleFactor() > 1)
			        	mc.fontRenderer.drawStringWithShadow(labelStr, 2, (yOffset*var1.getScaleFactor())/2, 14737632);
			        else
			        	mc.fontRenderer.drawStringWithShadow(labelStr, 2, (yOffset*var1.getScaleFactor()), 14737632);
					nameDispLength += mc.fontRenderer.getStringWidth(labelStr);
					weightString += "W:";
				}
				String key = (String) dataIter.next();
		        if(var1.getScaleFactor() > 1)
		        	mc.fontRenderer.drawStringWithShadow(sep, 2+nameDispLength, (yOffset*var1.getScaleFactor())/2, 14737632);
		        else
		        	mc.fontRenderer.drawStringWithShadow(sep, 2+nameDispLength, (yOffset*var1.getScaleFactor()), 14737632);
				nameDispLength += mc.fontRenderer.getStringWidth(sep);
		        if(var1.getScaleFactor() > 1)
		        	mc.fontRenderer.drawStringWithShadow(key, 2+nameDispLength, (yOffset*var1.getScaleFactor())/2, getDisplayColor(((Integer)formattedMobData[1].get(key)).intValue()));
		        else
		        	mc.fontRenderer.drawStringWithShadow(key, 2+nameDispLength, (yOffset*var1.getScaleFactor()), getDisplayColor(((Integer)formattedMobData[1].get(key)).intValue()));
				nameDispLength += mc.fontRenderer.getStringWidth(key);
				weightString += sep + (Integer)formattedMobData[0].get(key);
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
        if(var1.getScaleFactor() > 1)
        	mc.fontRenderer.drawStringWithShadow(weightString, 2, ((yOffset)*var1.getScaleFactor())/2 + 8, 14737632);
        else
        	mc.fontRenderer.drawStringWithShadow(weightString, 2, ((yOffset)*var1.getScaleFactor()) + 8, 14737632);
		
	}
	
	/**
	 * Color key for mob can spawn value
	 */
	private int getDisplayColor(int colorKey)
	{
		switch (colorKey)
		{
		case 0:	return 13643824;
		case 1: return 3199024;
		case 2: return 13684752;
		default: return 13684752;
		}
	}
	
	/**
	 * Add mapping For performing mob checks; use to add a mapping for one of the already defined check types
	 * <br>Make sure to call for Kabo.ShowMonsters.common.CommonProxy as well.
	 */
	public static void addMobCheckMapping(int mobID, String checkType)
	{
		mobIDToCheckMapping.put(mobID,checkType);
	}
	
	/**
	 * Add mapping for performing mob checks; 
	 * <br>Use this to add a custom check type; use the path to your class
	 * <br>The class should use the ShowMonstersCheck interface;
	 * <br>Make sure to call for Kabo.ShowMonsters.common.CommonProxy as well.
	 * @see IShowMonstersCheck ShowMonstersCheck for how to use it.
	 */
	public static void addMobCheckMapping(int mobID, String checkType, String classPath)
	{
		mobIDToCheckMapping.put(mobID,checkType);
		mobCheckMapping.put(checkType,classPath);
	}
	
	static
	{
		//Generic Mob and Monster Entities
		addMobCheckMapping(48,"unknown");
		addMobCheckMapping(49,"unknown");
		
		//WitherBoss, EnderDragon, SilverFish, Giant
		addMobCheckMapping(64,"unknown");
		addMobCheckMapping(63,"unknown");
		addMobCheckMapping(60,"unknown");
		addMobCheckMapping(53,"unknown");
		
		//Creeper, Skeleton, Zombie, Enderman, Spider, CaveSpider, Witch
		addMobCheckMapping(50,"overworld");
		addMobCheckMapping(51,"overworld");
		addMobCheckMapping(54,"overworld");
		addMobCheckMapping(58,"overworld");
		addMobCheckMapping(52,"overworld");
		addMobCheckMapping(59,"overworld");
		addMobCheckMapping(66,"overworld");		
		
		//Slime
		addMobCheckMapping(55,"slime");
		
		//PigZombie, Blaze, Ghast, LavaSlime
		addMobCheckMapping(57,"nether");
		addMobCheckMapping(61,"nether");
		addMobCheckMapping(56,"nether");
		addMobCheckMapping(62,"nether");
		
		//Ocelot
		addMobCheckMapping(98,"ocelot");
		
		//Pig, Sheep, Cow, Chicken, Wolves, Mooshrooms
		addMobCheckMapping(90,"peaceful");
		addMobCheckMapping(91,"peaceful");
		addMobCheckMapping(92,"peaceful");
		addMobCheckMapping(93,"peaceful");
		addMobCheckMapping(95,"peaceful");
		addMobCheckMapping(96,"peaceful");
		addMobCheckMapping(100,"peaceful");
		
		//Squid
		addMobCheckMapping(94,"squid");
		
		//Bat
		addMobCheckMapping(65,"bat");
		
	}
}
