/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.crossbowmod.asm;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CrossbowModTransformer
implements IClassTransformer {
    HashMap<String, String> nodemap = new HashMap();
    private boolean deobfuscated = true;

    public CrossbowModTransformer() {
        try {
            LaunchClassLoader loader = new LaunchClassLoader(((URLClassLoader)this.getClass().getClassLoader()).getURLs());
            URL classResource = loader.findResource(String.valueOf("net.minecraft.world.World").replace('.', '/').concat(".class"));
            this.deobfuscated = classResource != null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.deobfuscated) {
            this.nodemap.put("entityClass", "net/minecraft/entity/Entity");
            this.nodemap.put("modelBipedClass", "net/minecraft/client/model/ModelBiped");
            this.nodemap.put("setRotationAnglesMethod", "setRotationAngles");
            this.nodemap.put("setRotationAnglesDesc", "(FFFFFFL" + this.nodemap.get("entityClass") + ";)V");
        } else {
            this.nodemap.put("entityClass", "nm");
            this.nodemap.put("modelBipedClass", "bbg");
            this.nodemap.put("setRotationAnglesMethod", "a");
            this.nodemap.put("setRotationAnglesDesc", "(FFFFFFL" + this.nodemap.get("entityClass") + ";)V");
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.replace('.', '/').equals(this.nodemap.get("modelBipedClass"))) {
            bytes = this.transform1(name, bytes, this.nodemap);
        }
        return bytes;
    }

    public byte[] transform1(String name, byte[] bytes, HashMap<String, String> map) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 0);
        int operationCount = 1;
        int injectionCount = 0;
        block0: for (MethodNode methodnode : node.methods) {
            if (!methodnode.name.equals(map.get("setRotationAnglesMethod")) || !methodnode.desc.equals(map.get("setRotationAnglesDesc"))) continue;
            for (int count = 0; count < methodnode.instructions.size(); ++count) {
                AbstractInsnNode insnNode = methodnode.instructions.get(count);
                if (!(insnNode instanceof FieldInsnNode) || !((FieldInsnNode)insnNode).name.equals("aimedBow")) continue;
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 7));
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 3));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "micdoodle8/mods/crossbowmod/client/ClientProxy", "bipedRotationHook", "(L" + this.nodemap.get("modelBipedClass") + ";L" + this.nodemap.get("entityClass") + ";F)V"));
                methodnode.instructions.insertBefore(methodnode.instructions.get(count - 1), toAdd);
                ++injectionCount;
                break block0;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        bytes = writer.toByteArray();
        System.out.println("Crossbow Mod 2 successfully injected bytecode into: " + node.name + " (" + injectionCount + " / " + operationCount + ")");
        return bytes;
    }
}

