/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.launch;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import cpw.mods.fml.common.versioning.ComparableVersion;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class DepLoader
implements IFMLLoadingPlugin,
IFMLCallHook {
    private static ByteBuffer downloadBuffer = ByteBuffer.allocateDirect(0x800000);
    private static final String owner = "CodeChickenCore";
    private static DepLoadInst inst;
    private File mcDir;

    public static void load(File mcDir) {
        DepLoader inst = new DepLoader();
        inst.mcDir = mcDir;
        inst.call();
    }

    private static String[] splitFileName(String filename) {
        Pattern p = Pattern.compile("(.+?)([\\d\\.\\w]+)(\\.[^\\d]+)");
        Matcher m = p.matcher(filename);
        if (!m.matches()) {
            return null;
        }
        return new String[]{m.group(1), m.group(2), m.group(3)};
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
        this.mcDir = (File)data.get("mcLocation");
    }

    public Void call() {
        if (inst == null) {
            inst = new DepLoadInst();
            inst.load();
        }
        return null;
    }

    public String[] getLibraryRequestClass() {
        return null;
    }

    public class DepLoadInst {
        private File modsDir;
        private IDownloadDisplay downloadMonitor;
        private JDialog popupWindow;
        private Map<String, Dependancy> dependancies = new HashMap<String, Dependancy>();

        public DepLoadInst() {
            this.modsDir = new File(DepLoader.this.mcDir, "mods");
        }

        public void load(Dependancy dep) {
            this.downloadMonitor = FMLLaunchHandler.side().isClient() ? new Downloader() : new DummyDownloader();
            try {
                String existing = this.checkExisting(dep.filesplit);
                if (existing == null) {
                    this.download(dep);
                    existing = dep.fileName();
                }
                this.addClasspath(existing);
            }
            finally {
                if (this.popupWindow != null) {
                    this.popupWindow.setVisible(false);
                    this.popupWindow.dispose();
                }
            }
        }

        private void addClasspath(String name) {
            try {
                ((LaunchClassLoader)DepLoader.class.getClassLoader()).addURL(new File(this.modsDir, name).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        private void download(Dependancy dep) {
            this.popupWindow = (JDialog)this.downloadMonitor.makeDialog();
            File libFile = new File(this.modsDir, dep.fileName());
            try {
                URL libDownload = new URL(String.valueOf(dep.url) + '/' + dep.fileName());
                this.downloadMonitor.updateProgressString("Downloading file %s", libDownload.toString());
                System.out.format("Downloading file %s\n", libDownload.toString());
                URLConnection connection = libDownload.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("User-Agent", "CodeChickenCore Downloader");
                int sizeGuess = connection.getContentLength();
                this.download(connection.getInputStream(), sizeGuess, libFile);
                this.downloadMonitor.updateProgressString("Download complete", new Object[0]);
                System.out.println("Download complete");
            }
            catch (Exception e) {
                if (this.downloadMonitor.shouldStopIt()) {
                    System.err.println("You have stopped the downloading operation before it could complete");
                    return;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                System.err.format("There was a problem downloading the file %s automatically. Perhaps you have an environment without internet access. You will need to download the file manually or restart and let it try again\n", libFile.getName());
                libFile.delete();
                throw new RuntimeException("A download error occured", e);
            }
        }

        private void download(InputStream is, int sizeGuess, File target) {
            if (sizeGuess > downloadBuffer.capacity()) {
                throw new RuntimeException(String.format("The file %s is too large to be downloaded by CodeChickenCore - the coremod is invalid", target.getName()));
            }
            downloadBuffer.clear();
            int fullLength = 0;
            this.downloadMonitor.resetProgress(sizeGuess);
            try {
                int bytesRead;
                this.downloadMonitor.setPokeThread(Thread.currentThread());
                byte[] smallBuffer = new byte[1024];
                while ((bytesRead = is.read(smallBuffer)) >= 0) {
                    downloadBuffer.put(smallBuffer, 0, bytesRead);
                    fullLength += bytesRead;
                    if (this.downloadMonitor.shouldStopIt()) break;
                    this.downloadMonitor.updateProgress(fullLength);
                }
                is.close();
                this.downloadMonitor.setPokeThread(null);
                downloadBuffer.limit(fullLength);
                downloadBuffer.position(0);
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                if (!target.exists()) {
                    target.createNewFile();
                }
                downloadBuffer.position(0);
                FileOutputStream fos = new FileOutputStream(target);
                fos.getChannel().write(downloadBuffer);
                fos.close();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        private String checkExisting(String[] dependancy) {
            File[] fileArray = this.modsDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String[] split = DepLoader.splitFileName(f.getName());
                if (split != null && split[0].equals(dependancy[0])) {
                    ComparableVersion found = new ComparableVersion(split[1]);
                    ComparableVersion requested = new ComparableVersion(dependancy[1]);
                    int cmp = found.compareTo(requested);
                    if (cmp < 0) {
                        System.out.println("Deleted old version " + f.getName());
                        f.delete();
                        return null;
                    }
                    if (cmp > 0) {
                        System.err.println("Warning: version of " + dependancy[0] + ", " + split[1] + " is newer than request " + dependancy[1]);
                        return f.getName();
                    }
                    return f.getName();
                }
                ++n2;
            }
            return null;
        }

        public void load() {
            this.scanDepInfos();
            this.loadDeps();
        }

        private void loadDeps() {
            for (Dependancy dep : this.dependancies.values()) {
                this.load(dep);
            }
        }

        private void scanDepInfos() {
            File modsDir = new File(DepLoader.this.mcDir, "mods");
            File[] fileArray = modsDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                    try {
                        ZipFile zip = new ZipFile(file);
                        ZipEntry e = zip.getEntry("dependancies.info");
                        if (e != null) {
                            this.loadJSon(zip.getInputStream(e));
                        }
                        zip.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to load dependancies.info from " + file.getName() + " as JSON", e);
                    }
                }
                ++n2;
            }
        }

        private void loadJSon(InputStream input) throws IOException, InvalidSyntaxException {
            InputStreamReader reader = new InputStreamReader(input);
            JsonRootNode root = new JdomParser().parse((Reader)reader);
            if (root.hasElements()) {
                this.loadJSonArr(root);
            } else {
                this.loadJson((JsonNode)root);
            }
            reader.close();
        }

        private void loadJSonArr(JsonRootNode root) throws IOException {
            for (JsonNode node : root.getElements()) {
                this.loadJson(node);
            }
        }

        private void loadJson(JsonNode node) throws IOException {
            boolean obfuscated = ((LaunchClassLoader)DepLoader.class.getClassLoader()).getClassBytes("net.minecraft.world.World") == null;
            String testClass = node.getStringValue(new Object[]{"class"});
            if (DepLoader.class.getResource("/" + testClass.replace('.', '/') + ".class") != null) {
                return;
            }
            String repo = node.getStringValue(new Object[]{"repo"});
            String file = node.getStringValue(new Object[]{"file"});
            if (!obfuscated && node.isNode(new Object[]{"dev"})) {
                file = node.getStringValue(new Object[]{"dev"});
            }
            List<String> reserved = Arrays.asList("repo", "file", "class", "dev");
            for (Map.Entry e : node.getFields().entrySet()) {
                String s = ((JsonStringNode)e.getKey()).getText();
                if (!((JsonNode)e.getValue()).hasText() || reserved.contains(s)) continue;
                file = file.replaceAll("@" + s.toUpperCase() + "@", ((JsonNode)e.getValue()).getText());
            }
            String[] split = DepLoader.splitFileName(file);
            if (split == null) {
                throw new RuntimeException("Invalid filename format for dependancy: " + file);
            }
            this.addDep(new Dependancy(repo, split));
        }

        private void addDep(Dependancy dep) {
            Dependancy old = this.dependancies.get(dep.getName());
            if (old == null || dep.version.compareTo(old.version) > 0) {
                this.dependancies.put(dep.getName(), dep);
            }
        }
    }

    public class Dependancy {
        public String url;
        public String[] filesplit;
        public ComparableVersion version;

        public Dependancy(String url, String[] filesplit) {
            this.url = url;
            this.filesplit = filesplit;
            this.version = new ComparableVersion(filesplit[1]);
        }

        public String getName() {
            return this.filesplit[0];
        }

        public String fileName() {
            return String.valueOf(this.filesplit[0]) + this.filesplit[1] + this.filesplit[2];
        }
    }

    public static class Downloader
    extends JOptionPane
    implements IDownloadDisplay {
        private JDialog container;
        private JLabel currentActivity;
        private JProgressBar progress;
        boolean stopIt;
        Thread pokeThread;

        private Box makeProgressPanel() {
            Box box = Box.createVerticalBox();
            box.add(Box.createRigidArea(new Dimension(0, 10)));
            JLabel welcomeLabel = new JLabel("<html><b><font size='+1'>CodeChickenCore is setting up your minecraft environment</font></b></html>");
            box.add(welcomeLabel);
            welcomeLabel.setAlignmentY(0.0f);
            welcomeLabel = new JLabel("<html>Please wait, CodeChickenCore has some tasks to do before you can play</html>");
            welcomeLabel.setAlignmentY(0.0f);
            box.add(welcomeLabel);
            box.add(Box.createRigidArea(new Dimension(0, 10)));
            this.currentActivity = new JLabel("Currently doing ...");
            box.add(this.currentActivity);
            box.add(Box.createRigidArea(new Dimension(0, 10)));
            this.progress = new JProgressBar(0, 100);
            this.progress.setStringPainted(true);
            box.add(this.progress);
            box.add(Box.createRigidArea(new Dimension(0, 30)));
            return box;
        }

        @Override
        public JDialog makeDialog() {
            this.setMessageType(1);
            this.setMessage(this.makeProgressPanel());
            this.setOptions(new Object[]{"Stop"});
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() == Downloader.this && evt.getPropertyName() == "value") {
                        Downloader.this.requestClose("This will stop minecraft from launching\nAre you sure you want to do this?");
                    }
                }
            });
            this.container = new JDialog(null, "Hello", Dialog.ModalityType.MODELESS);
            this.container.setResizable(false);
            this.container.setLocationRelativeTo(null);
            this.container.add(this);
            this.updateUI();
            this.container.pack();
            this.container.setMinimumSize(this.container.getPreferredSize());
            this.container.setVisible(true);
            this.container.setDefaultCloseOperation(0);
            this.container.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Downloader.this.requestClose("Closing this window will stop minecraft from launching\nAre you sure you wish to do this?");
                }
            });
            return this.container;
        }

        protected void requestClose(String message) {
            int shouldClose = JOptionPane.showConfirmDialog(this.container, message, "Are you sure you want to stop?", 0, 2);
            if (shouldClose == 0) {
                this.container.dispose();
            }
            this.stopIt = true;
            if (this.pokeThread != null) {
                this.pokeThread.interrupt();
            }
        }

        @Override
        public void updateProgressString(String progressUpdate, Object ... data) {
            if (this.currentActivity != null) {
                this.currentActivity.setText(String.format(progressUpdate, data));
            }
        }

        @Override
        public void resetProgress(int sizeGuess) {
            if (this.progress != null) {
                this.progress.getModel().setRangeProperties(0, 0, 0, sizeGuess, false);
            }
        }

        @Override
        public void updateProgress(int fullLength) {
            if (this.progress != null) {
                this.progress.getModel().setValue(fullLength);
            }
        }

        @Override
        public void makeHeadless() {
            this.container = null;
            this.progress = null;
            this.currentActivity = null;
        }

        @Override
        public void setPokeThread(Thread currentThread) {
            this.pokeThread = currentThread;
        }

        @Override
        public boolean shouldStopIt() {
            return this.stopIt;
        }
    }

    public static class DummyDownloader
    implements IDownloadDisplay {
        @Override
        public void resetProgress(int sizeGuess) {
        }

        @Override
        public void setPokeThread(Thread currentThread) {
        }

        @Override
        public void updateProgress(int fullLength) {
        }

        @Override
        public boolean shouldStopIt() {
            return false;
        }

        @Override
        public void updateProgressString(String string, Object ... data) {
        }

        @Override
        public Object makeDialog() {
            return null;
        }

        @Override
        public void makeHeadless() {
        }
    }

    public static interface IDownloadDisplay {
        public void resetProgress(int var1);

        public void setPokeThread(Thread var1);

        public void updateProgress(int var1);

        public boolean shouldStopIt();

        public void updateProgressString(String var1, Object ... var2);

        public Object makeDialog();

        public void makeHeadless();
    }
}

