/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.launch;

import codechicken.core.asm.CodeChickenAccessTransformer;
import codechicken.core.asm.CodeChickenCoreModContainer;
import codechicken.core.asm.DelegatedTransformer;
import codechicken.core.asm.MCPDeobfuscationTransformer;
import codechicken.core.asm.TweakTransformer;
import codechicken.core.launch.DepLoader;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.minecraft.launchwrapper.LaunchClassLoader;

@IFMLLoadingPlugin.TransformerExclusions(value={"codechicken.core.asm"})
public class CodeChickenCorePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static final String mcVersion = "[1.6.2]";
    public static LaunchClassLoader cl = (LaunchClassLoader)CodeChickenCorePlugin.class.getClassLoader();
    public static File minecraftDir;

    public CodeChickenCorePlugin() {
        if (minecraftDir != null) {
            return;
        }
        try {
            Field f_mcDir = CoreModManager.class.getDeclaredField("mcDir");
            f_mcDir.setAccessible(true);
            minecraftDir = (File)f_mcDir.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DepLoader.load(minecraftDir);
        CodeChickenCoreModContainer.loadConfig();
        MCPDeobfuscationTransformer.load();
    }

    public String[] getLibraryRequestClass() {
        return null;
    }

    public static void versionCheck(String reqVersion, String mod) {
        String mcVersion = (String)FMLInjectionData.data()[4];
        if (!VersionParser.parseRange((String)reqVersion).containsVersion((ArtifactVersion)new DefaultArtifactVersion(mcVersion))) {
            String err = "This version of " + mod + " does not support minecraft version " + mcVersion;
            System.err.println(err);
            JEditorPane ep = new JEditorPane("text/html", "<html>" + err + "<br>Remove it from your coremods folder and check <a href=\"http://www.minecraftforum.net/topic/909223-\">here</a> for updates" + "</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, ep, "Fatal error", 0);
            System.exit(1);
        }
    }

    public String[] getASMTransformerClass() {
        CodeChickenCorePlugin.versionCheck(mcVersion, "CodeChickenCore");
        return new String[]{"codechicken.lib.asm.ClassHeirachyManager", "codechicken.core.asm.CodeChickenAccessTransformer", "codechicken.core.asm.InterfaceDependancyTransformer", "codechicken.core.asm.TweakTransformer", "codechicken.core.asm.FeatureHackTransformer", "codechicken.core.asm.DelegatedTransformer"};
    }

    public String getModContainerClass() {
        return "codechicken.core.asm.CodeChickenCoreModContainer";
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public Void call() {
        TweakTransformer.load();
        this.scanCodeChickenMods();
        return null;
    }

    private void scanCodeChickenMods() {
        File modsDir = new File(minecraftDir, "mods");
        File[] fileArray = modsDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                try {
                    JarFile jar = new JarFile(file);
                    try {
                        Attributes attr;
                        Manifest manifest = jar.getManifest();
                        if (manifest != null && (attr = manifest.getMainAttributes()) != null) {
                            String transformer;
                            String mapFile = attr.getValue("AccessTransformer");
                            if (mapFile != null) {
                                File temp = this.extractTemp(jar, mapFile);
                                System.out.println("Adding AccessTransformer: " + mapFile);
                                CodeChickenAccessTransformer.addTransformerMap(temp.getPath());
                                temp.delete();
                            }
                            if ((transformer = attr.getValue("CCTransformer")) != null) {
                                System.out.println("Adding CCTransformer: " + transformer);
                                DelegatedTransformer.addTransformer(transformer, jar, file);
                            }
                        }
                    }
                    finally {
                        jar.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("CodeChickenCore: Failed to read jar file: " + file.getName());
                }
            }
            ++n2;
        }
    }

    private File extractTemp(JarFile jar, String mapFile) throws IOException {
        File temp = new File("temp.dat");
        if (!temp.exists()) {
            temp.createNewFile();
        }
        FileOutputStream fout = new FileOutputStream(temp);
        byte[] data = new byte[4096];
        int read = 0;
        InputStream fin = jar.getInputStream(jar.getEntry(mapFile));
        while ((read = fin.read(data)) > 0) {
            fout.write(data, 0, read);
        }
        fin.close();
        fout.close();
        return temp;
    }
}

