/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ComparableVersion;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class CCUpdateChecker {
    private static ArrayList<String> updates = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        ats mc = ats.w();
        if (!mc.A) {
            return;
        }
        ArrayList<String> arrayList = updates;
        synchronized (arrayList) {
            for (String s : updates) {
                mc.h.a(s);
            }
            updates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUpdateMessage(String s) {
        ArrayList<String> arrayList = updates;
        synchronized (arrayList) {
            updates.add(s);
        }
    }

    public static String mcVersion() {
        return (String)FMLInjectionData.data()[4];
    }

    public static void updateCheck(String mod, String version) {
        try {
            new ThreadUpdateCheck(new URL("http://www.chickenbones.craftsaddle.org/Files/New_Versions/version.php?version=" + CCUpdateChecker.mcVersion() + "&" + "file=" + mod), mod, new ComparableVersion(version)).start();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static void updateCheck(String mod) {
        CCUpdateChecker.updateCheck(mod, ((ModContainer)Loader.instance().getIndexedModList().get(mod)).getVersion());
    }

    private static class ThreadUpdateCheck
    extends Thread {
        private final URL url;
        private final String mod;
        private final ComparableVersion version;

        public ThreadUpdateCheck(URL url, String mod, ComparableVersion version) {
            this.url = url;
            this.mod = mod;
            this.version = version;
            this.setName("CodeChicken Update Checker");
        }

        @Override
        public void run() {
            try {
                HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                BufferedReader read = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String ret = read.readLine();
                read.close();
                if (!ret.startsWith("Ret: ")) {
                    System.err.println("Failed to check update for " + this.mod + " returned: " + ret);
                    return;
                }
                ComparableVersion newversion = new ComparableVersion(ret.substring(5));
                if (newversion.compareTo(this.version) > 0) {
                    CCUpdateChecker.addUpdateMessage("Version " + newversion + " of " + this.mod + " is available");
                }
            }
            catch (SocketTimeoutException conn) {
            }
            catch (UnknownHostException conn) {
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }
}

