/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.stackie;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import lunatrius.stackie.Ticker;
import lunatrius.stackie.util.Config;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;

@Mod(modid="Stackie")
public class Stackie {
    @Mod.Instance(value="Stackie")
    public static Stackie instance;
    private int interval = 20;
    private float distance = 0.75f;
    private boolean stackItems = true;
    private boolean stackExperience = true;
    private Field xpValue = null;
    private MinecraftServer server = null;
    private int ticks = -1;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.interval = Config.getInt(config, "general", "interval", this.interval, 5, 500, "Amount of ticks (20 ticks => 1 second) that will pass between each stacking attempt.");
        this.distance = (float)Config.getDouble(config, "general", "distance", this.distance, 0.01, 10.0, "Maximum distance between items that can be still stacked (relative to block size).");
        this.stackItems = Config.getBoolean(config, "general", "stackItems", this.stackItems, "Should it stack items?");
        this.stackExperience = Config.getBoolean(config, "general", "stackExperience", this.stackExperience, "Should it stack experience orbs?");
        config.save();
        try {
            this.xpValue = ReflectionHelper.findField(nz.class, (String[])new String[]{"e", "field_70530_e", "xpValue"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        TickRegistry.registerTickHandler((ITickHandler)new Ticker(EnumSet.of(TickType.SERVER)), (Side)Side.SERVER);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.server = event.getServer();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.server = null;
    }

    public boolean onTick(TickType tickType, boolean start) {
        if (start) {
            return true;
        }
        if (--this.ticks < 0 && this.server != null && this.server.b != null) {
            this.stackEntities(this.server.b);
            this.ticks = this.interval;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stackEntities(jr[] theWorldServer) {
        jr[] arr$ = theWorldServer;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            jr world = arr$[i$];
            ArrayList<nm> entityList = new ArrayList<nm>();
            for (int i = 0; i < world.e.size(); ++i) {
                if (this.getType((nm)world.e.get(i)) == -1) continue;
                entityList.add((nm)world.e.get(i));
            }
            int mcType = -1;
            nm mcEntity = null;
            sr mcEntityItem = null;
            yd mcItemStack = null;
            nz mcEntityXPOrb = null;
            double mcWeight = -1.0;
            int localType = -1;
            nm localEntity = null;
            sr localEntityItem = null;
            yd localItemStack = null;
            nz localEntityXPOrb = null;
            double localWeight = -1.0;
            boolean merged = false;
            double totalWeight = -1.0;
            try {
                block14: for (int i = 0; i < entityList.size() - 1; ++i) {
                    mcEntity = (nm)entityList.get(i);
                    if (mcEntity.M) continue;
                    mcType = this.getType(mcEntity);
                    switch (mcType) {
                        case 0: {
                            mcEntityItem = (sr)mcEntity;
                            mcItemStack = mcEntityItem.d();
                            if (mcItemStack != null && mcItemStack.f() && mcItemStack.b < mcItemStack.e() && mcItemStack.b > 0) break;
                            continue block14;
                        }
                        case 1: {
                            mcEntityXPOrb = (nz)mcEntity;
                        }
                    }
                    block15: for (int j = i + 1; j < entityList.size(); ++j) {
                        localEntity = (nm)entityList.get(j);
                        if (localEntity.M || mcType != (localType = this.getType(localEntity))) continue;
                        merged = false;
                        switch (mcType) {
                            case 0: {
                                localEntityItem = (sr)localEntity;
                                localItemStack = localEntityItem.d();
                                if (localItemStack == null || mcItemStack.d != localItemStack.d || mcItemStack.e != null || localItemStack.e != null || !this.isEqualPosition((nm)mcEntityItem, (nm)localEntityItem) || mcItemStack.k() != localItemStack.k()) continue block15;
                                mcWeight = mcItemStack.b;
                                localWeight = localItemStack.b;
                                int itemsIn = Math.min(mcItemStack.e() - mcItemStack.b, localItemStack.b);
                                mcItemStack.b += itemsIn;
                                localItemStack.b -= itemsIn;
                                mcEntityItem.a(mcItemStack);
                                localEntityItem.a(localItemStack);
                                mcEntityItem.a = Math.min(mcEntityItem.a, localEntityItem.a);
                                if (localItemStack.b > 0) break;
                                merged = true;
                                break;
                            }
                            case 1: {
                                localEntityXPOrb = (nz)localEntity;
                                if (!this.isEqualPosition((nm)mcEntityXPOrb, (nm)localEntityXPOrb)) continue block15;
                                try {
                                    mcWeight = mcEntityXPOrb.c();
                                    localWeight = localEntityXPOrb.c();
                                    this.xpValue.setInt(mcEntityXPOrb, mcEntityXPOrb.c() + localEntityXPOrb.c());
                                    this.xpValue.setInt(localEntityXPOrb, 0);
                                    mcEntityXPOrb.b = Math.min(mcEntityXPOrb.b, localEntityXPOrb.b);
                                    merged = true;
                                    break;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                        if (!merged) continue;
                        localEntity.w();
                        totalWeight = mcWeight + localWeight;
                        mcEntity.b(mcEntity.u * (mcWeight /= totalWeight) + localEntity.u * (localWeight /= totalWeight), mcEntity.v * mcWeight + localEntity.v * localWeight, mcEntity.w * mcWeight + localEntity.w * localWeight);
                        mcEntity.h(mcEntity.x * mcWeight + localEntity.x * localWeight, mcEntity.y * mcWeight + localEntity.y * localWeight, mcEntity.z * mcWeight + localEntity.z * localWeight);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i$;
        }
        return;
    }

    private int getType(nm entity) {
        if (entity instanceof sr) {
            return 0;
        }
        if (entity instanceof nz && this.xpValue != null) {
            return 1;
        }
        return -1;
    }

    private boolean isEqualPosition(nm a, nm b) {
        return this.isEqual(a.u, b.u) && this.isEqual(a.v, b.v) && this.isEqual(a.w, b.w);
    }

    private boolean isEqual(double a, double b) {
        return this.isEqual(a, b, this.distance);
    }

    private boolean isEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }
}

