/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.msh;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lunatrius.msh.GuiMonsterSpawnHighlighter;
import lunatrius.msh.KeyBindingHandler;
import lunatrius.msh.Render;
import lunatrius.msh.Settings;
import lunatrius.msh.Ticker;
import lunatrius.msh.util.Config;
import lunatrius.msh.util.Vector4i;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="MonsterSpawnHighlighter")
public class MonsterSpawnHighlighter {
    private final ats minecraft = ats.w();
    private abv world = null;
    private final atp toggleKey = new atp("msh.toggle", 38);
    private final Settings settings = Settings.instance();
    private int ticks = -1;
    @Mod.Instance(value="MonsterSpawnHighlighter")
    public static MonsterSpawnHighlighter instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = this.settings.config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.settings.colorDayRed = (float)Config.getInt(config, "general", "colorDayRed", (int)(this.settings.colorDayRed * 255.0f), 0, 255, "Amount of red color (during the day).") / 255.0f;
        this.settings.colorDayGreen = (float)Config.getInt(config, "general", "colorDayGreen", (int)(this.settings.colorDayGreen * 255.0f), 0, 255, "Amount of green color (during the day).") / 255.0f;
        this.settings.colorDayBlue = (float)Config.getInt(config, "general", "colorDayBlue", (int)(this.settings.colorDayBlue * 255.0f), 0, 255, "Amount of blue color (during the day).") / 255.0f;
        this.settings.colorNightRed = (float)Config.getInt(config, "general", "colorNightRed", (int)(this.settings.colorNightRed * 255.0f), 0, 255, "Amount of red color (during the night).") / 255.0f;
        this.settings.colorNightGreen = (float)Config.getInt(config, "general", "colorNightGreen", (int)(this.settings.colorNightGreen * 255.0f), 0, 255, "Amount of green color (during the night).") / 255.0f;
        this.settings.colorNightBlue = (float)Config.getInt(config, "general", "colorNightBlue", (int)(this.settings.colorNightBlue * 255.0f), 0, 255, "Amount of blue color (during the night).") / 255.0f;
        this.settings.colorBothRed = (float)Config.getInt(config, "general", "colorBothRed", (int)(this.settings.colorBothRed * 255.0f), 0, 255, "Amount of red color (during the night).") / 255.0f;
        this.settings.colorBothGreen = (float)Config.getInt(config, "general", "colorBothGreen", (int)(this.settings.colorBothGreen * 255.0f), 0, 255, "Amount of green color (during the night).") / 255.0f;
        this.settings.colorBothBlue = (float)Config.getInt(config, "general", "colorBothBlue", (int)(this.settings.colorBothBlue * 255.0f), 0, 255, "Amount of blue color (during the night).") / 255.0f;
        this.settings.renderRange = Config.getInt(config, "general", "renderRange", this.settings.renderRange, 1, 50, "Amount of blocks that should be checked in each direction ([2*range+1]^3 total)");
        this.settings.updateRate = Config.getInt(config, "general", "updateRate", this.settings.updateRate, 1, 30, "Amount of ticks to wait before refreshing again.");
        this.settings.guideLength = (float)Config.getDouble(config, "general", "guideLength", this.settings.guideLength, -50.0, 50.0, "Length of the guide line (negative numbers invert the guide line).");
        for (int i = 0; i < this.settings.entityLiving.length; ++i) {
            this.settings.entityLiving[i].enabled = Config.getBoolean(config, "general", "enabled" + this.settings.entityLiving[i].name, this.settings.entityLiving[i].enabled, "Enable spawn rendering of " + this.settings.entityLiving[i].name + ".");
        }
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        try {
            MinecraftForge.EVENT_BUS.register((Object)new Render(this.minecraft));
            KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyBindingHandler(new atp[]{this.toggleKey}, new boolean[]{false}));
            LanguageRegistry.instance().addStringLocalization("msh.toggle", "Toggle Monster Spawns");
            TickRegistry.registerTickHandler((ITickHandler)new Ticker(EnumSet.of(TickType.CLIENT)), (Side)Side.CLIENT);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        try {
            this.settings.seed = event.getServer().b[0].H();
        }
        catch (Exception e) {
            this.settings.seed = 0L;
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.settings.seed = 0L;
    }

    public void keyboardEvent(atp keyBinding, boolean down) {
        if (down && this.minecraft.n == null && keyBinding == this.toggleKey) {
            this.minecraft.a((awb)new GuiMonsterSpawnHighlighter());
        }
    }

    public boolean onTick(TickType tickType, boolean start) {
        if (start) {
            return true;
        }
        if (--this.ticks < 0) {
            this.ticks = this.settings.updateRate;
            if (this.minecraft != null && this.minecraft.f != null && this.settings.renderBlocks != 0) {
                this.settings.spawnList.clear();
                this.world = this.minecraft.f;
                int lowX = (int)(Math.floor(this.settings.playerPosition.x) - (double)this.settings.renderRange);
                int highX = (int)(Math.floor(this.settings.playerPosition.x) + (double)this.settings.renderRange);
                int lowY = (int)(Math.floor(this.settings.playerPosition.y) - (double)this.settings.renderRange);
                int highY = (int)(Math.floor(this.settings.playerPosition.y) + (double)this.settings.renderRange);
                int lowZ = (int)(Math.floor(this.settings.playerPosition.z) - (double)this.settings.renderRange);
                int highZ = (int)(Math.floor(this.settings.playerPosition.z) + (double)this.settings.renderRange);
                for (int y = lowY; y <= highY; ++y) {
                    for (int x = lowX; x <= highX; ++x) {
                        for (int z = lowZ; z <= highZ; ++z) {
                            this.setEntityLivingLocation(x, y, z);
                            int type = this.getCanSpawnHere(x, y, z);
                            if (type <= 0) continue;
                            this.settings.spawnList.add(new Vector4i(x, y, z, type));
                        }
                    }
                }
            }
        }
        return true;
    }

    private void setEntityLivingLocation(int x, int y, int z) {
        for (int i = 0; i < this.settings.entityLiving.length; ++i) {
            this.settings.entityLiving[i].entity.b((double)((float)x + 0.5f), (double)y, (double)((float)z + 0.5f), 0.0f, 0.0f);
        }
    }

    private int getCanSpawnHere(int x, int y, int z) {
        int blockID = this.world.a(x, y - 1, z);
        if (blockID == 0) {
            return 0;
        }
        aqw block = aqw.s[blockID];
        if (block == null || block != null && block.cU.d()) {
            return 0;
        }
        acp biome = this.world.a(x, z);
        Map<Object, Object> entityCreatureTypeMapping = null;
        if (!this.settings.biomeCreatureSpawnMapping.containsKey(biome.N)) {
            entityCreatureTypeMapping = new HashMap();
            for (og creatureType : og.values()) {
                List spawnableList = biome.a(creatureType);
                if (spawnableList == null) continue;
                for (acq acq2 : spawnableList) {
                    entityCreatureTypeMapping.put(acq2.b, creatureType);
                }
            }
            this.settings.biomeCreatureSpawnMapping.put(biome.N, entityCreatureTypeMapping);
        }
        if ((entityCreatureTypeMapping = this.settings.biomeCreatureSpawnMapping.get(biome.N)) == null) {
            return 0;
        }
        int spawnType = 0;
        of entity = null;
        for (Map.Entry<Object, Object> entry : entityCreatureTypeMapping.entrySet()) {
            Class key = (Class)entry.getKey();
            og value = (og)entry.getValue();
            for (int i = 0; i < this.settings.entityLiving.length; ++i) {
                entity = this.settings.entityLiving[i].entity;
                if (!this.settings.entityLiving[i].enabled || !key.isInstance(entity) || !key.equals(rw.class) && !ach.a((og)value, (abv)this.world, (int)x, (int)y, (int)z)) continue;
                if (!this.world.d(entity.E) && this.world.a(entity.E).isEmpty()) {
                    if ((key.equals(te.class) || key.equals(tv.class) || key.equals(tq.class) || key.equals(ts.class) || key.equals(tf.class)) && this.getBlockLightLevel(x, y, z, 16) < 8) {
                        spawnType |= 2;
                    }
                    if (key.equals(rn.class) && entity.E.b < 63.0 && this.getBlockLightLevel(x, y, z, 16) <= 7) {
                        spawnType |= 2;
                    }
                    if (key.equals(tr.class) && (this.isSlimeChunk(x >> 4, z >> 4) && y < 40 || biome.N == acp.h.N)) {
                        return 3;
                    }
                    if (key.equals(tm.class) || key.equals(ti.class) || key.equals(tk.class)) {
                        return 3;
                    }
                    if ((key.equals(rp.class) || key.equals(rq.class) || key.equals(rv.class) || key.equals(rx.class) || key.equals(rx.class) || key.equals(se.class)) && blockID == aqw.z.cF && this.getBlockLightLevel(x, y, z, 0) > 8) {
                        spawnType |= 1;
                    }
                    if (key.equals(rw.class) && y >= 64 && (blockID == aqw.z.cF || blockID == aqw.P.cF)) {
                        return 3;
                    }
                }
                if (!key.equals(sb.class) || y <= 45 || y >= 63) continue;
                return 3;
            }
        }
        return spawnType;
    }

    private int getBlockLightLevel(int x, int y, int z, int kst) {
        return this.world.e(x >> 4, z >> 4).c(x & 0xF, y, z & 0xF, kst);
    }

    private boolean isSlimeChunk(int x, int z) {
        return this.settings.seed != 0L && new Random(this.settings.seed + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)(z * z) * 4392871L + (long)(z * 389711) ^ 0x3AD8025FL).nextInt(10) == 0;
    }
}

