/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.ingameinfo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lunatrius.ingameinfo.Value;
import net.minecraft.server.MinecraftServer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InGameInfoCore {
    private static final InGameInfoCore instance = new InGameInfoCore();
    private Logger logger = null;
    private boolean isLoaded = false;
    private ats minecraftClient = null;
    private MinecraftServer minecraftServer = null;
    private abv world = null;
    private ue player = null;
    private awc scaledResolution = null;
    private File configFile = null;
    private final Map<String, List<List<Value>>> format = new HashMap<String, List<List<Value>>>();
    private final String[] difficulties = new String[]{"options.difficulty.peaceful", "options.difficulty.easy", "options.difficulty.normal", "options.difficulty.hard"};
    private final String[] roughdirection = new String[]{"South", "West", "North", "East"};
    private final String[] finedirection = new String[]{"South", "South West", "West", "North West", "North", "North East", "East", "South East"};
    private final String[] abrroughdirection = new String[]{"S", "W", "N", "E"};
    private final String[] abrfinedirection = new String[]{"S", "SW", "W", "NW", "N", "NE", "E", "SE"};
    private final int[] playerPosition = new int[]{0, 0, 0};
    private ni[] potionEffects = null;
    private long seed = 0L;
    private final Map<String, List<String>> valuePairs = new HashMap<String, List<String>>();

    private InGameInfoCore() {
    }

    public static InGameInfoCore instance() {
        return instance;
    }

    public void init(File file) {
        this.configFile = file;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setServer(MinecraftServer server) {
        this.minecraftServer = server;
        if (this.minecraftServer != null) {
            try {
                this.seed = this.minecraftServer.b[0].H();
            }
            catch (Exception e) {
                this.seed = 0L;
            }
        }
    }

    public void setClient(ats client) {
        this.minecraftClient = client;
    }

    public void onTickClient() {
        if (!this.isLoaded && Keyboard.isKeyDown((int)61) && Keyboard.isKeyDown((int)19)) {
            this.loadConfig();
            this.isLoaded = true;
        } else {
            this.isLoaded = false;
        }
        this.world = this.minecraftClient.f;
        this.player = this.minecraftClient.h;
        this.scaledResolution = new awc(this.minecraftClient.u, this.minecraftClient.d, this.minecraftClient.e);
        this.playerPosition[0] = (int)Math.floor(this.player.u);
        this.playerPosition[1] = (int)Math.floor(this.player.v);
        this.playerPosition[2] = (int)Math.floor(this.player.w);
        Collection potionEffectCollection = this.player.aK();
        this.potionEffects = new ni[potionEffectCollection.size()];
        if (potionEffectCollection.size() > 0) {
            int index = 0;
            Iterator iterator = potionEffectCollection.iterator();
            while (iterator.hasNext()) {
                this.potionEffects[index++] = (ni)iterator.next();
            }
        }
        Set<String> keys = this.format.keySet();
        for (String key : keys) {
            List<List<Value>> lines = this.format.get(key);
            ArrayList<String> stringLines = new ArrayList<String>();
            this.valuePairs.put(key, stringLines);
            for (List<Value> line : lines) {
                String str = "";
                for (int i = 0; i < line.size(); ++i) {
                    str = str + this.getValue(line.get(i));
                }
                if (str.isEmpty()) continue;
                stringLines.add(this.replaceVariables(str));
            }
        }
    }

    public void onTickRender() {
        int x = 0;
        int y = 0;
        int type = -1;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Set<String> keys = this.valuePairs.keySet();
        for (String key : keys) {
            List<String> lines = this.valuePairs.get(key);
            if (lines == null) continue;
            if (key.contains("top")) {
                y = 2;
            } else if (key.contains("mid")) {
                y = this.scaledResolution.b() / 2 - lines.size() * 10 / 2;
            } else {
                if (!key.contains("bot")) continue;
                y = this.scaledResolution.b() - lines.size() * 10 - 2;
            }
            if (key.contains("left")) {
                x = 2;
                type = 0;
            } else if (key.contains("center")) {
                x = this.scaledResolution.a() / 2;
                type = 1;
            } else {
                if (!key.contains("right")) continue;
                x = this.scaledResolution.a() - 2;
                type = 2;
            }
            for (String line : lines) {
                switch (type) {
                    case 0: {
                        this.drawLeftAlignedString(this.minecraftClient.l, line, x, y, 0xFFFFFF);
                        break;
                    }
                    case 1: {
                        this.drawCenteredString(this.minecraftClient.l, line, x, y, 0xFFFFFF);
                        break;
                    }
                    case 2: {
                        this.drawRightAlignedString(this.minecraftClient.l, line, x, y, 0xFFFFFF);
                    }
                }
                y += 10;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean loadConfig() {
        try {
            this.valuePairs.clear();
            this.format.clear();
            if (!this.configFile.exists()) {
                try {
                    String assetsDir = "lunatrius/ingameinfo/assets/";
                    InputStream stream = InGameInfoCore.class.getClassLoader().getResourceAsStream(assetsDir + this.configFile.getName());
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    String defaultConfig = "";
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        defaultConfig = defaultConfig + line + System.getProperty("line.separator");
                    }
                    FileWriter fstream = new FileWriter(this.configFile);
                    BufferedWriter out = new BufferedWriter(fstream);
                    out.write(defaultConfig);
                    out.close();
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Could not extract default configuration - corrupted installation detected!", e);
                    throw new RuntimeException(e);
                }
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(this.configFile);
            doc.getDocumentElement().normalize();
            NodeList nodeListLines = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeListLines.getLength(); ++i) {
                Element elementLines;
                if (nodeListLines.item(i).getNodeType() != 1 || !(elementLines = (Element)nodeListLines.item(i)).getNodeName().matches("(?i)^lines$")) continue;
                ArrayList<List<Value>> listLines = new ArrayList<List<Value>>();
                String attributeAt = elementLines.getAttribute("at");
                String at = "";
                if (attributeAt.matches("(?i).*(top).*")) {
                    at = "top";
                } else if (attributeAt.matches("(?i).*(mid).*")) {
                    at = "mid";
                } else {
                    if (!attributeAt.matches("(?i).*(bot).*")) continue;
                    at = "bot";
                }
                if (attributeAt.matches("(?i).*(left).*")) {
                    at = at + "left";
                } else if (attributeAt.matches("(?i).*(center).*")) {
                    at = at + "center";
                } else {
                    if (!attributeAt.matches("(?i).*(right).*")) continue;
                    at = at + "right";
                }
                NodeList nodeListLine = elementLines.getChildNodes();
                for (int j = 0; j < nodeListLine.getLength(); ++j) {
                    Element elementLine;
                    if (nodeListLine.item(j).getNodeType() != 1 || !(elementLine = (Element)nodeListLine.item(j)).getNodeName().matches("(?i)^line$")) continue;
                    listLines.add(this.getValues(elementLine));
                }
                this.format.put(at, listLines);
            }
            return true;
        }
        catch (Exception e) {
            this.format.clear();
            e.printStackTrace();
            return false;
        }
    }

    private String replaceVariables(String str) {
        Pattern pattern = Pattern.compile("\\{([a-z0-9]+)\\}", 2);
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            str = str.replace(matcher.group(0), this.getVariableValue(matcher.group(1)));
        }
        return str;
    }

    private List<Value> getValues(Element element) {
        ArrayList<Value> values = new ArrayList<Value>();
        NodeList nodeListValues = element.getChildNodes();
        for (int i = 0; i < nodeListValues.getLength(); ++i) {
            Element elementValue;
            if (nodeListValues.item(i).getNodeType() != 1 || !(elementValue = (Element)nodeListValues.item(i)).getNodeName().matches("(?i)^value$")) continue;
            String attributeType = elementValue.getAttribute("type");
            String type = "";
            if (attributeType.matches("(?i)(str|string)")) {
                type = "str";
            } else if (attributeType.matches("(?i)(num|number|int|integer|float)")) {
                type = "num";
            } else if (attributeType.matches("(?i)(var|variable)")) {
                type = "var";
            } else if (attributeType.matches("(?i)(if)")) {
                type = "if";
            } else if (attributeType.matches("(?i)(not)")) {
                type = "not";
            } else if (attributeType.matches("(?i)(and)")) {
                type = "and";
            } else if (attributeType.matches("(?i)(or)")) {
                type = "or";
            } else if (attributeType.matches("(?i)(xor)")) {
                type = "xor";
            } else if (attributeType.matches("(?i)(greater)")) {
                type = "greater";
            } else if (attributeType.matches("(?i)(less|lesser)")) {
                type = "less";
            } else if (attributeType.matches("(?i)(equals?)")) {
                type = "equal";
            } else if (attributeType.matches("(?i)(pct|percent|percentage)")) {
                type = "pct";
            } else if (attributeType.matches("(?i)(concat)")) {
                type = "concat";
            } else if (attributeType.matches("(?i)(max|maximum)")) {
                type = "max";
            } else if (attributeType.matches("(?i)(min|minimum)")) {
                type = "min";
            } else if (attributeType.matches("(?i)(add)")) {
                type = "add";
            } else if (attributeType.matches("(?i)(sub)")) {
                type = "sub";
            } else if (attributeType.matches("(?i)(mul)")) {
                type = "mul";
            } else if (attributeType.matches("(?i)(div)")) {
                type = "div";
            } else if (attributeType.matches("(?i)(round)")) {
                type = "round";
            } else if (attributeType.matches("(?i)(mod|modulo)")) {
                type = "mod";
            } else if (attributeType.matches("(?i)(imod|intmod|imodulo|intmodulo|modi|modint|moduloi|moduloint)")) {
                type = "modi";
            } else if (attributeType.matches("(?i)(itemquantity)")) {
                type = "itemquantity";
            } else {
                if (!attributeType.matches("(?i)(trans|translate)")) continue;
                type = "trans";
            }
            String value = elementValue.getTextContent().replaceAll("\\$(?=[0-9a-fk-or])", "\u00a7");
            Value val = new Value(type, value);
            val.values = this.getValues(elementValue);
            values.add(val);
        }
        return values;
    }

    private String getValue(Value value) {
        if (value.type.equals("str")) {
            return value.value;
        }
        if (value.type.equals("num")) {
            return value.value;
        }
        if (value.type.equals("var")) {
            return this.getVariableValue(value.value);
        }
        if (value.type.equals("if") && (value.values.size() == 2 || value.values.size() == 3)) {
            try {
                if (Boolean.parseBoolean(this.getValue(value.values.get(0)))) {
                    return this.getValue(value.values.get(1));
                }
                if (value.values.size() > 2) {
                    return this.getValue(value.values.get(2));
                }
                return "";
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals("not") && value.values.size() == 1) {
            try {
                return Boolean.toString(!Boolean.parseBoolean(this.getValue(value.values.get(0))));
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals("and")) {
            try {
                for (Value operand : value.values) {
                    if (Boolean.parseBoolean(this.getValue(operand))) continue;
                    return Boolean.toString(false);
                }
                return Boolean.toString(true);
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals("or")) {
            try {
                for (Value operand : value.values) {
                    if (!Boolean.parseBoolean(this.getValue(operand))) continue;
                    return Boolean.toString(true);
                }
                return Boolean.toString(false);
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals("xor")) {
            try {
                boolean result = false;
                for (Value operand : value.values) {
                    result ^= Boolean.parseBoolean(this.getValue(operand));
                }
                return Boolean.toString(result);
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals("greater") && value.values.size() > 1) {
            try {
                double current = Double.parseDouble(this.getValue(value.values.get(0)));
                for (Value operand : value.values.subList(1, value.values.size())) {
                    double next = Double.parseDouble(this.getValue(operand));
                    if (current > next) {
                        current = next;
                        continue;
                    }
                    return Boolean.toString(false);
                }
                return Boolean.toString(true);
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals("less") && value.values.size() > 1) {
            try {
                double current = Double.parseDouble(this.getValue(value.values.get(0)));
                for (Value operand : value.values.subList(1, value.values.size())) {
                    double next = Double.parseDouble(this.getValue(operand));
                    if (current < next) {
                        current = next;
                        continue;
                    }
                    return Boolean.toString(false);
                }
                return Boolean.toString(true);
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals("equal") && value.values.size() > 1) {
            try {
                double current = Double.parseDouble(this.getValue(value.values.get(0)));
                for (Value operand : value.values.subList(1, value.values.size())) {
                    double next = Double.parseDouble(this.getValue(operand));
                    if (current == next) continue;
                    return Boolean.toString(false);
                }
                return Boolean.toString(true);
            }
            catch (Exception e) {
                String current = this.getValue(value.values.get(0));
                for (Value operand : value.values.subList(1, value.values.size())) {
                    String next = this.getValue(operand);
                    if (current.equals(next)) continue;
                    return Boolean.toString(false);
                }
                return Boolean.toString(true);
            }
        }
        if (value.type.equals("pct") && value.values.size() == 2) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                return Double.toString(arg0 / arg1 * 100.0);
            }
            catch (Exception e) {
                return "0";
            }
        }
        if (value.type.equals("concat")) {
            String str = "";
            for (Value val : value.values) {
                str = str + this.getValue(val);
            }
            return str;
        }
        if (value.type.equals("max") && (value.values.size() == 2 || value.values.size() == 4)) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                int shift = value.values.size() - 2;
                return arg0 > arg1 ? this.getValue(value.values.get(0 + shift)) : this.getValue(value.values.get(1 + shift));
            }
            catch (Exception e) {
                return "0";
            }
        }
        if (value.type.equals("min") && (value.values.size() == 2 || value.values.size() == 4)) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                int shift = value.values.size() - 2;
                return arg0 < arg1 ? this.getValue(value.values.get(0 + shift)) : this.getValue(value.values.get(1 + shift));
            }
            catch (Exception e) {
                return "0";
            }
        }
        if (value.type.equals("add") && value.values.size() == 2) {
            try {
                int arg0 = Integer.parseInt(this.getValue(value.values.get(0)));
                int arg1 = Integer.parseInt(this.getValue(value.values.get(1)));
                return Integer.toString(arg0 + arg1);
            }
            catch (Exception e1) {
                try {
                    double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                    double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                    return Double.toString(arg0 + arg1);
                }
                catch (Exception e2) {
                    return "0";
                }
            }
        }
        if (value.type.equals("sub") && value.values.size() == 2) {
            try {
                int arg0 = Integer.parseInt(this.getValue(value.values.get(0)));
                int arg1 = Integer.parseInt(this.getValue(value.values.get(1)));
                return Integer.toString(arg0 - arg1);
            }
            catch (Exception e1) {
                try {
                    double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                    double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                    return Double.toString(arg0 - arg1);
                }
                catch (Exception e2) {
                    return "0";
                }
            }
        }
        if (value.type.equals("mul") && value.values.size() == 2) {
            try {
                int arg0 = Integer.parseInt(this.getValue(value.values.get(0)));
                int arg1 = Integer.parseInt(this.getValue(value.values.get(1)));
                return Integer.toString(arg0 * arg1);
            }
            catch (Exception e1) {
                try {
                    double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                    double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                    return Double.toString(arg0 * arg1);
                }
                catch (Exception e2) {
                    return "0";
                }
            }
        }
        if (value.type.equals("div") && value.values.size() == 2) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                return Double.toString(arg0 / arg1);
            }
            catch (Exception e2) {
                return "0";
            }
        }
        if (value.type.equals("round") && value.values.size() == 2) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                int arg1 = Integer.parseInt(this.getValue(value.values.get(1)));
                double dec = Math.pow(10.0, arg1);
                if (arg1 > 0) {
                    return String.format(Locale.ENGLISH, "%." + arg1 + "f", arg0);
                }
                return Integer.toString((int)((double)Math.round(arg0 * dec) / dec));
            }
            catch (Exception e2) {
                return "0";
            }
        }
        if (value.type.equals("mod") && value.values.size() == 2) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                return Double.toString((double)Math.round(arg0 % arg1 * 1.0E7) / 1.0E7);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return "0";
            }
        }
        if (value.type.equals("modi") && value.values.size() == 2) {
            try {
                int arg0 = Integer.parseInt(this.getValue(value.values.get(0)));
                int arg1 = Integer.parseInt(this.getValue(value.values.get(1)));
                return Integer.toString(arg0 % arg1);
            }
            catch (Exception e2) {
                return "0";
            }
        }
        if (value.type.equals("itemquantity") && (value.values.size() == 1 || value.values.size() == 2)) {
            try {
                int itemID = 0;
                int itemDamage = -1;
                itemID = Integer.parseInt(this.getValue(value.values.get(0)));
                if (value.values.size() == 2) {
                    itemDamage = Integer.parseInt(this.getValue(value.values.get(1)));
                }
                return Integer.toString(this.getItemCountInInventory(this.player, itemID, itemDamage));
            }
            catch (Exception e2) {
                return "0";
            }
        }
        if (value.type.equals("trans")) {
            try {
                return bt.a((String)value.value);
            }
            catch (Exception e) {
                return "?";
            }
        }
        return "";
    }

    private String getVariableValue(String var) {
        try {
            if (var.equalsIgnoreCase("day")) {
                return String.format(Locale.ENGLISH, "%d", this.world.J() / 24000L);
            }
            if (var.equalsIgnoreCase("mctime")) {
                long time = this.world.J();
                long hour = (time / 1000L + 6L) % 24L;
                long minute = time % 1000L * 60L / 1000L;
                return String.format(Locale.ENGLISH, "%02d:%02d", hour, minute);
            }
            if (var.equalsIgnoreCase("mctimeh")) {
                long hour = (this.world.J() / 1000L + 6L) % 24L;
                return String.format(Locale.ENGLISH, "%02d", hour);
            }
            if (var.equalsIgnoreCase("mctimem")) {
                long minute = this.world.J() % 1000L * 60L / 1000L;
                return String.format(Locale.ENGLISH, "%02d", minute);
            }
            if (var.equalsIgnoreCase("rltime") || var.equalsIgnoreCase("irltime")) {
                return new SimpleDateFormat("HH:mm").format(new Date());
            }
            if (var.equalsIgnoreCase("light")) {
                try {
                    return Integer.toString(this.world.d(this.playerPosition[0], this.playerPosition[2]).c(this.playerPosition[0] & 0xF, this.playerPosition[1], this.playerPosition[2] & 0xF, this.world.a(1.0f)));
                }
                catch (Exception e) {
                    return "0";
                }
            }
            if (var.equalsIgnoreCase("lightfeet")) {
                try {
                    return Integer.toString(this.world.d(this.playerPosition[0], this.playerPosition[2]).c(this.playerPosition[0] & 0xF, (int)Math.round(this.player.E.b), this.playerPosition[2] & 0xF, this.world.a(1.0f)));
                }
                catch (Exception e) {
                    return "0";
                }
            }
            if (var.equalsIgnoreCase("lightnosun")) {
                try {
                    return Integer.toString(this.world.d(this.playerPosition[0], this.playerPosition[2]).a(acg.b, this.playerPosition[0] & 0xF, this.playerPosition[1], this.playerPosition[2] & 0xF));
                }
                catch (Exception e) {
                    return "0";
                }
            }
            if (var.equalsIgnoreCase("lightnosunfeet")) {
                try {
                    return Integer.toString(this.world.d(this.playerPosition[0], this.playerPosition[2]).a(acg.b, this.playerPosition[0] & 0xF, (int)Math.round(this.player.E.b), this.playerPosition[2] & 0xF));
                }
                catch (Exception e) {
                    return "0";
                }
            }
            if (var.equalsIgnoreCase("score")) {
                try {
                    return Integer.toString(this.player.bv());
                }
                catch (Exception var12) {
                    return "0";
                }
            }
            if (var.equalsIgnoreCase("x")) {
                return String.format(Locale.ENGLISH, "%.1f", this.player.u);
            }
            if (var.equalsIgnoreCase("y")) {
                return String.format(Locale.ENGLISH, "%.1f", this.player.v);
            }
            if (var.equalsIgnoreCase("yfeet")) {
                return String.format(Locale.ENGLISH, "%.1f", this.player.E.b);
            }
            if (var.equalsIgnoreCase("z")) {
                return String.format(Locale.ENGLISH, "%.1f", this.player.w);
            }
            if (var.equalsIgnoreCase("xi")) {
                return Integer.toString(this.playerPosition[0]);
            }
            if (var.equalsIgnoreCase("yi")) {
                return Integer.toString(this.playerPosition[1]);
            }
            if (var.equalsIgnoreCase("yfeeti")) {
                return Integer.toString((int)Math.floor(this.player.E.b));
            }
            if (var.equalsIgnoreCase("zi")) {
                return Integer.toString(this.playerPosition[2]);
            }
            if (var.equalsIgnoreCase("roughdirection")) {
                return this.roughdirection[lr.c((double)((double)this.player.A * 4.0 / 360.0 + 0.5)) & 3];
            }
            if (var.equalsIgnoreCase("finedirection")) {
                return this.finedirection[lr.c((double)((double)this.player.A * 8.0 / 360.0 + 0.5)) & 7];
            }
            if (var.equalsIgnoreCase("abrroughdirection")) {
                return this.abrroughdirection[lr.c((double)((double)this.player.A * 4.0 / 360.0 + 0.5)) & 3];
            }
            if (var.equalsIgnoreCase("abrfinedirection")) {
                return this.abrfinedirection[lr.c((double)((double)this.player.A * 8.0 / 360.0 + 0.5)) & 7];
            }
            if (var.equalsIgnoreCase("directionhud")) {
                int direction = lr.c((double)((double)(this.player.A * 16.0f / 360.0f) + 0.5)) & 0xF;
                if (direction % 2 == 0) {
                    return "\u00a7r" + this.abrfinedirection[(direction / 2 + this.abrfinedirection.length - 1) % this.abrfinedirection.length] + "   \u00a7c" + this.abrfinedirection[(direction / 2 + this.abrfinedirection.length) % this.abrfinedirection.length] + "\u00a7r   " + this.abrfinedirection[(direction / 2 + this.abrfinedirection.length + 1) % this.abrfinedirection.length];
                }
                return "\u00a7r     " + this.abrfinedirection[(direction / 2 + this.abrfinedirection.length) % this.abrfinedirection.length] + "   " + this.abrfinedirection[(direction / 2 + this.abrfinedirection.length + 1) % this.abrfinedirection.length] + "   ";
            }
            if (var.equalsIgnoreCase("fps")) {
                return this.minecraftClient.E.substring(0, this.minecraftClient.E.indexOf(" fps"));
            }
            if (var.equalsIgnoreCase("mouseover")) {
                asx objectMouseOver = this.minecraftClient.t;
                if (objectMouseOver != null) {
                    aqw block;
                    if (objectMouseOver.a == asy.b) {
                        return objectMouseOver.g.am();
                    }
                    if (objectMouseOver.a == asy.a && (block = aqw.s[this.world.a(objectMouseOver.b, objectMouseOver.c, objectMouseOver.d)]) != null) {
                        return block.A();
                    }
                }
                return "";
            }
            if (var.equalsIgnoreCase("worldname")) {
                return this.world.N().k();
            }
            if (var.equalsIgnoreCase("worldsize")) {
                return Long.toString(this.world.N().h());
            }
            if (var.equalsIgnoreCase("worldsizemb")) {
                return String.format(Locale.ENGLISH, "%.1f", (double)this.world.N().h() / 1048576.0);
            }
            if (var.equalsIgnoreCase("seed")) {
                return Long.toString(this.seed);
            }
            if (var.equalsIgnoreCase("difficulty")) {
                return bt.a((String)this.difficulties[this.minecraftClient.u.Y]);
            }
            if (var.equalsIgnoreCase("difficultyid")) {
                return Integer.toString(this.minecraftClient.u.Y);
            }
            if (var.equalsIgnoreCase("gamemode")) {
                return bt.a((String)("selectWorld.gameMode." + this.world.N().r().b()));
            }
            if (var.equalsIgnoreCase("gamemodeid")) {
                return Integer.toString(this.world.N().r().a());
            }
            if (var.equalsIgnoreCase("healthpoints")) {
                return Float.toString(this.player.aM());
            }
            if (var.equalsIgnoreCase("armorpoints")) {
                return Integer.toString(this.player.aP());
            }
            if (var.equalsIgnoreCase("foodpoints")) {
                return Integer.toString(this.player.bH().a());
            }
            if (var.equalsIgnoreCase("foodsaturation")) {
                return Float.toString(this.player.bH().e());
            }
            if (var.equalsIgnoreCase("airticks")) {
                return Integer.toString(this.player.ak());
            }
            if (var.equalsIgnoreCase("playerlevel")) {
                return Integer.toString(this.player.bH);
            }
            if (var.equalsIgnoreCase("xpthislevel")) {
                return Integer.toString((int)Math.ceil(this.player.bJ * (float)this.player.bG()));
            }
            if (var.equalsIgnoreCase("xpuntilnext")) {
                return Integer.toString((int)Math.floor((1.0 - (double)this.player.bJ) * (double)this.player.bG()));
            }
            if (var.equalsIgnoreCase("xpcap")) {
                return Integer.toString(this.player.bG());
            }
            if (var.equalsIgnoreCase("dimension")) {
                return this.world.t.l();
            }
            if (var.equalsIgnoreCase("dimensionid")) {
                return Integer.toString(this.player.ar);
            }
            if (var.equalsIgnoreCase("biome")) {
                return this.world.a((int)this.playerPosition[0], (int)this.playerPosition[2]).y;
            }
            if (var.equalsIgnoreCase("biomeid")) {
                return Integer.toString(this.world.a((int)this.playerPosition[0], (int)this.playerPosition[2]).N);
            }
            if (var.equalsIgnoreCase("username")) {
                return this.player.am();
            }
            if (var.equalsIgnoreCase("texturepack") || var.equalsIgnoreCase("resourcepack")) {
                return this.minecraftClient.L().d();
            }
            if (var.equalsIgnoreCase("entitiesrendered")) {
                String str = this.minecraftClient.m();
                return str.substring(str.indexOf(32) + 1, str.indexOf(47));
            }
            if (var.equalsIgnoreCase("entitiestotal")) {
                String str = this.minecraftClient.m();
                return str.substring(str.indexOf(47) + 1, str.indexOf(46));
            }
            if (var.equalsIgnoreCase("daytime")) {
                return Boolean.toString(this.world.a(1.0f) < 4);
            }
            if (var.equalsIgnoreCase("raining")) {
                return Boolean.toString(this.world.i(1.0f) > 0.2f && this.world.a(this.playerPosition[0], this.playerPosition[2]).d());
            }
            if (var.equalsIgnoreCase("thundering")) {
                return Boolean.toString(this.world.N().n() && this.world.a(this.playerPosition[0], this.playerPosition[2]).d());
            }
            if (var.equalsIgnoreCase("snowing")) {
                acp biome = this.world.a(this.playerPosition[0], this.playerPosition[2]);
                return Boolean.toString(this.world.Q() && !biome.d() && !biome.equals(acp.d) && !biome.equals(acp.s));
            }
            if (var.equalsIgnoreCase("nextrain")) {
                if (this.minecraftServer == null) {
                    return "?";
                }
                int seconds = this.minecraftServer.b[0].N().q() / 20;
                if (seconds < 60) {
                    return String.format(Locale.ENGLISH, "%ds", seconds);
                }
                if (seconds < 3600) {
                    return String.format(Locale.ENGLISH, "%dm", seconds / 60);
                }
                return String.format(Locale.ENGLISH, "%dh", seconds / 3600);
            }
            if (var.equalsIgnoreCase("slimes")) {
                return Boolean.toString(this.isSlimeChunk(this.playerPosition[0] >> 4, this.playerPosition[2] >> 4) || this.world.a((int)this.playerPosition[0], (int)this.playerPosition[2]).N == acp.h.N);
            }
            if (var.equalsIgnoreCase("hardcore")) {
                return Boolean.toString(this.world.N().t());
            }
            if (var.equalsIgnoreCase("underwater") || var.equalsIgnoreCase("inwater")) {
                return Boolean.toString(this.player.G());
            }
            if (var.equalsIgnoreCase("wet")) {
                return Boolean.toString(this.player.F());
            }
            if (var.equalsIgnoreCase("alive")) {
                return Boolean.toString(this.player.S());
            }
            if (var.equalsIgnoreCase("burning")) {
                return Boolean.toString(this.player.ae());
            }
            if (var.equalsIgnoreCase("riding")) {
                return Boolean.toString(this.player.af());
            }
            if (var.equalsIgnoreCase("sneaking")) {
                return Boolean.toString(this.player.ag());
            }
            if (var.equalsIgnoreCase("sprinting")) {
                return Boolean.toString(this.player.ah());
            }
            if (var.equalsIgnoreCase("invisible")) {
                return Boolean.toString(this.player.ai());
            }
            if (var.equalsIgnoreCase("eating")) {
                return Boolean.toString(this.player.aj());
            }
            if (var.equalsIgnoreCase("invulnerable")) {
                return Boolean.toString(this.player.aq());
            }
            if (var.matches("(equipped|helmet|chestplate|leggings|boots)(name|maxdamage|damage|damageleft)")) {
                yd item;
                if (var.startsWith("equipped")) {
                    item = this.player.bx();
                } else {
                    int slot = -1;
                    if (var.startsWith("helmet")) {
                        slot = 3;
                    } else if (var.startsWith("chestplate")) {
                        slot = 2;
                    } else if (var.startsWith("leggings")) {
                        slot = 1;
                    } else if (var.startsWith("boots")) {
                        slot = 0;
                    }
                    item = this.player.bn.f(slot);
                }
                if (var.endsWith("name")) {
                    String arrows = item != null && item.d == yb.m.cv ? " (" + this.getItemCountInInventory(this.player, yb.n.cv, -1) + ")" : "";
                    return item != null ? item.s() + arrows : "";
                }
                if (var.endsWith("maxdamage")) {
                    return Integer.toString(item != null && item.g() ? item.l() + 1 : 0);
                }
                if (var.endsWith("damage")) {
                    return Integer.toString(item != null && item.g() ? item.k() : 0);
                }
                if (var.endsWith("damageleft")) {
                    return Integer.toString(item != null && item.g() ? item.l() + 1 - item.k() : 0);
                }
            } else {
                if (var.equalsIgnoreCase("equippedquantity")) {
                    yd item = this.player.bx();
                    if (item != null) {
                        return Integer.toString(this.getItemCountInInventory(this.player, item.d, item.k()));
                    }
                    return "0";
                }
                if (var.matches("potioneffect\\d+")) {
                    int index = Integer.parseInt(var.substring(12));
                    if (this.potionEffects.length > index) {
                        String str = bt.a((String)this.potionEffects[index].f());
                        switch (this.potionEffects[index].c()) {
                            case 1: {
                                str = str + " II";
                                break;
                            }
                            case 2: {
                                str = str + " III";
                                break;
                            }
                            case 3: {
                                str = str + " IV";
                            }
                        }
                        return str;
                    }
                    return "";
                }
                if (var.matches("potionduration\\d+")) {
                    int index = Integer.parseInt(var.substring(14));
                    if (this.potionEffects.length > index) {
                        int duration = this.potionEffects[index].b() / 20;
                        return String.format(Locale.ENGLISH, "%d:%02d", duration / 60, duration % 60);
                    }
                    return "0:00";
                }
                if (var.matches("potiondurationticks\\d+")) {
                    int index = Integer.parseInt(var.substring(19));
                    if (this.potionEffects.length > index) {
                        return Integer.toString(this.potionEffects[index].b());
                    }
                    return "0";
                }
                if (var.equalsIgnoreCase("memmax")) {
                    return Long.toString(Runtime.getRuntime().maxMemory());
                }
                if (var.equalsIgnoreCase("memtotal")) {
                    return Long.toString(Runtime.getRuntime().totalMemory());
                }
                if (var.equalsIgnoreCase("memfree")) {
                    return Long.toString(Runtime.getRuntime().freeMemory());
                }
                if (var.equalsIgnoreCase("memused")) {
                    return Long.toString(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
                }
            }
        }
        catch (Exception e) {
            return "null";
        }
        return "{" + var + "}";
    }

    private int getItemCountInInventory(ue entityPlayer, int itemID, int itemDamage) {
        if (entityPlayer.bn.e(itemID)) {
            int count = 0;
            yd itemStack = null;
            for (int i = 0; i < entityPlayer.bn.a.length; ++i) {
                itemStack = entityPlayer.bn.a[i];
                if (itemStack == null || itemStack.d != itemID || itemDamage != -1 && itemStack.k() != itemDamage) continue;
                count += itemStack.b;
            }
            return count;
        }
        return 0;
    }

    private boolean isSlimeChunk(int x, int z) {
        return this.seed != 0L && new Random(this.seed + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)(z * z * 4392871) + (long)(z * 389711) ^ 0x3AD8025FL).nextInt(10) == 0;
    }

    private void drawLeftAlignedString(avf fontRenderer, String str, int x, int y, int color) {
        fontRenderer.a(str, x, y, color);
    }

    private void drawCenteredString(avf fontRenderer, String str, int x, int y, int color) {
        fontRenderer.a(str, x - fontRenderer.a(str.replaceAll("(?i)\u00a7[0-9a-fklmnor]", "")) / 2, y, color);
    }

    private void drawRightAlignedString(avf fontRenderer, String str, int x, int y, int color) {
        fontRenderer.a(str, x - fontRenderer.a(str.replaceAll("(?i)\u00a7[0-9a-fklmnor]", "")), y, color);
    }
}

