/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica.renderer;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import lunatrius.schematica.SchematicWorld;
import lunatrius.schematica.Settings;
import lunatrius.schematica.renderer.RenderHelper;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class RendererSchematicChunk {
    public static final int CHUNK_WIDTH = 16;
    public static final int CHUNK_HEIGHT = 16;
    public static final int CHUNK_LENGTH = 16;
    private static boolean canUpdate = false;
    public boolean isInFrustrum = false;
    public final Vector3f centerPosition = new Vector3f();
    private final Settings settings = Settings.instance();
    private final ats minecraft;
    private final lu profiler;
    private final SchematicWorld schematic;
    private final List<asm> tileEntities;
    private final asu boundingBox;
    private static final Map<String, bjl> resourcePacks = new HashMap<String, bjl>();
    private Field fieldMapTexturesStiched;
    private boolean needsUpdate;
    private int glList;

    public RendererSchematicChunk(SchematicWorld schematicWorld, int baseX, int baseY, int baseZ) {
        this.minecraft = this.settings.minecraft;
        this.profiler = this.minecraft.C;
        this.tileEntities = new ArrayList<asm>();
        this.boundingBox = asu.a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.needsUpdate = true;
        this.glList = -1;
        this.schematic = schematicWorld;
        this.boundingBox.b((double)(baseX * 16), (double)(baseY * 16), (double)(baseZ * 16), (double)((baseX + 1) * 16), (double)((baseY + 1) * 16), (double)((baseZ + 1) * 16));
        this.centerPosition.x = (int)(((double)baseX + 0.5) * 16.0);
        this.centerPosition.y = (int)(((double)baseY + 0.5) * 16.0);
        this.centerPosition.z = (int)(((double)baseZ + 0.5) * 16.0);
        for (asm tileEntity : this.schematic.getTileEntities()) {
            int x = tileEntity.l;
            int y = tileEntity.m;
            int z = tileEntity.n;
            if ((double)x < this.boundingBox.a || (double)x >= this.boundingBox.d || (double)z < this.boundingBox.c || (double)z >= this.boundingBox.f || (double)y < this.boundingBox.b || (double)y >= this.boundingBox.e) continue;
            this.tileEntities.add(tileEntity);
        }
        this.glList = GL11.glGenLists((int)3);
        try {
            this.fieldMapTexturesStiched = ReflectionHelper.findField(bih.class, (String[])new String[]{"f", "field_94252_e", "mapTexturesStiched"});
        }
        catch (Exception ex2) {
            Settings.logger.c("Failed to initialize mapTexturesStiched!", (Throwable)ex2);
            this.fieldMapTexturesStiched = null;
        }
    }

    public void delete() {
        GL11.glDeleteLists((int)this.glList, (int)3);
    }

    public asu getBoundingBox() {
        return this.boundingBox;
    }

    public static void setCanUpdate(boolean parCanUpdate) {
        canUpdate = parCanUpdate;
    }

    public static boolean getCanUpdate() {
        return canUpdate;
    }

    public void setDirty() {
        this.needsUpdate = true;
    }

    public boolean getDirty() {
        return this.needsUpdate;
    }

    public float distanceToPoint(Vector3f vector) {
        float x = vector.x - this.centerPosition.x;
        float y = vector.y - this.centerPosition.y;
        float z = vector.z - this.centerPosition.z;
        return x * x + y * y + z * z;
    }

    public void updateRenderer() {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            RendererSchematicChunk.setCanUpdate(false);
            RenderHelper.createBuffers();
            for (int pass = 0; pass < 3; ++pass) {
                RenderHelper.initBuffers();
                int minX = (int)this.boundingBox.a;
                int maxX = Math.min((int)this.boundingBox.d, this.schematic.width());
                int minY = (int)this.boundingBox.b;
                int maxY = Math.min((int)this.boundingBox.e, this.schematic.height());
                int minZ = (int)this.boundingBox.c;
                int maxZ = Math.min((int)this.boundingBox.f, this.schematic.length());
                if (this.settings.renderingLayer >= 0) {
                    if (this.settings.renderingLayer >= minY && this.settings.renderingLayer < maxY) {
                        minY = this.settings.renderingLayer;
                        maxY = this.settings.renderingLayer + 1;
                    } else {
                        maxY = 0;
                        minY = 0;
                    }
                }
                GL11.glNewList((int)(this.glList + pass), (int)4864);
                this.renderBlocks(pass, minX, minY, minZ, maxX, maxY, maxZ);
                int quadCount = RenderHelper.getQuadCount();
                int lineCount = RenderHelper.getLineCount();
                if (quadCount > 0 || lineCount > 0) {
                    GL11.glDisable((int)3553);
                    GL11.glLineWidth((float)1.5f);
                    GL11.glEnableClientState((int)32884);
                    GL11.glEnableClientState((int)32886);
                    if (quadCount > 0) {
                        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getQuadVertexBuffer());
                        GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getQuadColorBuffer());
                        GL11.glDrawArrays((int)7, (int)0, (int)quadCount);
                    }
                    if (lineCount > 0) {
                        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getLineVertexBuffer());
                        GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getLineColorBuffer());
                        GL11.glDrawArrays((int)1, (int)0, (int)lineCount);
                    }
                    GL11.glDisableClientState((int)32886);
                    GL11.glDisableClientState((int)32884);
                    GL11.glEnable((int)3553);
                }
                GL11.glEndList();
            }
            RenderHelper.destroyBuffers();
        }
    }

    public void render(int renderPass) {
        if (!this.isInFrustrum) {
            return;
        }
        this.profiler.a("blocks");
        this.bindTexture();
        GL11.glCallList((int)(this.glList + renderPass));
        this.profiler.c("tileEntities");
        this.renderTileEntities(renderPass);
        this.profiler.b();
    }

    public void renderBlocks(int renderPass, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        ack mcWorld = this.settings.mcWorldCache;
        bfo renderBlocks = this.settings.renderBlocks;
        Vector3f zero = new Vector3f();
        Vector3f size = new Vector3f();
        int ambientOcclusion = this.minecraft.u.k;
        this.minecraft.u.k = 0;
        bfn.a.b();
        for (int y = minY; y < maxY; ++y) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int x = minX; x < maxX; ++x) {
                    try {
                        int blockId = this.schematic.a(x, y, z);
                        aqw block = aqw.s[blockId];
                        int mcBlockId = mcWorld.a(x + (int)this.settings.offset.x, y + (int)this.settings.offset.y, z + (int)this.settings.offset.z);
                        int sides = 0;
                        if (block != null) {
                            if (block.a((ace)this.schematic, x, y - 1, z, 0)) {
                                sides |= 1;
                            }
                            if (block.a((ace)this.schematic, x, y + 1, z, 1)) {
                                sides |= 2;
                            }
                            if (block.a((ace)this.schematic, x, y, z - 1, 2)) {
                                sides |= 4;
                            }
                            if (block.a((ace)this.schematic, x, y, z + 1, 3)) {
                                sides |= 8;
                            }
                            if (block.a((ace)this.schematic, x - 1, y, z, 4)) {
                                sides |= 0x10;
                            }
                            if (block.a((ace)this.schematic, x + 1, y, z, 5)) {
                                sides |= 0x20;
                            }
                        }
                        if (mcBlockId != 0) {
                            if (!this.settings.highlight || renderPass != 2) continue;
                            if (blockId == 0 && this.settings.highlightAir) {
                                zero.set((float)x, (float)y, (float)z);
                                size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                                if (this.settings.drawQuads) {
                                    RenderHelper.drawCuboidSurface(zero, size, 63, 0.75f, 0.0f, 0.75f, 0.25f);
                                }
                                if (!this.settings.drawLines) continue;
                                RenderHelper.drawCuboidOutline(zero, size, 63, 0.75f, 0.0f, 0.75f, 0.25f);
                                continue;
                            }
                            if (blockId != mcBlockId) {
                                zero.set((float)x, (float)y, (float)z);
                                size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                                if (this.settings.drawQuads) {
                                    RenderHelper.drawCuboidSurface(zero, size, sides, 1.0f, 0.0f, 0.0f, 0.25f);
                                }
                                if (!this.settings.drawLines) continue;
                                RenderHelper.drawCuboidOutline(zero, size, sides, 1.0f, 0.0f, 0.0f, 0.25f);
                                continue;
                            }
                            if (this.schematic.h(x, y, z) == mcWorld.h(x + (int)this.settings.offset.x, y + (int)this.settings.offset.y, z + (int)this.settings.offset.z)) continue;
                            zero.set((float)x, (float)y, (float)z);
                            size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                            if (this.settings.drawQuads) {
                                RenderHelper.drawCuboidSurface(zero, size, sides, 0.75f, 0.35f, 0.0f, 0.25f);
                            }
                            if (!this.settings.drawLines) continue;
                            RenderHelper.drawCuboidOutline(zero, size, sides, 0.75f, 0.35f, 0.0f, 0.25f);
                            continue;
                        }
                        if (mcBlockId != 0 || blockId <= 0 || blockId >= 4096) continue;
                        if (this.settings.highlight && renderPass == 2) {
                            zero.set((float)x, (float)y, (float)z);
                            size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                            if (this.settings.drawQuads) {
                                RenderHelper.drawCuboidSurface(zero, size, sides, 0.0f, 0.75f, 1.0f, 0.25f);
                            }
                            if (this.settings.drawLines) {
                                RenderHelper.drawCuboidOutline(zero, size, sides, 0.0f, 0.75f, 1.0f, 0.25f);
                            }
                        }
                        if (block == null || !block.canRenderInPass(renderPass)) continue;
                        renderBlocks.b(block, x, y, z);
                        continue;
                    }
                    catch (Exception e) {
                        Settings.logger.c("Failed to render block!", (Throwable)e);
                    }
                }
            }
        }
        bfn.a.a();
        this.minecraft.u.k = ambientOcclusion;
    }

    public void renderTileEntities(int renderPass) {
        if (renderPass != 0) {
            return;
        }
        ack mcWorld = this.settings.mcWorldCache;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.settings.alpha);
        try {
            for (asm tileEntity : this.tileEntities) {
                bjb tileEntitySpecialRenderer;
                int mcBlockId;
                int x = tileEntity.l;
                int y = tileEntity.m;
                int z = tileEntity.n;
                if (this.settings.renderingLayer >= 0 && y != this.settings.renderingLayer || (mcBlockId = mcWorld.a(x + (int)this.settings.offset.x, y + (int)this.settings.offset.y, z + (int)this.settings.offset.z)) != 0 || (tileEntitySpecialRenderer = bja.a.b(tileEntity)) == null) continue;
                try {
                    tileEntitySpecialRenderer.a(tileEntity, (double)x, (double)y, (double)z, 0.0f);
                    blx.a((int)blx.b);
                    GL11.glDisable((int)3553);
                    blx.a((int)blx.a);
                }
                catch (Exception e) {
                    Settings.logger.c("Failed to render a tile entity!", (Throwable)e);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.settings.alpha);
            }
        }
        catch (Exception ex2) {
            Settings.logger.c("Failed to render tile entities!", (Throwable)ex2);
        }
    }

    private void bindTexture() {
        if (!this.settings.enableAlpha) {
            this.minecraft.N.a(bih.b);
            return;
        }
        String resourcePackName = this.minecraft.L().d();
        if (!resourcePacks.containsKey(resourcePackName)) {
            String texturePackFileName = resourcePackName.replaceAll("(?i)[^a-z0-9]", "_") + "-" + (int)(this.settings.alpha * 255.0f) + ".png";
            try {
                File outputfile = new File("assets/" + texturePackFileName);
                bjm manager = this.minecraft.K();
                mr icon = aqw.A.a(0, 0);
                float deltaU = icon.d() - icon.c();
                float deltaV = icon.f() - icon.e();
                int width = (int)Math.pow(2.0, Math.round(Math.log((float)icon.a() / deltaU) / Math.log(2.0)));
                int height = (int)Math.pow(2.0, Math.round(Math.log((float)icon.b() / deltaV) / Math.log(2.0)));
                BufferedImage bufferedImage = new BufferedImage(width, height, 2);
                Map map = (Map)this.fieldMapTexturesStiched.get(this.minecraft.N.b(bih.b));
                if (map == null) {
                    Settings.logger.c("mapTexturesStiched is null!");
                    resourcePacks.put(resourcePackName, bih.b);
                    return;
                }
                Collection sprites = map.values();
                for (bii sprite : sprites) {
                    bjl resourcelocation = new bjl(ForgeHooksClient.fixDomain((String)"textures/blocks/", (String)sprite.g()) + ".png");
                    try {
                        sprite.load(manager, resourcelocation);
                    }
                    catch (RuntimeException ignored) {
                    }
                    catch (IOException ignored) {}
                }
                for (bii sprite : sprites) {
                    if (sprite.k() == 0) continue;
                    int[] data = sprite.a(0);
                    int offsetX = sprite.h();
                    int offsetY = sprite.i();
                    int index = 0;
                    for (int y = 0; y < sprite.b(); ++y) {
                        for (int x = 0; x < sprite.a(); ++x) {
                            int color = data[index++];
                            int alpha = color >> 24 & 0xFF;
                            alpha = (int)((float)alpha * this.settings.alpha);
                            color = color & 0xFFFFFF | alpha << 24;
                            bufferedImage.setRGB(offsetX + x, offsetY + y, color);
                        }
                    }
                }
                ImageIO.write((RenderedImage)bufferedImage, "png", outputfile);
                for (bii sprite : sprites) {
                    if (sprite.m()) continue;
                    sprite.l();
                }
                resourcePacks.put(resourcePackName, new bjl(texturePackFileName));
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        if (resourcePacks.containsKey(resourcePackName)) {
            this.minecraft.N.a(resourcePacks.get(resourcePackName));
        }
    }
}

