/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lunatrius.schematica.FileFilterSchematic;
import lunatrius.schematica.Settings;
import lunatrius.schematica.gui.GuiSchematicEntry;
import lunatrius.schematica.gui.GuiSchematicLoadSlot;
import org.lwjgl.Sys;

public class GuiSchematicLoad
extends awb {
    private static final FileFilterSchematic FILE_FILTER_FOLDER = new FileFilterSchematic(true);
    private static final FileFilterSchematic FILE_FILTER_SCHEMATIC = new FileFilterSchematic(false);
    private final Settings settings = Settings.instance();
    private final awb prevGuiScreen;
    private GuiSchematicLoadSlot guiSchematicLoadSlot;
    private awi btnOpenDir = null;
    private awi btnDone = null;
    private final String strTitle = bt.a((String)"schematic.title");
    private final String strFolderInfo = bt.a((String)"schematic.folderInfo");
    protected File currentDirectory = Settings.schematicDirectory;
    protected final List<GuiSchematicEntry> schematicFiles = new ArrayList<GuiSchematicEntry>();

    public GuiSchematicLoad(awb guiScreen) {
        this.prevGuiScreen = guiScreen;
    }

    public void A_() {
        int id = 0;
        this.btnOpenDir = new awi(id++, this.g / 2 - 154, this.h - 36, bt.a((String)"schematic.openFolder"));
        this.i.add(this.btnOpenDir);
        this.btnDone = new awi(id++, this.g / 2 + 4, this.h - 36, bt.a((String)"schematic.done"));
        this.i.add(this.btnDone);
        this.guiSchematicLoadSlot = new GuiSchematicLoadSlot(this);
        this.reloadSchematics();
    }

    protected void a(auq guiButton) {
        if (guiButton.h) {
            if (guiButton.g == this.btnOpenDir.g) {
                boolean success = false;
                try {
                    Class<?> c = Class.forName("java.awt.Desktop");
                    Object m = c.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
                    c.getMethod("browse", URI.class).invoke(m, Settings.schematicDirectory.toURI());
                }
                catch (Throwable e) {
                    success = true;
                }
                if (success) {
                    Settings.logger.a("Opening via Sys class!");
                    Sys.openURL((String)("file://" + Settings.schematicDirectory.getAbsolutePath()));
                }
            } else if (guiButton.g == this.btnDone.g) {
                this.loadSchematic();
                this.f.a(this.prevGuiScreen);
            } else {
                this.guiSchematicLoadSlot.a(guiButton);
            }
        }
    }

    public void a(int x, int y, float partialTicks) {
        this.guiSchematicLoadSlot.a(x, y, partialTicks);
        this.a(this.o, this.strTitle, this.g / 2, 4, 0xFFFFFF);
        this.a(this.o, this.strFolderInfo, this.g / 2 - 78, this.h - 12, 0x808080);
        super.a(x, y, partialTicks);
    }

    public void b() {
    }

    protected void changeDirectory(String directory) {
        this.currentDirectory = new File(this.currentDirectory, directory);
        this.reloadSchematics();
    }

    protected void reloadSchematics() {
        String name = null;
        int itemID = -1;
        this.schematicFiles.clear();
        try {
            if (!this.currentDirectory.getCanonicalPath().equals(Settings.schematicDirectory.getCanonicalPath())) {
                this.schematicFiles.add(new GuiSchematicEntry("..", 327, 0, true));
            }
        }
        catch (IOException e) {
            Settings.logger.c("Failed to add GuiSchematicEntry!", (Throwable)e);
        }
        for (File file : this.currentDirectory.listFiles(FILE_FILTER_FOLDER)) {
            name = file.getName();
            itemID = file.listFiles().length == 0 ? 325 : 326;
            this.schematicFiles.add(new GuiSchematicEntry(name, itemID, 0, file.isDirectory()));
        }
        File[] files = this.currentDirectory.listFiles(FILE_FILTER_SCHEMATIC);
        if (files.length == 0) {
            this.schematicFiles.add(new GuiSchematicEntry(bt.a((String)"schematic.noschematic"), 3, 0, false));
        } else {
            for (File file : files) {
                name = file.getName();
                this.schematicFiles.add(new GuiSchematicEntry(name, this.readSchematicIcon(file.getAbsolutePath()), file.isDirectory()));
            }
        }
    }

    private yd readSchematicIcon(String filename) {
        try {
            FileInputStream stream = new FileInputStream(filename);
            bx tagCompound = ch.a((InputStream)stream);
            if (tagCompound != null && tagCompound.b("Icon")) {
                yd itemStack = Settings.defaultIcon.m();
                itemStack.c(tagCompound.l("Icon"));
                return itemStack;
            }
        }
        catch (Exception e) {
            Settings.logger.c("Failed to read schematic icon!", (Throwable)e);
        }
        return Settings.defaultIcon.m();
    }

    private void loadSchematic() {
        int selectedIndex = this.guiSchematicLoadSlot.selectedIndex;
        try {
            if (selectedIndex >= 0 && selectedIndex < this.schematicFiles.size()) {
                GuiSchematicEntry schematic = this.schematicFiles.get(selectedIndex);
                this.settings.loadSchematic(new File(this.currentDirectory, schematic.getName()).getCanonicalPath());
            }
        }
        catch (Exception e) {
            Settings.logger.c("Failed to load schematic!", (Throwable)e);
        }
        this.settings.moveHere();
    }
}

