/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lunatrius.schematica.BlockInfo;
import lunatrius.schematica.ChatEventHandler;
import lunatrius.schematica.FileFilterConfiguration;
import lunatrius.schematica.KeyBindingHandler;
import lunatrius.schematica.SchematicPrinter;
import lunatrius.schematica.SchematicWorld;
import lunatrius.schematica.Settings;
import lunatrius.schematica.Ticker;
import lunatrius.schematica.renderer.RendererSchematicChunk;
import lunatrius.schematica.renderer.RendererSchematicGlobal;
import lunatrius.schematica.util.Config;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Schematica")
public class Schematica {
    private static final FileFilterConfiguration FILE_FILTER_CONFIGURATION = new FileFilterConfiguration();
    private static final String DIR_ASSETS = "lunatrius/schematica/assets/";
    private final Settings settings = Settings.instance();
    private final lu profiler;
    private final SchematicPrinter printer;
    private int ticks;
    @Mod.Instance(value="Schematica")
    public static Schematica instance;
    private Field sortedWorldRenderers;
    private File configurationFolder;

    public Schematica() {
        this.profiler = this.settings.minecraft.C;
        this.printer = new SchematicPrinter();
        this.ticks = -1;
        this.sortedWorldRenderers = null;
        this.configurationFolder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File suggestedConfigurationFile = event.getSuggestedConfigurationFile();
        Configuration config = new Configuration(suggestedConfigurationFile);
        this.configurationFolder = suggestedConfigurationFile.getParentFile();
        config.load();
        this.settings.enableAlpha = Config.getBoolean(config, "general", "alphaEnabled", this.settings.enableAlpha, "Enable transparent textures.");
        this.settings.alpha = (float)Config.getInt(config, "general", "alpha", (int)(this.settings.alpha * 255.0f), 0, 255, "Alpha value used when rendering the schematic.") / 255.0f;
        this.settings.highlight = Config.getBoolean(config, "general", "highlight", this.settings.highlight, "Highlight invalid placed blocks and to be placed blocks.");
        this.settings.highlightAir = Config.getBoolean(config, "general", "highlightAir", this.settings.highlightAir, "Highlight invalid placed blocks (where there should be no block).");
        this.settings.blockDelta = (float)Config.getDouble(config, "general", "blockDelta", this.settings.blockDelta, 0.0, 0.5, "Delta value used for highlighting (if you're having issue with overlapping textures try setting this value higher).");
        this.settings.placeDelay = Config.getInt(config, "general", "placeDelay", this.settings.placeDelay, 0, 20, "Delay in ticks between placement attempts.");
        this.settings.placeInstantly = Config.getBoolean(config, "general", "placeInstantly", this.settings.placeInstantly, "Place all blocks that can be placed in one tick.");
        this.settings.placeAdjacent = Config.getBoolean(config, "general", "placeAdjacent", this.settings.placeAdjacent, "Place blocks only if there is an adjacent block next to it.");
        this.settings.drawQuads = Config.getBoolean(config, "general", "drawQuads", this.settings.drawQuads, "Draw surface areas.");
        this.settings.drawLines = Config.getBoolean(config, "general", "drawLines", this.settings.drawLines, "Draw outlines.");
        config.save();
        try {
            String langDir = "lunatrius/schematica/assets/lang/";
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream stream = classLoader.getResourceAsStream(langDir + "lang.txt");
            BufferedReader input = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            try {
                String lang = "";
                while ((lang = input.readLine()) != null) {
                    if (lang.length() <= 0) continue;
                    Settings.logger.a("Loading language file: " + lang);
                    LanguageRegistry.instance().loadLocalization(classLoader.getResource(langDir + lang + ".xml"), lang, true);
                }
            }
            finally {
                input.close();
            }
        }
        catch (Exception e) {
            Settings.logger.c("Could not load language files - corrupted installation detected!", (Throwable)e);
            throw new RuntimeException(e);
        }
        List<Integer> blockListIgnoreID = SchematicWorld.blockListIgnoreID;
        blockListIgnoreID.add(aqw.af.cF);
        blockListIgnoreID.add(aqw.ah.cF);
        blockListIgnoreID.add(aqw.bj.cF);
        blockListIgnoreID.add(aqw.bM.cF);
        List<Integer> blockListIgnoreMetadata = SchematicWorld.blockListIgnoreMetadata;
        blockListIgnoreMetadata.add(aqw.F.cF);
        blockListIgnoreMetadata.add(aqw.G.cF);
        blockListIgnoreMetadata.add(aqw.H.cF);
        blockListIgnoreMetadata.add(aqw.I.cF);
        blockListIgnoreMetadata.add(aqw.U.cF);
        blockListIgnoreMetadata.add(aqw.X.cF);
        blockListIgnoreMetadata.add(aqw.Y.cF);
        blockListIgnoreMetadata.add(aqw.Z.cF);
        blockListIgnoreMetadata.add(aqw.aa.cF);
        blockListIgnoreMetadata.add(aqw.ae.cF);
        blockListIgnoreMetadata.add(aqw.ap.cF);
        blockListIgnoreMetadata.add(aqw.av.cF);
        blockListIgnoreMetadata.add(aqw.ay.cF);
        blockListIgnoreMetadata.add(aqw.az.cF);
        blockListIgnoreMetadata.add(aqw.aA.cF);
        blockListIgnoreMetadata.add(aqw.aE.cF);
        blockListIgnoreMetadata.add(aqw.aF.cF);
        blockListIgnoreMetadata.add(aqw.aG.cF);
        blockListIgnoreMetadata.add(aqw.aH.cF);
        blockListIgnoreMetadata.add(aqw.aI.cF);
        blockListIgnoreMetadata.add(aqw.aJ.cF);
        blockListIgnoreMetadata.add(aqw.aK.cF);
        blockListIgnoreMetadata.add(aqw.aL.cF);
        blockListIgnoreMetadata.add(aqw.aM.cF);
        blockListIgnoreMetadata.add(aqw.aN.cF);
        blockListIgnoreMetadata.add(aqw.aO.cF);
        blockListIgnoreMetadata.add(aqw.aP.cF);
        blockListIgnoreMetadata.add(aqw.aQ.cF);
        blockListIgnoreMetadata.add(aqw.aR.cF);
        blockListIgnoreMetadata.add(aqw.aU.cF);
        blockListIgnoreMetadata.add(aqw.aV.cF);
        blockListIgnoreMetadata.add(aqw.aW.cF);
        blockListIgnoreMetadata.add(aqw.bf.cF);
        blockListIgnoreMetadata.add(aqw.bj.cF);
        blockListIgnoreMetadata.add(aqw.bk.cF);
        blockListIgnoreMetadata.add(aqw.bl.cF);
        blockListIgnoreMetadata.add(aqw.bm.cF);
        blockListIgnoreMetadata.add(aqw.bn.cF);
        blockListIgnoreMetadata.add(aqw.bp.cF);
        blockListIgnoreMetadata.add(aqw.bz.cF);
        blockListIgnoreMetadata.add(aqw.bA.cF);
        blockListIgnoreMetadata.add(aqw.bB.cF);
        blockListIgnoreMetadata.add(aqw.bC.cF);
        blockListIgnoreMetadata.add(aqw.bE.cF);
        blockListIgnoreMetadata.add(aqw.bH.cF);
        blockListIgnoreMetadata.add(aqw.bI.cF);
        blockListIgnoreMetadata.add(aqw.bN.cF);
        blockListIgnoreMetadata.add(aqw.bQ.cF);
        blockListIgnoreMetadata.add(aqw.bR.cF);
        blockListIgnoreMetadata.add(aqw.bT.cF);
        blockListIgnoreMetadata.add(aqw.bV.cF);
        blockListIgnoreMetadata.add(aqw.bX.cF);
        blockListIgnoreMetadata.add(aqw.bY.cF);
        blockListIgnoreMetadata.add(aqw.bZ.cF);
        blockListIgnoreMetadata.add(aqw.cb.cF);
        blockListIgnoreMetadata.add(aqw.cc.cF);
        blockListIgnoreMetadata.add(aqw.cd.cF);
        blockListIgnoreMetadata.add(aqw.ch.cF);
        blockListIgnoreMetadata.add(aqw.ci.cF);
        blockListIgnoreMetadata.add(aqw.cj.cF);
        blockListIgnoreMetadata.add(aqw.ck.cF);
        blockListIgnoreMetadata.add(aqw.cm.cF);
        Map<Integer, Integer> blockListMapping = SchematicWorld.blockListMapping;
        blockListMapping.put(aqw.F.cF, yb.az.cv);
        blockListMapping.put(aqw.G.cF, yb.az.cv);
        blockListMapping.put(aqw.H.cF, yb.aA.cv);
        blockListMapping.put(aqw.I.cF, yb.aA.cv);
        blockListMapping.put(aqw.X.cF, yb.bc.cv);
        blockListMapping.put(aqw.aA.cF, yb.aE.cv);
        blockListMapping.put(aqw.aE.cF, yb.U.cv);
        blockListMapping.put(aqw.aH.cF, aqw.aG.cF);
        blockListMapping.put(aqw.aI.cF, yb.aw.cv);
        blockListMapping.put(aqw.aJ.cF, yb.ax.cv);
        blockListMapping.put(aqw.aQ.cF, yb.aD.cv);
        blockListMapping.put(aqw.aN.cF, yb.aw.cv);
        blockListMapping.put(aqw.aU.cF, aqw.aV.cF);
        blockListMapping.put(aqw.bm.cF, yb.bd.cv);
        blockListMapping.put(aqw.bn.cF, yb.bd.cv);
        blockListMapping.put(aqw.bx.cF, yb.bi.cv);
        blockListMapping.put(aqw.by.cF, yb.bj.cv);
        blockListMapping.put(aqw.bI.cF, yb.bt.cv);
        blockListMapping.put(aqw.bK.cF, yb.bA.cv);
        blockListMapping.put(aqw.bL.cF, yb.bB.cv);
        blockListMapping.put(aqw.bR.cF, aqw.bQ.cF);
        blockListMapping.put(aqw.bU.cF, yb.aY.cv);
        blockListMapping.put(aqw.bZ.cF, yb.M.cv);
        blockListMapping.put(aqw.ch.cF, yb.bL.cv);
        blockListMapping.put(aqw.ci.cF, yb.bM.cv);
        blockListMapping.put(aqw.cj.cF, yb.bN.cv);
        blockListMapping.put(aqw.cl.cF, yb.bS.cv);
        if (!Settings.schematicDirectory.exists() && !Settings.schematicDirectory.mkdirs()) {
            Settings.logger.a("Could not create schematic directory!");
        }
        if (!Settings.textureDirectory.exists() && !Settings.textureDirectory.mkdirs()) {
            Settings.logger.a("Could not create texture directory!");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        try {
            MinecraftForge.EVENT_BUS.register((Object)new RendererSchematicGlobal());
            MinecraftForge.EVENT_BUS.register((Object)new ChatEventHandler());
            KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyBindingHandler(this.settings.keyBindings, new boolean[this.settings.keyBindings.length]));
            TickRegistry.registerTickHandler((ITickHandler)new Ticker(EnumSet.of(TickType.CLIENT)), (Side)Side.CLIENT);
            this.sortedWorldRenderers = ReflectionHelper.findField(bfi.class, (String[])new String[]{"n", "field_72768_k", "sortedWorldRenderers"});
        }
        catch (Exception e) {
            Settings.logger.c("Could not initialize the mod!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        File[] configurationFiles;
        String[] files = new String[]{"aliasVanilla", "flipVanilla", "rotationVanilla"};
        String mappingDir = "lunatrius/schematica/assets/mapping/";
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (String filename : files) {
            this.loadConfigurationFile(classLoader.getResource(mappingDir + filename + ".properties"), filename + ".properties");
        }
        for (File configurationFile : configurationFiles = this.configurationFolder.listFiles(FILE_FILTER_CONFIGURATION)) {
            try {
                this.loadConfigurationFile(configurationFile.toURI().toURL(), configurationFile.getName());
            }
            catch (MalformedURLException e) {
                Settings.logger.c("Could not load properties file.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigurationFile(URL configurationFile, String configurationFilename) {
        if (configurationFile == null) {
            Settings.logger.a("Skipping " + configurationFilename + "...");
            return;
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        Settings.logger.a("Reading " + configurationFilename + "...");
        try {
            inputStream = configurationFile.openStream();
            properties.load(inputStream);
        }
        catch (IOException e) {
            Settings.logger.c("Could not load properties file.", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Settings.logger.c("Could not close properties file.", (Throwable)e);
            }
        }
        String filename = configurationFilename.toLowerCase();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (filename.startsWith("alias")) {
                if (BlockInfo.addMappingAlias(key, value)) continue;
                Settings.logger.b("Failed alias: " + key + " => " + value);
                continue;
            }
            if (filename.startsWith("flip")) {
                if (BlockInfo.addMappingFlip(key, value)) continue;
                Settings.logger.b("Failed flip: " + key + " => " + value);
                continue;
            }
            if (!filename.startsWith("rotation") || BlockInfo.addMappingRotation(key, value)) continue;
            Settings.logger.b("Failed rotation: " + key + " => " + value);
        }
    }

    public void keyboardEvent(atp keyBinding, boolean down) {
        if (down) {
            this.settings.keyboardEvent(keyBinding);
        }
    }

    public boolean onTick(TickType tick, boolean start) {
        if (start) {
            return true;
        }
        this.profiler.a("schematica");
        if (tick == TickType.CLIENT && this.settings.minecraft.h != null && this.settings.isRenderingSchematic && this.settings.schematic != null) {
            this.profiler.a("printer");
            if (this.settings.isPrinterEnabled && this.settings.isPrinting && this.ticks-- < 0) {
                this.ticks = this.settings.placeDelay;
                this.printer.print();
            }
            this.profiler.c("checkDirty");
            this.checkDirty();
            this.profiler.c("canUpdate");
            RendererSchematicChunk.setCanUpdate(true);
            this.profiler.b();
        } else if (tick == TickType.CLIENT && this.settings.minecraft.h == null) {
            this.settings.chatLines = 0;
            this.settings.isPrinterEnabled = true;
            this.settings.isRenderingSchematic = false;
            this.settings.isRenderingGuide = false;
            this.settings.schematic = null;
            this.settings.mcWorldCache = null;
        }
        this.profiler.b();
        return true;
    }

    private void checkDirty() {
        if (this.sortedWorldRenderers != null) {
            try {
                bex[] renderers = (bex[])this.sortedWorldRenderers.get(this.settings.minecraft.g);
                if (renderers != null) {
                    int count = 0;
                    for (bex worldRenderer : renderers) {
                        if (!worldRenderer.q || count++ >= 125) continue;
                        asu worldRendererBoundingBox = worldRenderer.r.c((double)(-this.settings.offset.x), (double)(-this.settings.offset.y), (double)(-this.settings.offset.z));
                        for (RendererSchematicChunk renderer : this.settings.sortedRendererSchematicChunk) {
                            if (renderer.getDirty() || !renderer.getBoundingBox().b(worldRendererBoundingBox)) continue;
                            renderer.setDirty();
                        }
                    }
                }
            }
            catch (Exception e) {
                Settings.logger.c("Dirty check failed!", (Throwable)e);
            }
        }
    }
}

