/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lunatrius.schematica.BlockInfo;
import lunatrius.schematica.Settings;
import org.lwjgl.util.vector.Vector3f;

public class SchematicWorld
extends abv {
    private static final alj anvilSaveHandler = new alj(ats.w().x, "mods/saves-schematica-dummy", false);
    private static final acc worldSettings = new acc(0L, acd.c, false, false, acf.c);
    private static final Comparator<yd> blockListComparator = new Comparator<yd>(){

        @Override
        public int compare(yd itemStackA, yd itemStackB) {
            return itemStackA.d * 16 + itemStackA.k() - (itemStackB.d * 16 + itemStackB.k());
        }
    };
    protected static final List<Integer> blockListIgnoreID = new ArrayList<Integer>();
    protected static final List<Integer> blockListIgnoreMetadata = new ArrayList<Integer>();
    protected static final Map<Integer, Integer> blockListMapping = new HashMap<Integer, Integer>();
    private final Settings settings = Settings.instance();
    private yd icon;
    private int[][][] blocks = null;
    private int[][][] metadata = null;
    private final List<asm> tileEntities = new ArrayList<asm>();
    private final List<yd> blockList = new ArrayList<yd>();
    private short width;
    private short length;
    private short height;

    public SchematicWorld() {
        super((alz)anvilSaveHandler, "", null, worldSettings, null, null);
        this.icon = Settings.defaultIcon.m();
        this.tileEntities.clear();
        this.width = 0;
        this.length = 0;
        this.height = 0;
    }

    public SchematicWorld(String icon, int[][][] blocks, int[][][] metadata, List<asm> tileEntities, short width, short height, short length) {
        this();
        try {
            String[] parts = icon.split(":");
            if (parts.length == 1) {
                this.icon = new yd(Integer.parseInt(parts[0]), 1, 0);
            } else if (parts.length == 2) {
                this.icon = new yd(Integer.parseInt(parts[0]), 1, Integer.parseInt(parts[1]));
            }
        }
        catch (Exception e) {
            Settings.logger.c("Failed to assign an icon!", (Throwable)e);
            this.icon = Settings.defaultIcon.m();
        }
        this.blocks = (int[][][])blocks.clone();
        this.metadata = (int[][][])metadata.clone();
        if (tileEntities != null) {
            this.tileEntities.addAll(tileEntities);
            for (asm tileEntity : this.tileEntities) {
                tileEntity.s();
            }
        }
        this.width = width;
        this.length = length;
        this.height = height;
        this.generateBlockList();
    }

    public void readFromNBT(bx tagCompound) {
        if (tagCompound.b("Icon")) {
            this.icon.c(tagCompound.l("Icon"));
        } else {
            this.icon = Settings.defaultIcon.m();
        }
        byte[] localBlocks = tagCompound.j("Blocks");
        byte[] localMetadata = tagCompound.j("Data");
        boolean extra = tagCompound.b("Add") || tagCompound.b("AddBlocks");
        byte[] extraBlocks = null;
        byte[] extraBlocksNibble = null;
        if (tagCompound.b("AddBlocks")) {
            extraBlocksNibble = tagCompound.j("AddBlocks");
            extraBlocks = new byte[extraBlocksNibble.length * 2];
            for (int i = 0; i < extraBlocksNibble.length; ++i) {
                extraBlocks[i * 2 + 0] = (byte)(extraBlocksNibble[i] >> 4 & 0xF);
                extraBlocks[i * 2 + 1] = (byte)(extraBlocksNibble[i] & 0xF);
            }
        } else if (tagCompound.b("Add")) {
            extraBlocks = tagCompound.j("Add");
        }
        this.width = tagCompound.d("Width");
        this.length = tagCompound.d("Length");
        this.height = tagCompound.d("Height");
        this.blocks = new int[this.width][this.height][this.length];
        this.metadata = new int[this.width][this.height][this.length];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    this.blocks[x][y][z] = localBlocks[x + (y * this.length + z) * this.width] & 0xFF;
                    this.metadata[x][y][z] = localMetadata[x + (y * this.length + z) * this.width] & 0xFF;
                    if (!extra) continue;
                    int[] nArray = this.blocks[x][y];
                    int n = z;
                    nArray[n] = nArray[n] | (extraBlocks[x + (y * this.length + z) * this.width] & 0xFF) << 8;
                }
            }
        }
        this.tileEntities.clear();
        cf tileEntitiesList = tagCompound.m("TileEntities");
        for (int i = 0; i < tileEntitiesList.c(); ++i) {
            asm tileEntity = asm.c((bx)((bx)tileEntitiesList.b(i)));
            if (tileEntity == null) continue;
            tileEntity.k = this;
            tileEntity.s();
            this.tileEntities.add(tileEntity);
        }
        this.refreshChests();
        this.generateBlockList();
    }

    public void writeToNBT(bx tagCompound) {
        bx tagCompoundIcon = new bx();
        this.icon.b(tagCompoundIcon);
        tagCompound.a("Icon", tagCompoundIcon);
        tagCompound.a("Width", this.width);
        tagCompound.a("Length", this.length);
        tagCompound.a("Height", this.height);
        int size = this.width * this.length * this.height;
        byte[] localBlocks = new byte[size];
        byte[] localMetadata = new byte[size];
        byte[] extraBlocks = new byte[size];
        byte[] extraBlocksNibble = new byte[(int)Math.ceil((double)size / 2.0)];
        boolean extra = false;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    localBlocks[x + (y * this.length + z) * this.width] = (byte)this.blocks[x][y][z];
                    localMetadata[x + (y * this.length + z) * this.width] = (byte)this.metadata[x][y][z];
                    extraBlocks[x + (y * this.length + z) * this.width] = (byte)(this.blocks[x][y][z] >> 8);
                    if (extraBlocks[x + (y * this.length + z) * this.width] <= 0) continue;
                    extra = true;
                }
            }
        }
        for (int i = 0; i < extraBlocksNibble.length; ++i) {
            extraBlocksNibble[i] = i * 2 + 1 < extraBlocks.length ? (byte)(extraBlocks[i * 2 + 0] << 4 | extraBlocks[i * 2 + 1]) : (byte)(extraBlocks[i * 2 + 0] << 4);
        }
        tagCompound.a("Materials", "Alpha");
        tagCompound.a("Blocks", localBlocks);
        tagCompound.a("Data", localMetadata);
        if (extra) {
            tagCompound.a("AddBlocks", extraBlocksNibble);
        }
        tagCompound.a("Entities", (ck)new cf());
        cf tileEntitiesList = new cf();
        for (asm tileEntity : this.tileEntities) {
            bx tileEntityTagCompound = new bx();
            tileEntity.b(tileEntityTagCompound);
            tileEntitiesList.a((ck)tileEntityTagCompound);
        }
        tagCompound.a("TileEntities", (ck)tileEntitiesList);
    }

    private void generateBlockList() {
        this.blockList.clear();
        yd itemStack = null;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    int itemID = this.blocks[x][y][z];
                    int itemDamage = this.metadata[x][y][z];
                    if (itemID == 0 || blockListIgnoreID.contains(itemID)) continue;
                    if (blockListIgnoreMetadata.contains(itemID)) {
                        itemDamage = 0;
                    }
                    if (blockListMapping.containsKey(itemID)) {
                        itemID = blockListMapping.get(itemID);
                    }
                    if (itemID == aqw.O.cF || itemID == aqw.P.cF) {
                        itemDamage &= 3;
                    }
                    if (itemID == aqw.ap.cF || itemID == aqw.bT.cF) {
                        itemDamage &= 7;
                    }
                    if (itemID >= 256) {
                        itemDamage = 0;
                    }
                    if (itemID - 256 == aqw.bU.cF) {
                        itemDamage = 3;
                    }
                    if (itemID == yb.bS.cv) {
                        itemDamage = this.metadata[x][y][z];
                    }
                    itemStack = null;
                    for (yd block : this.blockList) {
                        if (block.d != itemID || block.k() != itemDamage) continue;
                        itemStack = block;
                        ++itemStack.b;
                        break;
                    }
                    if (itemStack != null) continue;
                    this.blockList.add(new yd(itemID, 1, itemDamage));
                }
            }
        }
        Collections.sort(this.blockList, blockListComparator);
    }

    public int a(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.height || z >= this.length) {
            return 0;
        }
        return this.blocks[x][y][z] & 0xFFF;
    }

    public asm r(int x, int y, int z) {
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            asm tileEntity = this.tileEntities.get(i);
            if (tileEntity.l != x || tileEntity.m != y || tileEntity.n != z) continue;
            return tileEntity;
        }
        return null;
    }

    public int h(int var1, int var2, int var3, int var4) {
        return 15;
    }

    public float i(int var1, int var2, int var3, int var4) {
        return 1.0f;
    }

    public float q(int x, int y, int z) {
        return 1.0f;
    }

    public int h(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.height || z >= this.length) {
            return 0;
        }
        return this.metadata[x][y][z];
    }

    public ajz g(int x, int y, int z) {
        return this.getBlock(x, y, z) != null ? this.getBlock((int)x, (int)y, (int)z).cU : ajz.a;
    }

    public boolean t(int x, int y, int z) {
        if (this.settings.renderingLayer != -1 && this.settings.renderingLayer != y) {
            return false;
        }
        return this.getBlock(x, y, z) != null && this.getBlock(x, y, z).c();
    }

    public boolean u(int x, int y, int z) {
        return this.g(x, y, z).k() && this.getBlock(x, y, z) != null && this.getBlock(x, y, z).b();
    }

    public boolean c(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.height || z >= this.length) {
            return true;
        }
        return this.blocks[x][y][z] == 0;
    }

    public acp a(int var1, int var2) {
        return acp.f;
    }

    public int R() {
        return this.height + 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean T() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean w(int var1, int var2, int var3) {
        return false;
    }

    protected adn j() {
        return null;
    }

    public nm a(int var1) {
        return null;
    }

    public boolean f(int x, int y, int z) {
        return false;
    }

    public boolean b(int x, int y, int z, int metadata, int flag) {
        this.metadata[x][y][z] = metadata;
        return true;
    }

    public aqw getBlock(int x, int y, int z) {
        return aqw.s[this.a(x, y, z)];
    }

    public void setTileEntities(List<asm> tileEntities) {
        this.tileEntities.clear();
        this.tileEntities.addAll(tileEntities);
        for (asm tileEntity : this.tileEntities) {
            tileEntity.s();
        }
    }

    public List<asm> getTileEntities() {
        return this.tileEntities;
    }

    public List<yd> getBlockList() {
        return this.blockList;
    }

    public void refreshChests() {
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            asm tileEntity = this.tileEntities.get(i);
            if (!(tileEntity instanceof arv)) continue;
            this.checkForAdjacentChests((arv)tileEntity);
        }
    }

    private void checkForAdjacentChests(arv tileEntityChest) {
        tileEntityChest.a = true;
        tileEntityChest.b = null;
        tileEntityChest.c = null;
        tileEntityChest.d = null;
        tileEntityChest.e = null;
        if (this.a(tileEntityChest.l - 1, tileEntityChest.m, tileEntityChest.n) == aqw.az.cF) {
            tileEntityChest.d = (arv)this.r(tileEntityChest.l - 1, tileEntityChest.m, tileEntityChest.n);
        }
        if (this.a(tileEntityChest.l + 1, tileEntityChest.m, tileEntityChest.n) == aqw.az.cF) {
            tileEntityChest.c = (arv)this.r(tileEntityChest.l + 1, tileEntityChest.m, tileEntityChest.n);
        }
        if (this.a(tileEntityChest.l, tileEntityChest.m, tileEntityChest.n - 1) == aqw.az.cF) {
            tileEntityChest.b = (arv)this.r(tileEntityChest.l, tileEntityChest.m, tileEntityChest.n - 1);
        }
        if (this.a(tileEntityChest.l, tileEntityChest.m, tileEntityChest.n + 1) == aqw.az.cF) {
            tileEntityChest.e = (arv)this.r(tileEntityChest.l, tileEntityChest.m, tileEntityChest.n + 1);
        }
    }

    public void flip() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < (this.length + 1) / 2; ++z) {
                    int tmp = this.blocks[x][y][z];
                    this.blocks[x][y][z] = this.blocks[x][y][this.length - 1 - z];
                    this.blocks[x][y][this.length - 1 - z] = tmp;
                    if (z == this.length - 1 - z) {
                        this.metadata[x][y][z] = BlockInfo.getTransformedMetadataFlip(this.blocks[x][y][z], this.metadata[x][y][z]);
                        continue;
                    }
                    tmp = this.metadata[x][y][z];
                    this.metadata[x][y][z] = BlockInfo.getTransformedMetadataFlip(this.blocks[x][y][z], this.metadata[x][y][this.length - 1 - z]);
                    this.metadata[x][y][this.length - 1 - z] = BlockInfo.getTransformedMetadataFlip(this.blocks[x][y][this.length - 1 - z], tmp);
                }
            }
        }
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            asm tileEntity = this.tileEntities.get(i);
            tileEntity.n = this.length - 1 - tileEntity.n;
            tileEntity.p = this.metadata[tileEntity.l][tileEntity.m][tileEntity.n];
            if (!(tileEntity instanceof ask) || tileEntity.p != 1) continue;
            ask skullTileEntity = (ask)tileEntity;
            int angle = skullTileEntity.b();
            int base = 0;
            base = angle <= 7 ? 4 : 12;
            skullTileEntity.a(2 * base - angle & 0xF);
        }
        this.refreshChests();
    }

    public void rotate() {
        int[][][] localBlocks = new int[this.length][this.height][this.width];
        int[][][] localMetadata = new int[this.length][this.height][this.width];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    localBlocks[z][y][x] = this.blocks[this.width - 1 - x][y][z];
                    localMetadata[z][y][x] = BlockInfo.getTransformedMetadataRotation(this.blocks[this.width - 1 - x][y][z], this.metadata[this.width - 1 - x][y][z]);
                }
            }
        }
        this.blocks = localBlocks;
        this.metadata = localMetadata;
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            asm tileEntity = this.tileEntities.get(i);
            int coord = tileEntity.l;
            tileEntity.l = tileEntity.n;
            tileEntity.n = this.width - 1 - coord;
            tileEntity.p = this.metadata[tileEntity.l][tileEntity.m][tileEntity.n];
            if (!(tileEntity instanceof ask) || tileEntity.p != 1) continue;
            ask skullTileEntity = (ask)tileEntity;
            skullTileEntity.a(skullTileEntity.b() + 12 & 0xF);
        }
        short tmp = this.width;
        this.width = this.length;
        this.length = tmp;
        this.refreshChests();
    }

    public int width() {
        return this.width;
    }

    public int length() {
        return this.length;
    }

    public int height() {
        return this.height;
    }

    public Vector3f dimensions() {
        return new Vector3f((float)this.width, (float)this.height, (float)this.length);
    }

    public static boolean isBlock(int itemId) {
        return itemId == aqw.C.cF || itemId == aqw.V.cF || itemId == aqw.ag.cF || itemId == aqw.br.cF;
    }

    public static boolean isStair(int itemId) {
        return itemId == aqw.ay.cF || itemId == aqw.aM.cF || itemId == aqw.bB.cF || itemId == aqw.bC.cF || itemId == aqw.bH.cF || itemId == aqw.bV.cF || itemId == aqw.cb.cF || itemId == aqw.cc.cF || itemId == aqw.cd.cF || itemId == aqw.cx.cF;
    }

    public static boolean isSlab(int itemId) {
        return itemId == aqw.ap.cF || itemId == aqw.bT.cF;
    }

    public static boolean isDoubleSlab(int itemId) {
        return itemId == aqw.ao.cF || itemId == aqw.bS.cF;
    }

    public static boolean isPistonBase(int itemId) {
        return itemId == aqw.aa.cF || itemId == aqw.ae.cF;
    }

    public static boolean isRedstoneRepeater(int itemId) {
        return itemId == aqw.bn.cF || itemId == aqw.bm.cF;
    }

    public static boolean isTorch(int itemId) {
        return itemId == aqw.aV.cF || itemId == aqw.aU.cF || itemId == aqw.av.cF;
    }

    public static boolean isContainer(int itemId) {
        return itemId == aqw.aH.cF || itemId == aqw.aG.cF || itemId == aqw.U.cF || itemId == aqw.az.cF || itemId == aqw.bX.cF;
    }

    public static boolean isButton(int itemId) {
        return itemId == aqw.aW.cF || itemId == aqw.ck.cF;
    }

    public static boolean isPumpkin(int itemId) {
        return itemId == aqw.bf.cF || itemId == aqw.bk.cF;
    }

    public static boolean isFluidContainer(int itemId) {
        return itemId == yb.az.cv || itemId == yb.aA.cv;
    }

    public static boolean isMetadataSensitive(int itemId) {
        return itemId == aqw.cm.cF || itemId == aqw.bp.cF || SchematicWorld.isTorch(itemId) || SchematicWorld.isBlock(itemId) || SchematicWorld.isSlab(itemId) || SchematicWorld.isDoubleSlab(itemId) || SchematicWorld.isPistonBase(itemId) || SchematicWorld.isRedstoneRepeater(itemId) || SchematicWorld.isContainer(itemId) || SchematicWorld.isButton(itemId) || SchematicWorld.isPumpkin(itemId);
    }
}

