/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica;

import cpw.mods.fml.common.network.PacketDispatcher;
import lunatrius.schematica.SchematicWorld;
import lunatrius.schematica.Settings;
import net.minecraftforge.common.ForgeDirection;

public class SchematicPrinter {
    private final Settings settings = Settings.instance();

    public boolean print() {
        bdf player = this.settings.minecraft.h;
        bda world = this.settings.minecraft.f;
        this.syncSneaking((ue)player, true);
        int minX = Math.max(0, (int)this.settings.getTranslationX() - 3);
        int maxX = Math.min(this.settings.schematic.width(), (int)this.settings.getTranslationX() + 3);
        int minY = Math.max(0, (int)this.settings.getTranslationY() - 3);
        int maxY = Math.min(this.settings.schematic.height(), (int)this.settings.getTranslationY() + 3);
        int minZ = Math.max(0, (int)this.settings.getTranslationZ() - 3);
        int maxZ = Math.min(this.settings.schematic.length(), (int)this.settings.getTranslationZ() + 3);
        int slot = player.bn.c;
        boolean isSneaking = player.ag();
        for (int y = minY; y <= maxY; ++y) {
            if (this.settings.renderingLayer >= 0 && y != this.settings.renderingLayer) continue;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int blockId = this.settings.schematic.a(x, y, z);
                    if (blockId == 0 || world.a((int)this.settings.offset.x + x, (int)this.settings.offset.y + y, (int)this.settings.offset.z + z) != 0) continue;
                    int blockMetadata = this.settings.schematic.h(x, y, z);
                    if (!this.placeBlock(this.settings.minecraft, (abv)world, (ue)player, (int)this.settings.offset.x + x, (int)this.settings.offset.y + y, (int)this.settings.offset.z + z, this.getMappedId(blockId), blockMetadata) || this.settings.placeInstantly) continue;
                    player.bn.c = slot;
                    this.syncSneaking((ue)player, isSneaking);
                    return true;
                }
            }
        }
        player.bn.c = slot;
        this.syncSneaking((ue)player, isSneaking);
        return true;
    }

    private int getMappedId(int blockId) {
        if (SchematicWorld.blockListMapping.containsKey(blockId)) {
            return SchematicWorld.blockListMapping.get(blockId);
        }
        return blockId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean placeBlock(ats minecraft, abv world, ue player, int x, int y, int z, int itemId, int itemDamage) {
        boolean[] blocks;
        ForgeDirection direction;
        float offsetY;
        int side;
        block59: {
            block47: {
                int itemDamageInHand;
                block49: {
                    block58: {
                        block57: {
                            block56: {
                                block55: {
                                    block54: {
                                        block53: {
                                            block52: {
                                                block51: {
                                                    block50: {
                                                        block48: {
                                                            if (!this.isValidOrientation(player, x, y, z, itemId, itemDamage)) {
                                                                return false;
                                                            }
                                                            if (SchematicWorld.isFluidContainer(itemId) || itemId == yb.aw.cv) {
                                                                return false;
                                                            }
                                                            side = 0;
                                                            offsetY = 0.0f;
                                                            direction = ForgeDirection.DOWN;
                                                            blocks = new boolean[]{world.a(x, y + 1, z) > 0, world.a(x, y - 1, z) > 0, world.a(x, y, z + 1) > 0, world.a(x, y, z - 1) > 0, world.a(x + 1, y, z) > 0, world.a(x - 1, y, z) > 0};
                                                            for (int i = 0; i < 6; ++i) {
                                                                if (!blocks[i]) continue;
                                                                direction = ForgeDirection.getOrientation((int)i).getOpposite();
                                                                break;
                                                            }
                                                            if (!SchematicWorld.isMetadataSensitive(itemId)) break block47;
                                                            itemDamageInHand = 15;
                                                            if (!SchematicWorld.isTorch(itemId)) break block48;
                                                            switch (itemDamage) {
                                                                case 1: {
                                                                    direction = ForgeDirection.WEST;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    direction = ForgeDirection.EAST;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    direction = ForgeDirection.NORTH;
                                                                    break;
                                                                }
                                                                case 4: {
                                                                    direction = ForgeDirection.SOUTH;
                                                                    break;
                                                                }
                                                                case 5: {
                                                                    direction = ForgeDirection.DOWN;
                                                                }
                                                            }
                                                            if (direction == ForgeDirection.DOWN) {
                                                                if (world.w(x, y - 1, z)) {
                                                                    itemDamageInHand = 0;
                                                                }
                                                            } else if (world.isBlockSolidOnSide(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ, direction, false)) {
                                                                itemDamageInHand = 0;
                                                            }
                                                            break block49;
                                                        }
                                                        if (!SchematicWorld.isBlock(itemId)) break block50;
                                                        itemDamageInHand = itemDamage;
                                                        break block49;
                                                    }
                                                    if (!SchematicWorld.isSlab(itemId)) break block51;
                                                    if ((itemDamage & 8) != 0 && direction == ForgeDirection.DOWN) {
                                                        direction = ForgeDirection.UP;
                                                    } else if ((itemDamage & 8) == 0 && direction == ForgeDirection.UP) {
                                                        direction = ForgeDirection.DOWN;
                                                    }
                                                    offsetY = (itemDamage & 8) == 0 ? 0.0f : 1.0f;
                                                    itemDamageInHand = itemDamage & 7;
                                                    break block49;
                                                }
                                                if (!SchematicWorld.isPistonBase(itemId)) break block52;
                                                itemDamageInHand = 0;
                                                break block49;
                                            }
                                            if (!SchematicWorld.isDoubleSlab(itemId)) break block53;
                                            itemDamageInHand = itemDamage;
                                            break block49;
                                        }
                                        if (!SchematicWorld.isContainer(itemId)) break block54;
                                        itemDamageInHand = 0;
                                        break block49;
                                    }
                                    if (!SchematicWorld.isButton(itemId)) break block55;
                                    switch (itemDamage & 7) {
                                        case 1: {
                                            direction = ForgeDirection.WEST;
                                            break;
                                        }
                                        case 2: {
                                            direction = ForgeDirection.EAST;
                                            break;
                                        }
                                        case 3: {
                                            direction = ForgeDirection.NORTH;
                                            break;
                                        }
                                        case 4: {
                                            direction = ForgeDirection.SOUTH;
                                            break;
                                        }
                                        default: {
                                            return false;
                                        }
                                    }
                                    if (!world.isBlockSolidOnSide(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ, direction, false)) return false;
                                    itemDamageInHand = 0;
                                    break block49;
                                }
                                if (!SchematicWorld.isPumpkin(itemId)) break block56;
                                if (!world.w(x, y - 1, z)) return false;
                                itemDamageInHand = 0;
                                break block49;
                            }
                            if (itemId != yb.bd.cv) break block57;
                            itemDamageInHand = 0;
                            break block49;
                        }
                        if (itemId != aqw.cm.cF) break block58;
                        switch (itemDamage & 0xC) {
                            case 0: {
                                itemDamageInHand = 0;
                                break block49;
                            }
                            case 4: {
                                itemDamageInHand = 1;
                                break block49;
                            }
                            case 8: {
                                itemDamageInHand = 2;
                                break block49;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    if (itemId == aqw.bA.cF) {
                        itemDamageInHand = 0;
                    } else {
                        if (itemId != aqw.bp.cF) return false;
                        switch (itemDamage & 3) {
                            case 0: {
                                direction = ForgeDirection.SOUTH;
                                break;
                            }
                            case 1: {
                                direction = ForgeDirection.NORTH;
                                break;
                            }
                            case 2: {
                                direction = ForgeDirection.EAST;
                                break;
                            }
                            case 3: {
                                direction = ForgeDirection.WEST;
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                        if ((itemDamage & 8) != 0) {
                            offsetY = 0.75f;
                        }
                        if (!world.isBlockSolidOnSide(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ, direction, false)) return false;
                        itemDamageInHand = 0;
                    }
                }
                if (!this.swapToItem(player.bn, itemId, itemDamageInHand)) {
                    return false;
                }
                break block59;
            }
            if (!this.swapToItem(player.bn, itemId)) {
                return false;
            }
            if (SchematicWorld.isStair(itemId)) {
                direction = (itemDamage & 4) == 0 ? ForgeDirection.DOWN : ForgeDirection.UP;
            } else if (aqw.O.cF == itemId) {
                if ((itemDamage & 0xC) == 0) {
                    direction = ForgeDirection.DOWN;
                } else if ((itemDamage & 0xC) == 4) {
                    direction = ForgeDirection.EAST;
                } else if ((itemDamage & 0xC) == 8) {
                    direction = ForgeDirection.NORTH;
                }
            }
        }
        side = this.getSide(direction);
        if ((side == 255 || !blocks[side]) && this.settings.placeAdjacent) return false;
        return this.placeBlock(minecraft, world, player, x, y, z, direction, 0.0f, offsetY, 0.0f);
    }

    private boolean isValidOrientation(ue player, int x, int y, int z, int itemId, int itemDamage) {
        int orientation = this.settings.orientation;
        if (SchematicWorld.isStair(itemId)) {
            switch (itemDamage & 3) {
                case 0: {
                    return orientation == 4;
                }
                case 1: {
                    return orientation == 5;
                }
                case 2: {
                    return orientation == 2;
                }
                case 3: {
                    return orientation == 3;
                }
            }
        } else {
            if (SchematicWorld.isPistonBase(itemId)) {
                return asq.a(null, (int)x, (int)y, (int)z, (oe)player) == asq.d((int)itemDamage);
            }
            if (SchematicWorld.isContainer(itemId)) {
                switch (itemDamage) {
                    case 2: {
                        return orientation == 2;
                    }
                    case 3: {
                        return orientation == 3;
                    }
                    case 4: {
                        return orientation == 4;
                    }
                    case 5: {
                        return orientation == 5;
                    }
                }
                return false;
            }
            if (SchematicWorld.isPumpkin(itemId)) {
                switch (itemDamage) {
                    case 0: {
                        return orientation == 3;
                    }
                    case 1: {
                        return orientation == 4;
                    }
                    case 2: {
                        return orientation == 2;
                    }
                    case 3: {
                        return orientation == 5;
                    }
                }
                return false;
            }
            if (itemId == yb.bd.cv) {
                switch (itemDamage & 3) {
                    case 0: {
                        return orientation == 3;
                    }
                    case 1: {
                        return orientation == 4;
                    }
                    case 2: {
                        return orientation == 2;
                    }
                    case 3: {
                        return orientation == 5;
                    }
                }
            } else if (itemId == aqw.cm.cF) {
                switch (itemDamage & 3) {
                    case 0: {
                        return orientation == 5;
                    }
                    case 1: {
                        return orientation == 3;
                    }
                    case 2: {
                        return orientation == 4;
                    }
                    case 3: {
                        return orientation == 2;
                    }
                }
            } else if (itemId == aqw.bA.cF) {
                switch (itemDamage & 3) {
                    case 0: {
                        return orientation == 2;
                    }
                    case 1: {
                        return orientation == 5;
                    }
                    case 2: {
                        return orientation == 3;
                    }
                    case 3: {
                        return orientation == 4;
                    }
                }
            }
        }
        return true;
    }

    private boolean placeBlock(ats minecraft, abv world, ue player, int x, int y, int z, ForgeDirection direction, float offsetX, float offsetY, float offsetZ) {
        yd itemStack = player.bx();
        boolean success = false;
        success = minecraft.c.a(player, world, itemStack, x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ, this.getSide(direction), asz.a((double)((float)x + offsetX), (double)((float)y + offsetY), (double)((float)z + offsetZ)));
        if (itemStack.b == 0 && success) {
            player.bn.a[player.bn.c] = null;
        }
        return success;
    }

    private void syncSneaking(ue player, boolean isSneaking) {
        player.b(isSneaking);
        PacketDispatcher.sendPacketToServer((ex)new fb((nm)player, isSneaking ? 1 : 2));
    }

    private int getSide(ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return 0;
            }
            case DOWN: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case NORTH: {
                return 3;
            }
            case EAST: {
                return 4;
            }
            case WEST: {
                return 5;
            }
        }
        return 255;
    }

    private boolean swapToItem(uc inventory, int itemID, int itemDamage) {
        int slot = this.getInventorySlotWithItem(inventory, itemID, itemDamage);
        if (slot > -1 && slot < 9) {
            inventory.c = slot;
            return true;
        }
        return false;
    }

    private boolean swapToItem(uc inventory, int itemID) {
        int slot = this.getInventorySlotWithItem(inventory, itemID);
        if (slot > -1 && slot < 9) {
            inventory.c = slot;
            return true;
        }
        return false;
    }

    private int getInventorySlotWithItem(uc inventory, int itemID, int itemDamage) {
        for (int i = 0; i < inventory.a.length; ++i) {
            if (inventory.a[i] == null || inventory.a[i].d != itemID || inventory.a[i].k() != itemDamage) continue;
            return i;
        }
        return -1;
    }

    private int getInventorySlotWithItem(uc inventory, int itemID) {
        for (int i = 0; i < inventory.a.length; ++i) {
            if (inventory.a[i] == null || inventory.a[i].d != itemID) continue;
            return i;
        }
        return -1;
    }
}

