/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.stalkercreepers.common;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SCTransformer
implements IClassTransformer {
    private final String entityAICreeperSwellClassNameO = "qp";
    private final String entityAICreeperSwellJavaClassNameO = "qp";
    private final String entityLivingJavaClassNameO = "od";
    private final String entityCreeperJavaClassNameO = "tc";
    private final String shouldExecuteMethodNameO = "a";
    private final String swellingCreeperFieldNameO = "a";
    private final String entityAICreeperSwellClassName = "net.minecraft.entity.ai.EntityAICreeperSwell";
    private final String entityAICreeperSwellJavaClassName = "net/minecraft/entity/ai/EntityAICreeperSwell";
    private final String shouldExecuteMethodName = "shouldExecute";
    private final String swellingCreeperFieldName = "swellingCreeper";
    private final String entityLivingJavaClassName = "net/minecraft/entity/EntityLiving";
    private final String entityCreeperJavaClassName = "net/minecraft/entity/monster/EntityCreeper";

    public byte[] transform(String name, String newName, byte[] bytes) {
        if (name.equals("qp")) {
            return this.handleEntityAICreeperSwellObfuscated(bytes);
        }
        if (name.equals("net.minecraft.entity.ai.EntityAICreeperSwell")) {
            return this.handleEntityAICreeperSwell(bytes);
        }
        return bytes;
    }

    private byte[] handleEntityAICreeperSwellObfuscated(byte[] bytes) {
        System.out.println("**************** Stalker Creepers transform running on EntityAICreeperSwell *********************** ");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("a") || !m.desc.equals("()Z")) continue;
            System.out.println("In target method! Patching!");
            AbstractInsnNode nodeTarget = null;
            for (int index = 0; index < m.instructions.size(); ++index) {
                AbstractInsnNode curNode = m.instructions.get(index);
                if (curNode.getOpcode() != 4) continue;
                nodeTarget = curNode;
            }
            if (nodeTarget == null) {
                System.out.println("Did not find all necessary target nodes! ABANDON CLASS!");
                return bytes;
            }
            InsnList toInject = new InsnList();
            LabelNode exitLabelNode = new LabelNode(new Label());
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, "qp", "a", "Ltc;"));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "atomicstryker/stalkercreepers/common/EntityAIHelperStalker", "isSeenByTarget", "(Lod;)Z"));
            toInject.add((AbstractInsnNode)new JumpInsnNode(154, exitLabelNode));
            toInject.add((AbstractInsnNode)new InsnNode(3));
            toInject.add((AbstractInsnNode)new InsnNode(172));
            toInject.add((AbstractInsnNode)exitLabelNode);
            m.instructions.insertBefore(nodeTarget, toInject);
            System.out.println("Patching Complete!");
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleEntityAICreeperSwell(byte[] bytes) {
        System.out.println("**************** Stalker Creepers transform running on EntityAICreeperSwell *********************** ");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("shouldExecute") || !m.desc.equals("()Z")) continue;
            System.out.println("In target method! Patching!");
            AbstractInsnNode nodeTarget = null;
            for (int index = 0; index < m.instructions.size(); ++index) {
                AbstractInsnNode curNode = m.instructions.get(index);
                if (curNode.getOpcode() != 4) continue;
                nodeTarget = curNode;
            }
            if (nodeTarget == null) {
                System.out.println("Did not find all necessary target nodes! ABANDON CLASS!");
                return bytes;
            }
            InsnList toInject = new InsnList();
            LabelNode exitLabelNode = new LabelNode(new Label());
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAICreeperSwell", "swellingCreeper", "Lnet/minecraft/entity/monster/EntityCreeper;"));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "atomicstryker/stalkercreepers/common/EntityAIHelperStalker", "isSeenByTarget", "(Lnet/minecraft/entity/EntityLiving;)Z"));
            toInject.add((AbstractInsnNode)new JumpInsnNode(154, exitLabelNode));
            toInject.add((AbstractInsnNode)new InsnNode(3));
            toInject.add((AbstractInsnNode)new InsnNode(172));
            toInject.add((AbstractInsnNode)exitLabelNode);
            m.instructions.insertBefore(nodeTarget, toInject);
            System.out.println("Patching Complete!");
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

