/*
 * Decompiled with CFR 0.152.
 */
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import util.CopyFileInJar;
import util.InstallAlgorithms;
import util.PrivatePrintStream;

public class Installer
extends JFrame {
    private File path;
    private static PrivatePrintStream pps;
    private static int actualVersion;
    private static int updateVersion;
    private static int screenWidth;
    private static int screenHeight;
    private JButton chooseButton;
    private static JTextArea console;
    private JButton installButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextField locationTextField;

    public Installer() {
        this.initComponents();
        pps = new PrivatePrintStream(console);
        this.setTitle("EBGInstaller by Florilu.");
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setLocation(screenWidth - 200, screenHeight - 120);
        System.setOut(pps);
        Installer.checkForUpdate();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.locationTextField = new JTextField();
        this.chooseButton = new JButton();
        this.installButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        console = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("Choose your minecraft location:");
        this.locationTextField.setEditable(false);
        this.locationTextField.setText("No File selected");
        this.locationTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.locationTextFieldActionPerformed(evt);
            }
        });
        this.chooseButton.setText("Choose Folder...");
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.chooseButtonActionPerformed(evt);
            }
        });
        this.installButton.setText("Install...");
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.installButtonActionPerformed(evt);
            }
        });
        console.setEditable(false);
        console.setColumns(20);
        console.setRows(5);
        this.jScrollPane1.setViewportView(console);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.locationTextField).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.chooseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 156, Short.MAX_VALUE).addComponent(this.installButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chooseButton).addComponent(this.installButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void locationTextFieldActionPerformed(ActionEvent evt) {
    }

    private void chooseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        System.out.println("Choosing Path...");
        chooser.setFileHidingEnabled(false);
        chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        chooser.setFileSelectionMode(1);
        chooser.showOpenDialog(null);
        this.path = chooser.getSelectedFile();
        System.out.println("Path has been selected...");
        this.locationTextField.setText(this.path.toString());
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        if (this.path != null) {
            System.out.println();
            System.out.println("Installing in Folder: ");
            System.out.println(this.path);
            System.out.println();
            try {
                InstallAlgorithms.install(this.path);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("Please select a path to install the mod!");
        }
    }

    private static void checkForUpdate() {
        System.out.println("Checking for new installer version...");
        try {
            URL check = new URL("http://www.ni16061_1.vweb12.nitrado.net/florilu/webspace/Installer/ver/ver.txt");
            BufferedReader input = new BufferedReader(new InputStreamReader(check.openStream()));
            updateVersion = Integer.valueOf(input.readLine());
            if (updateVersion > actualVersion) {
                System.out.println("Installer update available, downloading...");
                CopyFileInJar c = new CopyFileInJar();
                c.downloadFile("http://www.ni16061_1.vweb12.nitrado.net/florilu/webspace/Updater/InstallerUpdater.jar", new FileOutputStream("InstallerUpdater.jar"));
                Process p = Runtime.getRuntime().exec("java -jar InstallerUpdater.jar");
                System.exit(0);
            } else {
                Thread.sleep(1000L);
                File updater = new File("InstallerUpdater.jar");
                System.out.println("No new version available.");
                if (updater.exists()) {
                    updater.delete();
                }
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Installer().setVisible(true);
            }
        });
    }

    static {
        actualVersion = 2;
        screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
        screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
    }
}

