/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import universalelectricity.core.electricity.ElectricityDisplay;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.ElectricItemHelper;
import universalelectricity.core.item.IItemElectric;

public abstract class ItemElectric
extends Item
implements IItemElectric {
    public ItemElectric(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        String color = "";
        double joules = this.getJoules(itemStack);
        color = joules <= this.getMaxJoules(itemStack) / 3.0 ? "\u00a74" : (joules > this.getMaxJoules(itemStack) * 2.0 / 3.0 ? "\u00a72" : "\u00a76");
        list.add(color + ElectricityDisplay.getDisplay(joules, ElectricityDisplay.ElectricUnit.JOULES) + "/" + ElectricityDisplay.getDisplay(this.getMaxJoules(itemStack), ElectricityDisplay.ElectricUnit.JOULES));
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        itemStack = ElectricItemHelper.getUncharged(itemStack);
    }

    @Override
    public ElectricityPack onReceive(ElectricityPack electricityPack, ItemStack itemStack) {
        double rejectedElectricity = Math.max(this.getJoules(itemStack) + electricityPack.getWatts() - this.getMaxJoules(itemStack), 0.0);
        double joulesToStore = electricityPack.getWatts() - rejectedElectricity;
        this.setJoules(this.getJoules(itemStack) + joulesToStore, itemStack);
        return ElectricityPack.getFromWatts(joulesToStore, this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack onProvide(ElectricityPack electricityPack, ItemStack itemStack) {
        double electricityToUse = Math.min(this.getJoules(itemStack), electricityPack.getWatts());
        this.setJoules(this.getJoules(itemStack) - electricityToUse, itemStack);
        return ElectricityPack.getFromWatts(electricityToUse, this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack getReceiveRequest(ItemStack itemStack) {
        return ElectricityPack.getFromWatts(Math.min(this.getMaxJoules(itemStack) - this.getJoules(itemStack), this.getTransferRate(itemStack)), this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack getProvideRequest(ItemStack itemStack) {
        return ElectricityPack.getFromWatts(Math.min(this.getJoules(itemStack), this.getTransferRate(itemStack)), this.getVoltage(itemStack));
    }

    public double getTransferRate(ItemStack itemStack) {
        return this.getMaxJoules(itemStack) * 0.01;
    }

    @Override
    public void setJoules(double joules, ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(joules, this.getMaxJoules(itemStack)), 0.0);
        itemStack.func_77978_p().func_74780_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0 - electricityStored / this.getMaxJoules(itemStack) * 100.0));
    }

    @Override
    public double getJoules(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return 0.0;
        }
        double electricityStored = itemStack.func_77978_p().func_74769_h("electricity");
        itemStack.func_77964_b((int)(100.0 - electricityStored / this.getMaxJoules(itemStack) * 100.0));
        return electricityStored;
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(ElectricItemHelper.getUncharged(new ItemStack((Item)this)));
        ItemStack chargedItem = new ItemStack((Item)this);
        par3List.add(ElectricItemHelper.getWithCharge(chargedItem, this.getMaxJoules(chargedItem)));
    }
}

