/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.item;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.IItemElectric;

public class ElectricItemHelper {
    public static double chargeItem(ItemStack itemStack, double joules, double voltage) {
        IItemElectric electricItem;
        double providingWatts;
        if (itemStack != null && itemStack.func_77973_b() instanceof IItemElectric && (providingWatts = Math.min(joules, (electricItem = (IItemElectric)itemStack.func_77973_b()).getReceiveRequest(itemStack).getWatts())) > 0.0) {
            ElectricityPack providedElectricity = electricItem.onReceive(ElectricityPack.getFromWatts(providingWatts, voltage), itemStack);
            return providedElectricity.getWatts();
        }
        return 0.0;
    }

    public static double dechargeItem(ItemStack itemStack, double joules, double voltage) {
        IItemElectric electricItem;
        double requestingWatts;
        if (itemStack != null && itemStack.func_77973_b() instanceof IItemElectric && (requestingWatts = Math.min(joules, (electricItem = (IItemElectric)itemStack.func_77973_b()).getProvideRequest(itemStack).getWatts())) > 0.0) {
            ElectricityPack receivedElectricity = electricItem.onProvide(ElectricityPack.getFromWatts(requestingWatts, voltage), itemStack);
            return receivedElectricity.getWatts();
        }
        return 0.0;
    }

    public static ItemStack getWithCharge(ItemStack itemStack, double joules) {
        if (itemStack != null && itemStack.func_77973_b() instanceof IItemElectric) {
            ((IItemElectric)itemStack.func_77973_b()).setJoules(joules, itemStack);
            return itemStack;
        }
        return itemStack;
    }

    public static ItemStack getWithCharge(Item item, double joules) {
        return ElectricItemHelper.getWithCharge(new ItemStack(item), joules);
    }

    public static ItemStack getCloneWithCharge(ItemStack itemStack, double joules) {
        return ElectricItemHelper.getWithCharge(itemStack.func_77946_l(), joules);
    }

    public static ItemStack getUncharged(ItemStack itemStack) {
        return ElectricItemHelper.getWithCharge(itemStack, 0.0);
    }

    public static ItemStack getUncharged(Item item) {
        return ElectricItemHelper.getUncharged(new ItemStack(item));
    }
}

