/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import src.train.common.api.LiquidManager;
import src.train.common.blocks.BlockDistil;
import src.train.common.core.handlers.PacketHandler;
import src.train.common.library.BlockIDs;
import src.train.common.library.ItemIDs;
import src.train.common.recipes.DistilRecipes;

public class TileEntityDistil
extends TileEntity
implements IInventory,
ISidedInventory,
ITankContainer {
    public ItemStack[] distilItemStacks;
    private ForgeDirection facing;
    public int distilBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int distilCookTime = 0;
    private int cookDuration = 400;
    private Random random;
    private int updateTicks;
    private int maxTank = 30000;
    private LiquidManager.StandardTank theTank;
    private ILiquidTank[] tankArray = new ILiquidTank[1];
    private LiquidStack liquid;
    public int amount;
    public int liquidItemID;
    public Side side = FMLCommonHandler.instance().getEffectiveSide();

    public TileEntityDistil() {
        this.distilItemStacks = new ItemStack[5];
        this.random = new Random();
        this.liquid = new LiquidStack(0, 0);
        LiquidManager liquidManager = LiquidManager.getInstance();
        liquidManager.getClass();
        LiquidManager.getInstance();
        this.theTank = liquidManager.new LiquidManager.FilteredTank(this.maxTank, LiquidManager.dieselFilter(), 1);
        this.tankArray[0] = this.theTank;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLiquid() {
        return this.amount;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLiquidItemID() {
        return this.liquidItemID;
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    public int func_70302_i_() {
        return this.distilItemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.distilItemStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.distilItemStacks[i] != null) {
            if (this.distilItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.distilItemStacks[i];
                this.distilItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.distilItemStacks[i].func_77979_a(j);
            if (this.distilItemStacks[i].field_77994_a == 0) {
                this.distilItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.distilItemStacks[par1] != null) {
            ItemStack var2 = this.distilItemStacks[par1];
            this.distilItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.distilItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "Distillation tower";
    }

    public void func_70307_a(NBTTagCompound nbtTag) {
        super.func_70307_a(nbtTag);
        this.facing = ForgeDirection.getOrientation((int)nbtTag.func_74771_c("Orientation"));
        NBTTagList nbttaglist = nbtTag.func_74761_m("Items");
        this.distilItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.distilItemStacks.length) continue;
            this.distilItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.distilBurnTime = nbtTag.func_74765_d("BurnTime");
        this.distilCookTime = nbtTag.func_74765_d("CookTime");
        this.currentItemBurnTime = this.getItemBurnTime(this.distilItemStacks[1]);
        this.theTank.readFromNBT(nbtTag);
    }

    public int getTankCapacity() {
        return this.maxTank;
    }

    public void func_70310_b(NBTTagCompound nbtTag) {
        super.func_70310_b(nbtTag);
        nbtTag.func_74774_a("Orientation", (byte)this.facing.ordinal());
        nbtTag.func_74777_a("BurnTime", (short)this.distilBurnTime);
        nbtTag.func_74777_a("CookTime", (short)this.distilCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.distilItemStacks.length; ++i) {
            if (this.distilItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.distilItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbtTag.func_74782_a("Items", (NBTBase)nbttaglist);
        this.theTank.writeToNBT(nbtTag);
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int i) {
        return this.distilCookTime * i / this.cookDuration;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.cookDuration;
        }
        return this.distilBurnTime * i / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.distilBurnTime > 0;
    }

    public void func_70316_g() {
        ++this.updateTicks;
        boolean flag = this.distilBurnTime > 0;
        boolean flag1 = false;
        if (this.distilBurnTime > 0) {
            --this.distilBurnTime;
        }
        if (!this.field_70331_k.field_72995_K) {
            ItemStack result;
            if (this.distilBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.distilBurnTime = this.getItemBurnTime(this.distilItemStacks[1]);
                if (this.distilBurnTime > 0) {
                    flag1 = true;
                    if (this.distilItemStacks[1] != null) {
                        if (this.distilItemStacks[1].func_77973_b().func_77634_r()) {
                            this.distilItemStacks[1] = new ItemStack(this.distilItemStacks[1].func_77973_b().func_77668_q());
                        } else {
                            --this.distilItemStacks[1].field_77994_a;
                        }
                        if (this.distilItemStacks[1].field_77994_a == 0) {
                            this.distilItemStacks[1] = null;
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.distilCookTime;
                if (this.distilCookTime == this.cookDuration) {
                    this.distilCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.distilCookTime = 0;
            }
            if (flag != this.distilBurnTime > 0) {
                flag1 = true;
                BlockDistil.updateDistilBlockState(this.distilBurnTime > 0, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            if (this.distilItemStacks[2] != null && this.updateTicks % 8 == 0 && (result = LiquidManager.getInstance().processContainer(this, 2, this.theTank, this.distilItemStacks[2], 0)) != null && this.placeInInvent(result, 4, false)) {
                this.placeInInvent(result, 4, true);
                this.amount = this.theTank.getLiquid() != null ? this.theTank.getLiquid().amount : 0;
                this.liquidItemID = this.theTank.getLiquid() != null ? this.theTank.getLiquid().itemID : 0;
                flag1 = true;
                PacketHandler.sendPacketToClients(PacketHandler.setDistilLiquid(this), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 12.0);
            }
            this.amount = this.theTank.getLiquid() != null ? this.theTank.getLiquid().amount : 0;
            this.liquidItemID = this.theTank.getLiquid() != null ? this.theTank.getLiquid().itemID : 0;
            if (this.updateTicks % 8 == 0) {
                PacketHandler.sendPacketToClients(PacketHandler.setDistilLiquid(this), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 12.0);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean placeInInvent(ItemStack itemstack1, int i, boolean doAdd) {
        if (this.distilItemStacks[i] == null) {
            if (doAdd) {
                this.distilItemStacks[i] = itemstack1;
            }
            return true;
        }
        if (this.distilItemStacks[i] != null && this.distilItemStacks[i].field_77993_c == itemstack1.field_77993_c && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.distilItemStacks[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.distilItemStacks[i], (ItemStack)itemstack1)) {
            int var9 = this.distilItemStacks[i].field_77994_a + itemstack1.field_77994_a;
            if (var9 <= itemstack1.func_77976_d()) {
                if (doAdd) {
                    this.distilItemStacks[i].field_77994_a = var9;
                }
            } else if (this.distilItemStacks[i].field_77994_a < itemstack1.func_77976_d() && doAdd) {
                ++this.distilItemStacks[i].field_77994_a;
            }
            return true;
        }
        return false;
    }

    private boolean canSmelt() {
        if (this.distilItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = DistilRecipes.smelting().getSmeltingResult(this.distilItemStacks[0].func_77973_b().field_77779_bT);
        if (itemstack == null) {
            return false;
        }
        if (this.distilItemStacks[0].func_77973_b().field_77779_bT == BlockIDs.OreTC.blockID && this.distilItemStacks[0].func_77960_j() == 0) {
            return false;
        }
        LiquidStack resultLiquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemstack);
        if (resultLiquid == null) {
            return false;
        }
        int used = this.getTank().fill(resultLiquid, false);
        return used >= resultLiquid.amount;
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack itemstack = DistilRecipes.smelting().getSmeltingResult(this.distilItemStacks[0].func_77973_b().field_77779_bT);
        ItemStack plasticStack = DistilRecipes.smelting().getPlasticResult(this.distilItemStacks[0].func_77973_b().field_77779_bT);
        int plasticChance = DistilRecipes.smelting().getPlasticChance(this.distilItemStacks[0].func_77973_b().field_77779_bT);
        LiquidStack resultLiquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)itemstack);
        if (resultLiquid == null) {
            return;
        }
        int used = this.getTank().fill(resultLiquid, false);
        if (used >= resultLiquid.amount) {
            this.getTank().fill(resultLiquid, true);
            if (this.random.nextInt(plasticChance) == 0) {
                this.outputPlastic(plasticStack);
            }
            if (this.theTank.getLiquid() != null) {
                this.amount = this.theTank.getLiquid().amount;
            }
            if (this.theTank.getLiquid() != null) {
                this.liquidItemID = this.theTank.getLiquid().itemID;
            }
            PacketHandler.sendPacketToClients(PacketHandler.setDistilLiquid(this), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 12.0);
        }
        if (this.distilItemStacks[0].func_77973_b().func_77634_r()) {
            this.distilItemStacks[0] = new ItemStack(this.distilItemStacks[0].func_77973_b().func_77668_q());
        } else {
            --this.distilItemStacks[0].field_77994_a;
        }
        if (this.distilItemStacks[0].field_77994_a <= 0) {
            this.distilItemStacks[0] = null;
        }
    }

    private void outputPlastic(ItemStack plasticStack) {
        if (this.distilItemStacks[3] == null) {
            this.distilItemStacks[3] = plasticStack.func_77946_l();
        } else if (this.distilItemStacks[3].field_77993_c == plasticStack.field_77993_c) {
            this.distilItemStacks[3].field_77994_a += plasticStack.field_77994_a;
        }
        this.func_70296_d();
    }

    private int getItemBurnTime(ItemStack it) {
        if (it == null) {
            return 0;
        }
        int var1 = it.func_77973_b().field_77779_bT;
        if (var1 < 256 && Block.field_71973_m[var1].field_72018_cp == Material.field_76245_d) {
            return 300;
        }
        if (var1 == Item.field_77669_D.field_77779_bT) {
            return 100;
        }
        if (var1 == Item.field_77705_m.field_77779_bT) {
            return 2600;
        }
        if (var1 == Item.field_77775_ay.field_77779_bT) {
            return 20000;
        }
        if (var1 == Block.field_71987_y.field_71990_ca) {
            return 100;
        }
        if (var1 == Item.field_77731_bo.field_77779_bT) {
            return 2500;
        }
        if (var1 == BlockIDs.OreTC.blockID && it.func_77960_j() == 1) {
            return 2500;
        }
        if (var1 == BlockIDs.OreTC.blockID && it.func_77960_j() == 2) {
            return 2500;
        }
        if (var1 == ItemIDs.diesel.itemID) {
            return 4000;
        }
        if (var1 == ItemIDs.refinedFuel.itemID) {
            return 6000;
        }
        int ret = GameRegistry.getFuelValue((ItemStack)it);
        return ret;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k == null) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    public void setFacing(ForgeDirection face) {
        this.facing = face;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return 1;
        }
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 2;
    }

    public Packet func_70319_e() {
        return PacketHandler.getTEPClient(this);
    }

    public void handlePacketDataFromServer(byte orientation, short cookTime, short burnTime, short amount, short liquidID) {
        this.facing = ForgeDirection.getOrientation((int)orientation);
        this.distilBurnTime = burnTime;
        this.distilCookTime = cookTime;
        this.amount = amount;
        this.liquidItemID = liquidID;
    }

    public void handlePacketDataFromServer(short amount, short liquidID) {
        this.amount = amount;
        this.liquidItemID = liquidID;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        this.amount = this.theTank.getLiquid() != null ? this.theTank.getLiquid().amount : 0;
        this.liquidItemID = this.theTank.getLiquid() != null ? this.theTank.getLiquid().itemID : 0;
        PacketHandler.sendPacketToClients(PacketHandler.setDistilLiquid(this), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 12.0);
        return this.theTank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        this.amount = this.theTank.getLiquid() != null ? this.theTank.getLiquid().amount : 0;
        this.liquidItemID = this.theTank.getLiquid() != null ? this.theTank.getLiquid().itemID : 0;
        PacketHandler.sendPacketToClients(PacketHandler.setDistilLiquid(this), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 12.0);
        return this.theTank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return this.tankArray;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.theTank;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }
}

