/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.recipes;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import src.train.common.core.interfaces.ITCRecipe;

public class ShapedTrainRecipes
implements ITCRecipe {
    public final int recipeWidth;
    public final int recipeHeight;
    public final ItemStack[] recipeItems;
    public boolean[] slots;
    private ItemStack recipeOutput;
    public final int recipeOutputItemID;
    private boolean field_92049_f = false;

    public ShapedTrainRecipes(int par1, int par2, ItemStack[] stacks, ItemStack stack) {
        this.recipeOutputItemID = stack.field_77993_c;
        this.recipeWidth = par1;
        this.recipeHeight = par2;
        this.recipeItems = stacks;
        this.recipeOutput = stack;
        this.slots = new boolean[9];
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public boolean matches(IInventory inventory, World world) {
        int i;
        for (i = 0; i < this.slots.length; ++i) {
            this.slots[i] = false;
        }
        this.checkMatch(inventory, true);
        for (i = 0; i < this.slots.length; ++i) {
            if (this.slots[i]) continue;
            return false;
        }
        return true;
    }

    private boolean checkMatch(IInventory inventory, boolean par4) {
        for (int i = 0; i < 9; ++i) {
            ItemStack var9 = this.recipeItems[i];
            ItemStack var10 = inventory.func_70301_a(i);
            if (var10 != null || var9 != null) {
                if (var10 == null && var9 != null || var10 != null && var9 == null) {
                    this.slots[i] = false;
                    continue;
                }
                if (var9.field_77993_c != var10.field_77993_c) {
                    this.slots[i] = false;
                    continue;
                }
                if (var9.func_77960_j() != Short.MAX_VALUE && var9.func_77960_j() != var10.func_77960_j()) {
                    this.slots[i] = false;
                    continue;
                }
                this.slots[i] = true;
                continue;
            }
            this.slots[i] = true;
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(IInventory inventory) {
        ItemStack var2 = this.getRecipeOutput().func_77946_l();
        if (this.field_92049_f) {
            for (int var3 = 0; var3 < inventory.func_70302_i_(); ++var3) {
                ItemStack var4 = inventory.func_70301_a(var3);
                if (var4 == null || !var4.func_77942_o()) continue;
                var2.func_77982_d((NBTTagCompound)var4.field_77990_d.func_74737_b());
            }
        }
        return var2;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }

    public ShapedTrainRecipes func_92048_c() {
        this.field_92049_f = true;
        return this;
    }
}

