/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.library;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import src.train.common.blocks.tracks.BlockAnimalBoardingTrack;
import src.train.common.blocks.tracks.BlockCopperTrack;
import src.train.common.blocks.tracks.BlockCouplerTrack;
import src.train.common.blocks.tracks.BlockDetectorAllLocomotiveTrack;
import src.train.common.blocks.tracks.BlockDetectorDieselLocomotiveTrack;
import src.train.common.blocks.tracks.BlockDetectorFreightTrack;
import src.train.common.blocks.tracks.BlockDetectorPassengerTrack;
import src.train.common.blocks.tracks.BlockDetectorSteamLocomotiveTrack;
import src.train.common.blocks.tracks.BlockDetectorTankCartsTrack;
import src.train.common.blocks.tracks.BlockDisembarkTrack;
import src.train.common.blocks.tracks.BlockEnergyTrack;
import src.train.common.blocks.tracks.BlockLocomotiveHoldingTrack;
import src.train.common.blocks.tracks.BlockLocomotiveSpeedControllerTrack;
import src.train.common.blocks.tracks.BlockMobBoardingTrack;
import src.train.common.blocks.tracks.BlockSteelTrack;
import src.train.common.blocks.tracks.TrackTextureLoader;

public enum TrackIDs {
    DETECTOR_FREIGHT(2, "detector.freight", 8, BlockDetectorFreightTrack.class),
    DETECTOR_PASSENGER(2, "detector.passenger", 8, BlockDetectorPassengerTrack.class),
    DETECTOR_ALL_LOCOMOTIVES(2, "detector.loco", 8, BlockDetectorAllLocomotiveTrack.class),
    DETECTOR_STEAM_LOCOMOTIVES(2, "detector.steam", 8, BlockDetectorSteamLocomotiveTrack.class),
    DETECTOR_DIESEL_LOCOMOTIVES(2, "detector.diesel", 8, BlockDetectorDieselLocomotiveTrack.class),
    DETECTOR_TANK_CARTS(2, "detector.tank", 8, BlockDetectorTankCartsTrack.class),
    COUPLER_TRACK(2, "coupler", 8, BlockCouplerTrack.class),
    COPPER_TRACK(2, "copper", 16, BlockCopperTrack.class),
    STEEL_TRACK(2, "steel", 16, BlockSteelTrack.class),
    ANIMAL_BOARDING_TRACK(2, "boarding.animal", 8, BlockAnimalBoardingTrack.class),
    MOB_BOARDING_TRACK(2, "boarding.mob", 8, BlockMobBoardingTrack.class),
    DISEMBARK_TRACK(2, "disembark", 8, BlockDisembarkTrack.class),
    ENERGY_TRACK(4, "energy", 16, BlockEnergyTrack.class),
    LOCO_SPEED_CONTROLLER(5, "speed.loco", 8, BlockLocomotiveSpeedControllerTrack.class),
    LOCO_HOLDING_TRACK(2, "holding.loco", 8, BlockLocomotiveHoldingTrack.class);

    private final String tag;
    private final int recipeOutput;
    private final int numIcons;
    private final TrackSpec trackSpec;
    private static final List creativeList;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private TrackIDs(int numIcons, Class tag) {
        void track;
        void recipeOutput;
        this.numIcons = numIcons;
        this.tag = tag;
        this.recipeOutput = recipeOutput;
        this.trackSpec = new TrackSpec((short)(this.ordinal() + 513), this.getTag(), TrackTextureLoader.INSTANCE, (Class)track);
        TrackRegistry.registerTrackSpec(this.trackSpec);
    }

    public String getTextureTag() {
        return "TC".toLowerCase() + ":tracks/track." + this.tag;
    }

    public int getNumIcons() {
        return this.numIcons;
    }

    public TrackSpec getTrackSpec() {
        return this.trackSpec;
    }

    public static List getCreativeList() {
        return creativeList;
    }

    public String getTag() {
        return "tc.track." + this.tag;
    }

    public int getRecipeOutput() {
        return this.recipeOutput;
    }

    static {
        TrackRegistry.registerIconLoader(TrackTextureLoader.INSTANCE);
        creativeList = new ArrayList(15);
        creativeList.add(DETECTOR_FREIGHT);
        creativeList.add(DETECTOR_PASSENGER);
        creativeList.add(DETECTOR_ALL_LOCOMOTIVES);
        creativeList.add(DETECTOR_STEAM_LOCOMOTIVES);
        creativeList.add(DETECTOR_DIESEL_LOCOMOTIVES);
        creativeList.add(COUPLER_TRACK);
        creativeList.add(ENERGY_TRACK);
        creativeList.add(DETECTOR_TANK_CARTS);
        creativeList.add(COPPER_TRACK);
        creativeList.add(STEEL_TRACK);
        creativeList.add(ANIMAL_BOARDING_TRACK);
        creativeList.add(MOB_BOARDING_TRACK);
        creativeList.add(DISEMBARK_TRACK);
        creativeList.add(LOCO_SPEED_CONTROLLER);
        creativeList.add(LOCO_HOLDING_TRACK);
    }
}

