/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.core.plugins;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import src.train.common.Traincraft;
import src.train.common.core.TrainModCore;
import src.train.common.core.handlers.ConfigHandler;
import src.train.common.core.interfaces.IPlugin;
import src.train.common.inventory.TrainCraftingManager;
import src.train.common.items.ItemTrain;
import src.train.common.library.BlockIDs;
import src.train.common.library.ItemIDs;
import src.train.common.library.TrackIDs;

public class PluginRailcraft
implements IPlugin {
    public static PluginRailcraft instance = new PluginRailcraft();
    private static HashMap items = new HashMap();
    private static String[] names = new String[]{"fuel.coke", "part.ingot.steel", "part.rail.advanced", "part.rail.reinforced", "part.rail.speed", "part.rail.standard", "part.rail.wood", "part.railbed.stone", "part.railbed.wood"};

    @Override
    public boolean isAvailable() {
        return TrainModCore.isPresent("Railcraft");
    }

    @Override
    public void initialize() {
        this.initItems();
        this.checkItems();
        this.addTrackNames();
        this.addTrackRecipes();
    }

    public void registerTracks() {
        PluginRailcraft.registerTrack(TrackIDs.COUPLER_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_ALL_LOCOMOTIVES);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_FREIGHT);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_PASSENGER);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_STEAM_LOCOMOTIVES);
        PluginRailcraft.registerTrack(TrackIDs.ENERGY_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_TANK_CARTS);
        PluginRailcraft.registerTrack(TrackIDs.COPPER_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.STEEL_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.ANIMAL_BOARDING_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.DISEMBARK_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.MOB_BOARDING_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.LOCO_SPEED_CONTROLLER);
        PluginRailcraft.registerTrack(TrackIDs.LOCO_HOLDING_TRACK);
    }

    private static void registerTrack(TrackIDs rail) {
    }

    private void initItems() {
        ItemIDs.steelRail.item = new ItemTrain(ItemIDs.steelRail.itemID);
        ItemIDs.copperRail.item = new ItemTrain(ItemIDs.copperRail.itemID);
        ItemIDs.steelRail.item.func_77655_b(ItemIDs.steelRail.name());
        LanguageRegistry.addName((Object)ItemIDs.steelRail.item, (String)ItemIDs.steelRail.langName);
        ItemIDs.copperRail.item.func_77655_b(ItemIDs.copperRail.name());
        LanguageRegistry.addName((Object)ItemIDs.copperRail.item, (String)ItemIDs.copperRail.langName);
        for (int i = 0; i < names.length; ++i) {
            if (GameRegistry.findItemStack((String)"Railcraft", (String)names[i], (int)1) == null) continue;
            items.put(names[i], GameRegistry.findItemStack((String)"Railcraft", (String)names[i], (int)1));
        }
    }

    private void addTrackNames() {
        if (TrackIDs.COUPLER_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.COUPLER_TRACK.getTrackSpec().getItem(), (String)"[TC] Coupler track");
        }
        if (TrackIDs.ANIMAL_BOARDING_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.ANIMAL_BOARDING_TRACK.getTrackSpec().getItem(), (String)"[TC] Animal boarding track (stock car only)");
        }
        if (TrackIDs.COPPER_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.COPPER_TRACK.getTrackSpec().getItem(), (String)"[TC] Copper track");
        }
        if (TrackIDs.DETECTOR_ALL_LOCOMOTIVES.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_ALL_LOCOMOTIVES.getTrackSpec().getItem(), (String)"[TC] Locomotive detector track");
        }
        if (TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES.getTrackSpec().getItem(), (String)"[TC] Diesel locomotive detector track");
        }
        if (TrackIDs.DETECTOR_FREIGHT.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_FREIGHT.getTrackSpec().getItem(), (String)"[TC] Freight cart detector track");
        }
        if (TrackIDs.DETECTOR_PASSENGER.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_PASSENGER.getTrackSpec().getItem(), (String)"[TC] Passenger cart detector track");
        }
        if (TrackIDs.DETECTOR_STEAM_LOCOMOTIVES.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_STEAM_LOCOMOTIVES.getTrackSpec().getItem(), (String)"[TC] Steam locomotive detector track");
        }
        if (TrackIDs.DETECTOR_TANK_CARTS.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_TANK_CARTS.getTrackSpec().getItem(), (String)"[TC] Tank cart detector track");
        }
        if (TrackIDs.DISEMBARK_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DISEMBARK_TRACK.getTrackSpec().getItem(), (String)"[TC] Disembarking track (stock car only)");
        }
        if (TrackIDs.ENERGY_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.ENERGY_TRACK.getTrackSpec().getItem(), (String)"[TC] Electric track");
        }
        if (TrackIDs.MOB_BOARDING_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.MOB_BOARDING_TRACK.getTrackSpec().getItem(), (String)"[TC] Mob boarding track (stock car only)");
        }
        if (TrackIDs.STEEL_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.STEEL_TRACK.getTrackSpec().getItem(), (String)"[TC] Steel track");
        }
        if (TrackIDs.LOCO_SPEED_CONTROLLER.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.LOCO_SPEED_CONTROLLER.getTrackSpec().getItem(), (String)"[TC] Locomotive speed controller track");
        }
        if (TrackIDs.LOCO_HOLDING_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.LOCO_HOLDING_TRACK.getTrackSpec().getItem(), (String)"[TC] Locomotive holding track");
        }
    }

    private void addTrackRecipes() {
        ArrayList steel;
        ArrayList copper;
        if (TrackIDs.COUPLER_TRACK.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.COUPLER_TRACK.getTrackSpec().getItem(TrackIDs.COUPLER_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "# #", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.stake.item});
        }
        if (TrackIDs.ANIMAL_BOARDING_TRACK.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.ANIMAL_BOARDING_TRACK.getTrackSpec().getItem(TrackIDs.ANIMAL_BOARDING_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#P#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), Item.field_82798_bP, Character.valueOf('P'), Item.field_77730_bn});
        }
        if (TrackIDs.DISEMBARK_TRACK.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.DISEMBARK_TRACK.getTrackSpec().getItem(TrackIDs.DISEMBARK_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "# #", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), Item.field_77745_be});
        }
        if (TrackIDs.MOB_BOARDING_TRACK.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.MOB_BOARDING_TRACK.getTrackSpec().getItem(TrackIDs.MOB_BOARDING_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#P#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), Item.field_77755_aX, Character.valueOf('P'), Item.field_77730_bn});
        }
        if (TrackIDs.DETECTOR_ALL_LOCOMOTIVES.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_ALL_LOCOMOTIVES.getTrackSpec().getItem(TrackIDs.DETECTOR_ALL_LOCOMOTIVES.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.controls.item, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
        }
        if (TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES.getTrackSpec().getItem(TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.diesel.item, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
        }
        if (TrackIDs.DETECTOR_FREIGHT.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_FREIGHT.getTrackSpec().getItem(TrackIDs.DETECTOR_FREIGHT.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), Block.field_72077_au, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
        }
        if (TrackIDs.DETECTOR_PASSENGER.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_PASSENGER.getTrackSpec().getItem(TrackIDs.DETECTOR_PASSENGER.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.seats.item, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
        }
        if (TrackIDs.DETECTOR_STEAM_LOCOMOTIVES.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_STEAM_LOCOMOTIVES.getTrackSpec().getItem(TrackIDs.DETECTOR_STEAM_LOCOMOTIVES.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.ironFirebox.item, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
        }
        if (TrackIDs.DETECTOR_TANK_CARTS.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_TANK_CARTS.getTrackSpec().getItem(TrackIDs.DETECTOR_TANK_CARTS.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), Item.field_77786_ax, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
        }
        if (TrackIDs.ENERGY_TRACK.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.ENERGY_TRACK.getTrackSpec().getItem(TrackIDs.ENERGY_TRACK.getRecipeOutput()), (Object[])new Object[]{"#X#", "#R#", "#P#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[7]), Character.valueOf('X'), ItemIDs.copperWireFine.item, Character.valueOf('P'), Item.field_77730_bn});
        }
        if (TrackIDs.STEEL_TRACK.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.STEEL_TRACK.getTrackSpec().getItem(TrackIDs.STEEL_TRACK.getRecipeOutput()), (Object[])new Object[]{"# #", "#R#", "# #", Character.valueOf('#'), ItemIDs.steelRail.item, Character.valueOf('R'), items.get(names[7])});
        }
        if (TrackIDs.COPPER_TRACK.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.COPPER_TRACK.getTrackSpec().getItem(TrackIDs.COPPER_TRACK.getRecipeOutput()), (Object[])new Object[]{"# #", "#R#", "# #", Character.valueOf('#'), ItemIDs.copperRail.item, Character.valueOf('R'), items.get(names[7])});
        }
        if (TrackIDs.LOCO_SPEED_CONTROLLER.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.LOCO_SPEED_CONTROLLER.getTrackSpec().getItem(TrackIDs.LOCO_SPEED_CONTROLLER.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#X#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.controls.item});
        }
        if (TrackIDs.LOCO_HOLDING_TRACK.getTrackSpec() != null) {
            GameRegistry.addRecipe((ItemStack)TrackIDs.LOCO_HOLDING_TRACK.getTrackSpec().getItem(TrackIDs.LOCO_HOLDING_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#P#", "#X#", Character.valueOf('#'), ItemIDs.steelRail.item, Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.controls.item, Character.valueOf('P'), Block.field_72044_aK});
        }
        if ((copper = OreDictionary.getOres((String)"ingotCopper")) != null && copper.size() >= 0) {
            for (int i = 0; i < copper.size(); ++i) {
                RailcraftCraftingManager.rollingMachine.addRecipe(new ItemStack(ItemIDs.copperRail.item, 8), "X X", "X X", "X X", Character.valueOf('X'), copper.get(i));
            }
        }
        if ((steel = OreDictionary.getOres((String)"ingotSteel")) != null && steel.size() >= 0) {
            for (int t = 0; t < steel.size(); ++t) {
                RailcraftCraftingManager.rollingMachine.addRecipe(new ItemStack(ItemIDs.steelRail.item, 16), "X X", "I I", "X X", Character.valueOf('X'), steel.get(t), Character.valueOf('I'), Item.field_77703_o);
            }
        }
    }

    private void checkItems() {
        String missing = "";
        for (int i = 0; i < names.length; ++i) {
            if (items.containsKey(names[i])) continue;
            missing = missing + " " + names[i];
        }
        if (missing.equals("")) {
            Traincraft.tcLog.fine("Railcraft items loaded");
        } else {
            Traincraft.tcLog.log(Level.WARNING, "Railcraft items not loaded: " + missing);
        }
    }

    private void initRecipes() {
        if (items.containsKey(names[1])) {
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.stake.item, 1), "IFI", Character.valueOf('I'), items.get(names[1]), Character.valueOf('F'), Item.field_77703_o);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.piston.item, 3), " # ", " X ", Character.valueOf('#'), items.get(names[1]), Character.valueOf('X'), Item.field_77669_D);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.camshaft.item, 3), "###", Character.valueOf('#'), items.get(names[1]));
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.cylinder.item, 3), "# #", "# #", "###", Character.valueOf('#'), items.get(names[1]));
            TrainCraftingManager.instance.addRecipe(new ItemStack(BlockIDs.distilIdle.block, 1), "###", "#F#", "###", Character.valueOf('#'), items.get(names[1]), Character.valueOf('F'), ItemIDs.firebox.item);
            if (ConfigHandler.ORE_GEN) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.distilIdle.block, 1), (Object[])new Object[]{"###", "#P#", "###", Character.valueOf('#'), items.get(names[1]), Character.valueOf('P'), new ItemStack(BlockIDs.OreTC.block, 1, 2)});
                GameRegistry.addRecipe((ItemStack)new ItemStack(BlockIDs.distilIdle.block, 1), (Object[])new Object[]{"###", "#S#", "###", Character.valueOf('#'), items.get(names[1]), Character.valueOf('S'), new ItemStack(BlockIDs.OreTC.block, 1, 1)});
            }
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.boiler.item, 2), "###", "XXX", "###", Character.valueOf('#'), items.get(names[1]), Character.valueOf('X'), Item.field_77786_ax);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.firebox.item, 2), "###", "#X#", "###", Character.valueOf('#'), items.get(names[1]), Character.valueOf('X'), Item.field_77709_i);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.bogie.item, 4), " # ", "#X#", " # ", Character.valueOf('#'), items.get(names[1]), Character.valueOf('X'), Item.field_77703_o);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.steelframe.item, 2), "# #", "AAA", Character.valueOf('A'), items.get(names[1]), Character.valueOf('#'), Item.field_77703_o);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.steelcab.item, 2), "##", "XX", Character.valueOf('X'), items.get(names[1]), Character.valueOf('#'), Block.field_71988_x);
            TrainCraftingManager.instance.addRecipe(new ItemStack(ItemIDs.steelchimney.item, 2), "# #", "# #", "# #", Character.valueOf('#'), items.get(names[1]));
            GameRegistry.addRecipe((ItemStack)new ItemStack(Item.field_77709_i, 2), (Object[])new Object[]{"* ", " #", Character.valueOf('*'), items.get(names[1]), Character.valueOf('#'), Item.field_77804_ap});
        }
    }

    public static HashMap getItems() {
        return items;
    }

    public static String[] getNames() {
        return names;
    }
}

