/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.core.managers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import src.train.common.api.crafting.ITierCraftingManager;
import src.train.common.api.crafting.ITierRecipe;
import src.train.common.core.managers.TierRecipe;

public class TierRecipeManager
implements ITierCraftingManager {
    private final List recipeList = new ArrayList();
    private static TierRecipeManager instance = new TierRecipeManager();

    public static ITierCraftingManager getInstance() {
        return instance;
    }

    @Override
    public void addRecipe(ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output) {
        this.addRecipeFinal(1, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, 1);
    }

    @Override
    public void addRecipe(int tier, ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output) {
        if (tier > 0 && tier < 4) {
            this.addRecipeFinal(tier, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, 1);
        } else {
            this.addRecipeFinal(1, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, 1);
        }
    }

    @Override
    public void addRecipe(ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output, int outputSize) {
        if (outputSize > 0 && outputSize < 65) {
            this.addRecipeFinal(1, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, outputSize);
        } else {
            this.addRecipeFinal(1, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, 1);
        }
    }

    @Override
    public void addRecipe(int tier, ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output, int outputSize) {
        if (tier > 0 && tier < 4 && outputSize > 0 && outputSize < 65) {
            this.addRecipeFinal(tier, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, outputSize);
        } else {
            this.addRecipeFinal(1, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, 1);
        }
    }

    public void addRecipeFinal(int tier, ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output, int outputSize) {
        this.recipeList.add(new TierRecipe(tier, planks, wheels, frame, coupler, chimney, cab, boiler, firebox, additional, dye, output, outputSize));
    }

    private boolean recipeAlreadyExists(int tier, ItemStack planks, ItemStack wheels, ItemStack frame, ItemStack coupler, ItemStack chimney, ItemStack cab, ItemStack boiler, ItemStack firebox, ItemStack additional, ItemStack dye, ItemStack output) {
        boolean exists = false;
        ArrayList list = new ArrayList(this.recipeList);
        ArrayList<Integer> checks = new ArrayList<Integer>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(0, planks);
        items.add(1, wheels);
        items.add(2, frame);
        items.add(3, coupler);
        items.add(4, chimney);
        items.add(5, cab);
        items.add(6, boiler);
        items.add(7, firebox);
        items.add(8, additional);
        items.add(9, dye);
        for (int i = 0; i < list.size(); ++i) {
            TierRecipe recipe = (TierRecipe)list.get(i);
            for (int j = 0; j < 10; ++j) {
                if (recipe.getRecipeIn(j) == null && items.get(j) == null) {
                    checks.add(0);
                    continue;
                }
                if (recipe.getRecipeIn(j) == null && items.get(j) != null || recipe.getRecipeIn(j) != null && items.get(j) == null) {
                    checks.add(1);
                    continue;
                }
                if (recipe.getRecipeIn((int)j).field_77993_c == ((ItemStack)items.get((int)j)).field_77993_c) {
                    checks.add(0);
                    continue;
                }
                checks.add(1);
            }
            if (checks.contains(0) && recipe.getTier() == tier && recipe.getOutput().field_77993_c == output.field_77993_c) {
                exists = true;
                break;
            }
            checks = new ArrayList();
        }
        return exists;
    }

    @Override
    public ITierRecipe getRecipe(ItemStack output) {
        ArrayList list = new ArrayList(this.recipeList);
        if (output != null) {
            for (int i = 0; i < list.size(); ++i) {
                TierRecipe recipe = (TierRecipe)list.get(i);
                if (recipe == null || recipe.getOutput().field_77993_c != output.field_77993_c) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public ITierRecipe getTierRecipe(int tier, ItemStack output) {
        ArrayList list = new ArrayList(this.recipeList);
        if (output != null) {
            for (int i = 0; i < list.size(); ++i) {
                TierRecipe recipe = (TierRecipe)list.get(i);
                if (recipe == null || recipe.getOutput().field_77993_c != output.field_77993_c || recipe.getTier() != tier) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public List getRecipeList() {
        ArrayList list = new ArrayList(this.recipeList);
        return list;
    }

    @Override
    public List getTierRecipeList(int tier) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.recipeList.size(); ++i) {
            if (((TierRecipe)this.recipeList.get(i)).getTier() != tier) continue;
            list.add(this.recipeList.get(i));
        }
        return list;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeList.size();
    }

    @Override
    public int getRecipeTierSize(int tier) {
        return this.getTierRecipeList(tier).size();
    }
}

